/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public abstract class TiffProfileDLF
extends TiffProfile {
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        return this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1});
    }

    protected boolean hasMinimumResolution(TiffIFD tiffIFD, double d, double d2) {
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        Rational rational = nisoImageMetadata.getXSamplingFrequency();
        Rational rational2 = nisoImageMetadata.getYSamplingFrequency();
        if (rational == null || rational2 == null) {
            return false;
        }
        int n = nisoImageMetadata.getSamplingFrequencyUnit();
        if (n == 2) {
            if (rational.toDouble() < d || rational2.toDouble() < d) {
                return false;
            }
        } else if (n == 3) {
            if (rational.toDouble() < d2 || rational2.toDouble() < d2) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

