/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassP
extends TiffProfile {
    public TiffProfileClassP() {
        this._profileText = "Baseline palette-color (Class P)";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getImageWidth() == -1L || nisoImageMetadata.getImageLength() == -1L || nisoImageMetadata.getStripOffsets() == null || nisoImageMetadata.getRowsPerStrip() == -1L || nisoImageMetadata.getStripByteCounts() == null || nisoImageMetadata.getXSamplingFrequency() == null || nisoImageMetadata.getYSamplingFrequency() == null || nisoImageMetadata.getColormapBitCodeValue() == null || nisoImageMetadata.getColormapRedValue() == null || nisoImageMetadata.getColormapGreenValue() == null || nisoImageMetadata.getColormapBlueValue() == null) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 4 && nArray[0] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 3)) {
            return false;
        }
        return this.satisfiesResolutionUnit(tiffIFD, new int[]{1, 2, 3});
    }
}

