/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.context;

import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import uk.gov.nationalarchives.droid.command.action.CheckSignatureUpdateCommand;
import uk.gov.nationalarchives.droid.command.action.ConfigureDefaultSignatureFileVersionCommand;
import uk.gov.nationalarchives.droid.command.action.DisplayDefaultSignatureFileVersionCommand;
import uk.gov.nationalarchives.droid.command.action.DownloadSignatureUpdateCommand;
import uk.gov.nationalarchives.droid.command.action.ExportCommand;
import uk.gov.nationalarchives.droid.command.action.ListAllSignatureFilesCommand;
import uk.gov.nationalarchives.droid.command.action.ListReportsCommand;
import uk.gov.nationalarchives.droid.command.action.NoProfileRunCommand;
import uk.gov.nationalarchives.droid.command.action.ProfileRunCommand;
import uk.gov.nationalarchives.droid.command.action.ReportCommand;
import uk.gov.nationalarchives.droid.command.context.GlobalContext;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;

public final class SpringUiContext
implements GlobalContext {
    private final AbstractXmlApplicationContext context;

    private SpringUiContext(AbstractXmlApplicationContext context) {
        this.context = context;
    }

    public static GlobalContext getInstance() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("classpath*:/META-INF/ui-spring.xml");
        context.registerShutdownHook();
        return new SpringUiContext((AbstractXmlApplicationContext)context);
    }

    @Override
    public DroidGlobalConfig getGlobalConfig() {
        return (DroidGlobalConfig)this.context.getBean("globalConfig", DroidGlobalConfig.class);
    }

    @Override
    public ProfileRunCommand getProfileRunCommand() {
        return (ProfileRunCommand)this.context.getBean("profileRunCommand", ProfileRunCommand.class);
    }

    @Override
    public NoProfileRunCommand getNoProfileRunCommand() {
        return (NoProfileRunCommand)this.context.getBean("noProfileRunCommand", NoProfileRunCommand.class);
    }

    @Override
    public ExportCommand getExportCommand(ExportOptions opt) {
        ExportCommand command = (ExportCommand)this.context.getBean("exportCommand", ExportCommand.class);
        command.setExportOptions(opt);
        return command;
    }

    @Override
    public ReportCommand getReportCommand() {
        return (ReportCommand)this.context.getBean("reportCommand", ReportCommand.class);
    }

    @Override
    public CheckSignatureUpdateCommand getCheckSignatureUpdateCommand() {
        return (CheckSignatureUpdateCommand)this.context.getBean("checkSignatureUpdateCommand", CheckSignatureUpdateCommand.class);
    }

    @Override
    public DownloadSignatureUpdateCommand getDownloadSignatureUpdateCommand() {
        return (DownloadSignatureUpdateCommand)this.context.getBean("downloadSignatureUpdateCommand", DownloadSignatureUpdateCommand.class);
    }

    @Override
    public DisplayDefaultSignatureFileVersionCommand getDisplayDefaultSignatureFileVersionCommand() {
        return (DisplayDefaultSignatureFileVersionCommand)this.context.getBean("displayDefaultSignatureVersion", DisplayDefaultSignatureFileVersionCommand.class);
    }

    @Override
    public ConfigureDefaultSignatureFileVersionCommand getConfigureDefaultSignatureFileVersionCommand() {
        return (ConfigureDefaultSignatureFileVersionCommand)this.context.getBean("configureDefaultSignatureVersion", ConfigureDefaultSignatureFileVersionCommand.class);
    }

    @Override
    public ListAllSignatureFilesCommand getListAllSignatureFilesCommand() {
        return (ListAllSignatureFilesCommand)this.context.getBean("listAllSignatureFilesCommand", ListAllSignatureFilesCommand.class);
    }

    @Override
    public void close() {
        this.context.close();
    }

    @Override
    public ListReportsCommand getListReportsCommand() {
        return (ListReportsCommand)this.context.getBean("listReportsCommand", ListReportsCommand.class);
    }
}

