/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.enums;

public enum IeDeliveryRule {
    OWNER(101, "objectCharacteristics", "owner"),
    IE_ENTITY_TYPE(3, "generalIECharacteristics", "IEEntityType"),
    IS_STAFF(3),
    USER_IDS(3),
    BROWSER_TYPE("*", 1),
    REQUEST_PARAMETERS(17);

    private final String defaultValue;
    private final int operator;
    private final String dnxSection;
    private final String dnxSectionKey;

    private IeDeliveryRule(String defaultValue, int operator) {
        this.defaultValue = defaultValue;
        this.operator = operator;
        this.dnxSection = null;
        this.dnxSectionKey = null;
    }

    private IeDeliveryRule(int operator) {
        this.defaultValue = null;
        this.operator = operator;
        this.dnxSection = null;
        this.dnxSectionKey = null;
    }

    private IeDeliveryRule(int operator, String dnxSection, String dnxSectionKey) {
        this.defaultValue = null;
        this.operator = operator;
        this.dnxSection = dnxSection;
        this.dnxSectionKey = dnxSectionKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getDnxSection() {
        return this.dnxSection;
    }

    public String getDnxSectionKey() {
        return this.dnxSectionKey;
    }
}

