/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import org.apache.fop.util.CharUtilities;

public final class UTF32 {
    private UTF32() {
    }

    public static Integer[] toUTF32(String s, int substitution, boolean errorOnSubstitution) throws IllegalArgumentException {
        int n = s.length();
        if (n == 0) {
            return new Integer[0];
        }
        Integer[] sa = new Integer[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            int c = s.charAt(i);
            if (c >= 55296 && c < 57344) {
                char s2;
                int s1 = c;
                char c2 = s2 = i + 1 < n ? s.charAt(i + 1) : (char)'\u0000';
                if (s1 < 56320) {
                    if (s2 >= '\udc00' && s2 < '\ue000') {
                        c = (s1 - 55296 << 10) + (s2 - 56320) + 65536;
                        ++i;
                    } else {
                        if (errorOnSubstitution) {
                            throw new IllegalArgumentException("isolated high (leading) surrogate");
                        }
                        c = substitution;
                    }
                } else {
                    if (errorOnSubstitution) {
                        throw new IllegalArgumentException("isolated low (trailing) surrogate");
                    }
                    c = substitution;
                }
            }
            sa[k++] = c;
        }
        if (k == n) {
            return sa;
        }
        Integer[] na = new Integer[k];
        System.arraycopy(sa, 0, na, 0, k);
        return na;
    }

    public static String fromUTF32(Integer[] sa) throws IllegalArgumentException {
        StringBuffer sb = new StringBuffer();
        Integer[] arr$ = sa;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int s = arr$[i$];
            if (s < 65535) {
                if (s < 55296 || s > 57343) {
                    sb.append((char)s);
                    continue;
                }
                String ncr = CharUtilities.charToNCRef(s);
                throw new IllegalArgumentException("illegal scalar value 0x" + ncr.substring(2, ncr.length() - 1) + "; cannot be UTF-16 surrogate");
            }
            if (s < 0x110000) {
                int s1 = (s - 65536 >> 10 & 0x3FF) + 55296;
                int s2 = (s - 65536 >> 0 & 0x3FF) + 56320;
                sb.append((char)s1);
                sb.append((char)s2);
                continue;
            }
            String ncr = CharUtilities.charToNCRef(s);
            throw new IllegalArgumentException("illegal scalar value 0x" + ncr.substring(2, ncr.length() - 1) + "; out of range for UTF-16");
        }
        return sb.toString();
    }
}

