/*
 * Decompiled with CFR 0.152.
 */
package net.harawata.appdirs.impl;

import net.harawata.appdirs.AppDirs;

public class UnixAppDirs
extends AppDirs {
    public static final String XDG_CONFIG_DIRS = "XDG_CONFIG_DIRS";
    public static final String XDG_DATA_DIRS = "XDG_DATA_DIRS";
    public static final String XDG_CACHE_HOME = "XDG_CACHE_HOME";
    public static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    public static final String XDG_DATA_HOME = "XDG_DATA_HOME";

    @Override
    public String getUserDataDir(String appName, String appVersion, String appAuthor, boolean roaming) {
        String dir = System.getProperty(XDG_DATA_HOME, this.buildPath(this.home(), "/.local/share"));
        return this.buildPath(dir, appName, appVersion);
    }

    @Override
    public String getUserConfigDir(String appName, String appVersion, String appAuthor, boolean roaming) {
        String dir = System.getProperty(XDG_CONFIG_HOME, this.buildPath(this.home(), "/.config"));
        return this.buildPath(dir, appName, appVersion);
    }

    @Override
    public String getUserCacheDir(String appName, String appVersion, String appAuthor) {
        String dir = System.getProperty(XDG_CACHE_HOME, this.buildPath(this.home(), "/.cache"));
        return this.buildPath(dir, appName, appVersion);
    }

    @Override
    public String getSiteDataDir(String appName, String appVersion, String appAuthor, boolean multiPath) {
        String xdgDirs = System.getProperty(XDG_DATA_DIRS);
        if (xdgDirs == null) {
            String primary = this.buildPath("/usr/local/share", appName, appVersion);
            String secondary = this.buildPath("/usr/share", appName, appVersion);
            return multiPath ? this.joinPaths(primary, secondary) : primary;
        }
        String[] xdgDirArr = this.splitPaths(xdgDirs);
        if (multiPath) {
            return this.buildMultiPaths(appName, appVersion, xdgDirArr);
        }
        return this.buildPath(xdgDirArr[0], appName, appVersion);
    }

    @Override
    public String getSiteConfigDir(String appName, String appVersion, String appAuthor, boolean multiPath) {
        String xdgDirs = System.getProperty(XDG_CONFIG_DIRS);
        if (xdgDirs == null) {
            return this.buildPath("/etc/xdg", appName, appVersion);
        }
        String[] xdgDirArr = this.splitPaths(xdgDirs);
        if (multiPath) {
            return this.buildMultiPaths(appName, appVersion, xdgDirArr);
        }
        return this.buildPath(xdgDirArr[0], appName, appVersion);
    }

    protected String buildMultiPaths(String appName, String appVersion, String[] xdgDirArr) {
        int dirNum = xdgDirArr.length;
        String[] newDirs = new String[dirNum];
        for (int i = 0; i < dirNum; ++i) {
            newDirs[i] = this.buildPath(xdgDirArr[i], appName, appVersion);
        }
        return this.joinPaths(newDirs);
    }

    @Override
    public String getUserLogDir(String appName, String appVersion, String appAuthor) {
        String dir = System.getProperty(XDG_CACHE_HOME, this.buildPath(this.home(), "/.cache"));
        return this.buildPath(dir, appName, "/logs", appVersion);
    }
}

