/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.tools.out.Tracer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;

public class LevelOfDescriptionSet {
    private final Map<String, LevelOfDescription> all = new HashMap<String, LevelOfDescription>();
    private final List<LevelOfDescription> allOrdered = new Vector<LevelOfDescription>();

    public static void main(String[] args) {
        LevelOfDescriptionSet levels = new LevelOfDescriptionSet();
        for (LevelOfDescription l : levels.allOrdered) {
            Tracer.trace((Object)l);
        }
        Tracer.trace((Object)levels.get("Serie"));
        Tracer.trace((Object)levels.get("Denis"));
        for (LevelOfDescription l : levels.allOrdered) {
            Tracer.trace((Object)l);
        }
    }

    public LevelOfDescriptionSet() {
        for (LevelOfDescription l : LevelOfDescription.getAll()) {
            this.all.put(l.getName(), l);
            this.allOrdered.add(l);
        }
    }

    public LevelOfDescription insertNewIfNecessary(String name) {
        if (this.all.containsKey(name)) {
            return this.all.get(name);
        }
        LevelOfDescription newLevel = new LevelOfDescription(name, this.all.size());
        this.all.put(newLevel.getName(), newLevel);
        this.allOrdered.add(newLevel);
        return newLevel;
    }

    public LevelOfDescription getUndefined() {
        return this.allOrdered.get(0);
    }

    public LevelOfDescription get(String name) {
        return this.insertNewIfNecessary(name);
    }

    public LevelOfDescription get(int i) {
        return this.allOrdered.get(i);
    }

    public List<LevelOfDescription> getAll() {
        return this.allOrdered;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[LevelsSet: ");
        for (LevelOfDescription l : this.allOrdered) {
            buf.append("(").append(l.toString()).append(") ");
        }
        buf.append("]");
        return buf.toString();
    }

    public Optional<LevelOfDescription> getTrashLevel() {
        Optional<LevelOfDescription> optionalLevel = Optional.empty();
        List<LevelOfDescription> levels = this.getAll();
        for (LevelOfDescription level : levels) {
            if (!level.isTrash().booleanValue()) continue;
            optionalLevel = Optional.of(level);
        }
        return optionalLevel;
    }
}

