/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.exceptions.CantCreateTemplateWithRootFileException;
import ch.docuteam.darc.exceptions.DocumentIsReadOnlyException;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FileOrFolderIsInUseException;
import ch.docuteam.darc.exceptions.FolderIsNotEmptyException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.exceptions.MetadataElementCantDeleteException;
import ch.docuteam.darc.exceptions.NodeWithLevelNotRemovableException;
import ch.docuteam.darc.exceptions.OriginalSIPIsMissingException;
import ch.docuteam.darc.exceptions.ZIPDoesNotContainMETSFileException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElementInstance;
import ch.docuteam.darc.mets.amdsec.AMDSection;
import ch.docuteam.darc.mets.dmdsec.DMDSectionAbstract;
import ch.docuteam.darc.mets.filesec.FileSection;
import ch.docuteam.darc.mets.metshdr.Header;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.exception.ExceptionCollectorException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.out.Tracer;
import ch.docuteam.tools.string.DateFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Vector;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Document
extends DocumentAbstract {
    public static final String DOCUMENT_NAME_SUFFIX_PART_COPY = "_COPY_";
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_METS_FILE_NAME = "mets.xml";
    public static final String LOCK_FILE_SUFFIX = ".lock";
    public static final String WORKING_FOLDER_PREFIX = "METSDocument_read_";
    public static final String WORKING_FOLDER_PREFIX_READ_ZIP = "METSDocument_readZIP_";
    public static final String WORKING_FOLDER_PREFIX_CREATE_ZIP = "METSDocument_createZIP_";
    protected static final String DefaultMETS_SIPTemplateFile = "/templates/mets_sip.xml";
    protected static final Integer DefaultKeepBackupsCount = 10;
    protected static String METS_SIPTemplateFile = "/templates/mets_sip.xml";
    protected static String BackupFolder = null;
    protected static Integer KeepBackupsCount = DefaultKeepBackupsCount;
    protected Mode mode = Mode.Undefined;
    protected String originalSIPFolder;
    public boolean isWorkingCopy = true;
    protected String lockedBy;
    protected String namespaceMETS;
    protected String namespacePREMIS;
    protected String profile;
    protected String label;
    protected String type;
    protected String saId;
    protected String dssId;
    protected String objId;
    protected Header header;
    protected Map<String, DMDSectionAbstract> dmdSections = new HashMap<String, DMDSectionAbstract>();
    protected AMDSection amdSection;
    protected FileSection fileSection;
    protected StructureMap structureMap;
    protected String currentOperatorName;
    protected SubmissionAgreement submissionAgreement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        String desktop = OperatingSystem.userHome() + "Desktop";
        String workspace = desktop + "/Workspace/Packer";
        FileUtil.setTempFolder((String)(workspace + "/Temp"));
        Document.setBackupFolder(workspace + "/Backups");
        Document doc = null;
        try {
            doc = Document.createNewWithRootFolderName(OperatingSystem.userHome() + "/Desktop/SIPs/Test", "TopFolder", "sa_all-formats-01", "dss-01", "Document.main");
        }
        catch (Throwable x) {
            Logger.error((Object)x.getMessage(), (Throwable)x);
        }
        finally {
            if (!ExceptionCollector.isEmpty().booleanValue()) {
                Tracer.trace((Object)ExceptionCollector.toStringAll());
            }
            try {
                if (doc != null) {
                    doc.unlockIfNecessary();
                    doc.cleanupWorkingCopy();
                }
            }
            catch (java.lang.Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBackupFolder(String backupFolder) {
        BackupFolder = backupFolder;
    }

    public static void setKeepBackupsCount(Integer keepBackupsCount) {
        if (keepBackupsCount == null) {
            return;
        }
        if (keepBackupsCount < 0) {
            throw new IllegalArgumentException("KeepBackupsCount must not be negative: " + keepBackupsCount);
        }
        KeepBackupsCount = keepBackupsCount;
    }

    public static Document createNewFromTemplate(String templatePath, String zipOrMETSFilePath, String operatorName) throws java.lang.Exception {
        return Document.createNewFromTemplate(templatePath, zipOrMETSFilePath, operatorName, null);
    }

    public static Document createNewFromTemplate(String templateFolderPath, String zipOrMETSFilePath, String operatorName, Observer observer) throws java.lang.Exception {
        Document document;
        if (zipOrMETSFilePath.toLowerCase().endsWith(".zip")) {
            String sipFolderPath = FileUtil.asFilePathWithoutExtension((String)zipOrMETSFilePath);
            FileUtil.copyToOverwriting((String)templateFolderPath, (String)sipFolderPath);
            Zipper.zip((String)sipFolderPath, (String)zipOrMETSFilePath, (boolean)true);
            FileUtil.delete((String)sipFolderPath);
            document = Document.openReadWrite(zipOrMETSFilePath, operatorName, observer);
        } else {
            FileUtil.copyToOverwriting((String)templateFolderPath, (String)zipOrMETSFilePath);
            document = Document.openReadWrite(zipOrMETSFilePath + "/" + DEFAULT_METS_FILE_NAME, operatorName, observer);
        }
        for (NodeAbstract node : document.getStructureMap().getRoot().getWithDescendants()) {
            node.initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed();
        }
        document.saveWithoutBackup();
        return document;
    }

    public static Document createNewWithRoot(String newZIPOrFolderFilePath, String sourceFilePath, String saId, String dssId, String operatorName) throws java.lang.Exception {
        return Document.createNewWithRoot(newZIPOrFolderFilePath, sourceFilePath, saId, dssId, operatorName, null);
    }

    public static Document createNewWithRoot(String newZIPOrFolderFilePath, String sourceFilePath, String saId, String dssId, String operatorName, Observer observer) throws java.lang.Exception {
        if (!new File(sourceFilePath).exists()) {
            throw new FileNotFoundException(sourceFilePath);
        }
        Document document = Document.createEmpty(newZIPOrFolderFilePath, saId, dssId, operatorName, observer);
        try {
            document.structureMap.createRootNode(sourceFilePath);
        }
        catch (FileOperationNotAllowedException fileOperationNotAllowedException) {
            // empty catch block
        }
        document.saveWithoutBackup();
        return document;
    }

    public static Document createNewWithRootFolderName(String newZIPOrFolderFilePath, String rootFolderName, String saId, String dssId, String operatorName) throws java.lang.Exception {
        return Document.createNewWithRootFolderName(newZIPOrFolderFilePath, rootFolderName, saId, dssId, operatorName, null);
    }

    public static Document createNewWithRootFolderName(String newZIPOrFolderFilePath, String rootFolderName, String saId, String dssId, String operatorName, Observer observer) throws java.lang.Exception {
        if (rootFolderName == null || rootFolderName.isEmpty()) {
            throw new FolderNameIsEmptyException();
        }
        Document document = Document.createEmpty(newZIPOrFolderFilePath, saId, dssId, operatorName, observer);
        try {
            document.structureMap.createNewRootFolder(rootFolderName);
        }
        catch (FileOperationNotAllowedException fileOperationNotAllowedException) {
            // empty catch block
        }
        document.saveWithoutBackup();
        return document;
    }

    public static Document openReadWriteFilesLocked(String sipPath, String operatorName) throws java.lang.Exception {
        return Document.openReadWriteFilesLocked(sipPath, operatorName, null);
    }

    public static Document openReadWriteFilesLocked(String sipPath, String operatorName, Observer observer) throws java.lang.Exception {
        return Document.open(sipPath, Mode.ReadWriteNoFileOps, operatorName, observer);
    }

    public static Document openReadOnly(String sipPath, String operatorName) throws java.lang.Exception {
        return Document.openReadOnly(sipPath, operatorName, null);
    }

    public static Document openReadOnly(String sipPath, String operatorName, Observer observer) throws java.lang.Exception {
        return Document.open(sipPath, Mode.ReadOnly, operatorName, observer);
    }

    public static Document openReadWrite(String sipPath, String operatorName) throws java.lang.Exception {
        return Document.openReadWrite(sipPath, operatorName, null);
    }

    public static Document openReadWrite(String sipPath, String operatorName, Observer observer) throws java.lang.Exception {
        return Document.open(sipPath, Mode.ReadWrite, operatorName, observer);
    }

    public static void setMETS_SIPTemplateFile(String newMETS_SIPTemplateFile) {
        METS_SIPTemplateFile = newMETS_SIPTemplateFile;
    }

    public static String getBackupFolder() {
        return BackupFolder;
    }

    public static Integer getKeepBackupsCount() {
        return KeepBackupsCount;
    }

    public static boolean isZIPFile(File sip) {
        return Document.isZIPFile(sip.getName());
    }

    public static boolean isZIPFile(String sipName) {
        return sipName.toLowerCase().endsWith(".zip");
    }

    public static boolean isValidSIPFolder(String folderPath) {
        return Document.isValidSIPFolder(new File(folderPath));
    }

    public static boolean isValidSIPFolder(File folder) {
        if (folder == null || !folder.exists() || !folder.canRead() || folder.isFile()) {
            return false;
        }
        return new File(folder.getAbsolutePath() + File.separator + DEFAULT_METS_FILE_NAME).exists();
    }

    public static boolean check(String metsFileName) {
        return Document.check(metsFileName, true);
    }

    public static boolean check(String metsFileName, boolean regardMissingFilesAsErrors) {
        Document document = null;
        ExceptionCollector.clear();
        try {
            document = Document.openReadOnly(metsFileName, null);
        }
        catch (java.lang.Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (regardMissingFilesAsErrors && document.isAtLeastOneFileNotReadable) {
            for (NodeAbstract n : document.getStructureMap().getRoot().getWithDescendants()) {
                File f = n.getFile();
                if (f.exists()) continue;
                Exception.remember((Throwable)new FileNotFoundException(f.getPath()));
            }
        }
        return ExceptionCollector.isEmpty();
    }

    public static boolean isLocked(File sip) {
        return Document.isLocked(sip.getPath());
    }

    public static boolean isLocked(String sipName) {
        return Document.lockedByWhom(sipName) != null;
    }

    public static boolean isLockedBySomebodyElse(File sip) {
        return Document.isLockedBySomebodyElse(sip.getPath());
    }

    public static boolean isLockedBySomebodyElse(String sipName) {
        String lockedBy = Document.lockedByWhom(sipName);
        if (lockedBy == null) {
            return false;
        }
        return !OperatingSystem.userName().equals(lockedBy);
    }

    public static String lockedByWhom(File sip) {
        return Document.lockedByWhom(sip.getPath());
    }

    public static String lockedByWhom(String sipName) {
        File lockFile = new File(sipName + LOCK_FILE_SUFFIX);
        if (!lockFile.exists()) {
            return null;
        }
        return FileUtil.getFileContentAsString((File)lockFile).trim();
    }

    public static void copy(String sourceSIPPath, String targetSIPPath) throws IOException, FileUtilExceptionListException {
        if (Document.isZIPFile(sourceSIPPath)) {
            if (Document.isZIPFile(targetSIPPath)) {
                FileUtil.copyToOverwriting((String)sourceSIPPath, (String)targetSIPPath);
            } else {
                Zipper.unzip((String)sourceSIPPath, (String)targetSIPPath);
            }
        } else if (Document.isZIPFile(targetSIPPath)) {
            Zipper.zip((String)sourceSIPPath, (String)targetSIPPath, (boolean)true);
        } else {
            FileUtil.copyToOverwriting((String)sourceSIPPath, (String)targetSIPPath);
        }
    }

    private static Document createEmpty(String newZIPOrFolderFilePath, String saId, String dssId, String operatorName, Observer observer) throws java.lang.Exception {
        File newZIPOrFolderFile = new File(newZIPOrFolderFilePath);
        if (newZIPOrFolderFile.exists()) {
            if (newZIPOrFolderFile.isFile()) {
                throw new FileAlreadyExistsException(newZIPOrFolderFile.getName(), newZIPOrFolderFile.getParent());
            }
            if (newZIPOrFolderFile.isDirectory() && newZIPOrFolderFile.list().length != 0) {
                throw new FolderIsNotEmptyException(newZIPOrFolderFilePath);
            }
        }
        if (FileUtil.asFileNameExtension((String)newZIPOrFolderFilePath).toLowerCase().equals("zip")) {
            String destinationFolderPath = newZIPOrFolderFile.getParent();
            String metsFilePath = destinationFolderPath + File.separator + DEFAULT_METS_FILE_NAME;
            Document.initializeEmptyMetsFile(metsFilePath, saId, dssId);
            Zipper.zip((String)metsFilePath, (String)newZIPOrFolderFilePath);
            FileUtil.delete((String)metsFilePath);
        } else {
            String metsFilePath = newZIPOrFolderFilePath + File.separator + DEFAULT_METS_FILE_NAME;
            newZIPOrFolderFile.mkdirs();
            Document.initializeEmptyMetsFile(metsFilePath, saId, dssId);
        }
        Document document = Document.openReadWrite(newZIPOrFolderFilePath, operatorName, observer);
        return document;
    }

    private static void initializeEmptyMetsFile(String metsFilePath, String saId, String dssId) throws DocumentException, IOException, FileUtilExceptionListException {
        ResourceUtil.copyResourceFile((String)METS_SIPTemplateFile, (String)metsFilePath);
        SAXReader reader = new SAXReader();
        org.dom4j.Document document = reader.read(new File(metsFilePath));
        document.getRootElement().addAttribute("TYPE", saId + "_" + dssId);
        Document.writeMETSFile(document, metsFilePath);
    }

    private static Document open(String sipPath, Mode mode, String operatorName, Observer observer) throws java.lang.Exception {
        if (!new File(sipPath).exists()) {
            throw new FileNotFoundException(sipPath);
        }
        String originalSIPFolder = null;
        String metsFilePath = null;
        if (sipPath.endsWith(".zip") || sipPath.endsWith(".ZIP")) {
            File metsFile;
            Logger.info((Object)("Opening zipped SIP in mode: '" + (Object)((Object)mode) + "': '" + sipPath + "'"));
            String sipName = new File(sipPath).getName();
            sipName = sipName.substring(0, sipName.length() - 4);
            Path tempMetsDir = Files.createTempDirectory(Paths.get(FileUtil.getTempFolder(), new String[0]), WORKING_FOLDER_PREFIX_READ_ZIP, new FileAttribute[0]);
            String workingFolder2 = Paths.get(tempMetsDir.toString(), sipName).toString();
            Zipper.unzip((String)sipPath, (String)workingFolder2);
            if (mode.equals((Object)Mode.ReadOnly)) {
                FileUtil.deleteOnExit((String)workingFolder2);
            }
            if (!(metsFile = new File(workingFolder2 + File.separator + DEFAULT_METS_FILE_NAME)).exists()) {
                try {
                    FileUtil.delete((String)new File(workingFolder2).getParent());
                }
                catch (FileUtilExceptionListException ex) {
                    Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                throw new ZIPDoesNotContainMETSFileException(sipPath);
            }
            originalSIPFolder = sipPath;
            metsFilePath = FileUtil.asCanonicalFileName((File)metsFile);
        } else {
            if (new File(sipPath).isFile()) {
                originalSIPFolder = new File(sipPath).getParent();
            } else {
                originalSIPFolder = sipPath;
                sipPath = sipPath + File.separator + DEFAULT_METS_FILE_NAME;
            }
            if (Document.isLockedBySomebodyElse(originalSIPFolder) || mode == Mode.ReadOnly || mode == Mode.ReadWriteNoFileOps) {
                originalSIPFolder = null;
                metsFilePath = FileUtil.asCanonicalFileName((String)sipPath);
                Logger.info((Object)("Opening SIP directly in mode: '" + (Object)((Object)mode) + "': '" + sipPath + "'"));
            } else {
                Path tempMetsDir = Files.createTempDirectory(Paths.get(FileUtil.getTempFolder(), new String[0]), WORKING_FOLDER_PREFIX, new FileAttribute[0]);
                String workingFolder = tempMetsDir.toString();
                try {
                    FileUtil.copyToFolderOverwriting((String)originalSIPFolder, (String)workingFolder, (boolean)true);
                }
                catch (FileUtilExceptionListException workingFolder2) {
                    // empty catch block
                }
                metsFilePath = FileUtil.asCanonicalFileName((String)(workingFolder + File.separator + FileUtil.asFileName((String)originalSIPFolder) + File.separator + FileUtil.asFileName((String)sipPath)));
                Logger.info((Object)("Opening copy of SIP in mode: '" + (Object)((Object)mode) + "': '" + originalSIPFolder + "'"));
            }
        }
        Logger.debug((Object)("METS-file: '" + metsFilePath + "'"));
        File metsFile = new File(metsFilePath);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory((org.dom4j.DocumentFactory)new DocumentFactory());
        Document document = (Document)reader.read(metsFile);
        try {
            document.initialize(metsFilePath, originalSIPFolder, mode, operatorName, observer);
            return document;
        }
        catch (java.lang.Exception ex) {
            document.unlockIfNecessary();
            document.cleanupWorkingCopy();
            throw ex;
        }
    }

    public String getNamespaceMETS() {
        return this.namespaceMETS;
    }

    public String getNamespacePREMIS() {
        return this.namespacePREMIS;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.getRootElement().addAttribute("TYPE", type);
        this.setIsModified();
    }

    public String getSAId() {
        return this.saId;
    }

    public String getDSSId() {
        return this.dssId;
    }

    public String getObjectId() {
        return this.objId;
    }

    public void setObjectId(String objId) {
        this.objId = objId;
        this.getRootElement().addAttribute("OBJID", objId);
        this.setIsModified();
    }

    @Deprecated
    public String getSipFolder() {
        return this.getSIPFolder();
    }

    public String getSIPFolder() {
        Path p = Paths.get(this.filePath, new String[0]);
        String sipFolder = p.getParent().toString();
        return sipFolder;
    }

    @Deprecated
    public String getOriginalSipFolder() {
        return this.getOriginalSIPFolder();
    }

    public String getOriginalSIPFolder() {
        return this.originalSIPFolder;
    }

    public void setOriginalSIPFolder(String originalSIPFolder) {
        this.originalSIPFolder = originalSIPFolder;
    }

    @Deprecated
    public String getOriginalSipName() {
        return this.getSIPName();
    }

    public String getSIPName() {
        return FileUtil.asFileName((String)this.originalSIPFolder);
    }

    public Header getHeader() {
        return this.header;
    }

    public AMDSection getAMDSection() {
        return this.amdSection;
    }

    public Collection<DMDSectionAbstract> getDMDSections() {
        return this.dmdSections.values();
    }

    public DMDSectionAbstract getDMDSection(String id) {
        return this.dmdSections.get(id);
    }

    public void addDMDSection(DMDSectionAbstract dmdSection) {
        this.dmdSections.put(dmdSection.getId(), dmdSection);
        this.setIsModified();
    }

    public FileSection getFileSection() {
        return this.fileSection;
    }

    public StructureMap getStructureMap() {
        return this.structureMap;
    }

    public String getCurrentOperatorName() {
        return this.currentOperatorName;
    }

    public void setCurrentOperatorName(String opName) {
        this.currentOperatorName = opName;
        this.setIsModified();
    }

    public List<NodeFile> setSubmissionAgreement(String saId, String dssId) throws FileNotFoundException, DocumentException, ExceptionCollectorException {
        SubmissionAgreement submissionAgreement = SubmissionAgreement.read(saId + ".xml");
        if (submissionAgreement == null) {
            return null;
        }
        this.saId = submissionAgreement.getSaId();
        this.dssId = dssId;
        this.setType(this.saId + "_" + dssId);
        this.submissionAgreement = submissionAgreement;
        return this.filesNotAllowedBySubmissionAgreement();
    }

    public SubmissionAgreement getSubmissionAgreement() {
        if (this.saId == null || this.saId.isEmpty()) {
            return null;
        }
        try {
            if (this.submissionAgreement == null) {
                this.submissionAgreement = SubmissionAgreement.read(this.saId + ".xml");
            }
            return this.submissionAgreement;
        }
        catch (java.lang.Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public boolean isZIPFile() {
        return Document.isZIPFile(this.originalSIPFolder);
    }

    public boolean isWorkingCopy() {
        return this.isWorkingCopy;
    }

    public void setIsWorkingCopy(boolean isWorkingCopy) {
        this.isWorkingCopy = isWorkingCopy;
    }

    public boolean isReadOnly() {
        return this.mode == Mode.ReadOnly;
    }

    public boolean isLocked() {
        return this.mode == Mode.Locked;
    }

    public boolean isReadWrite() {
        return this.mode == Mode.ReadWrite;
    }

    public boolean isReadWriteNoFileOps() {
        return this.mode == Mode.ReadWriteNoFileOps;
    }

    public boolean canWrite() {
        return this.mode == Mode.ReadWrite || this.mode == Mode.ReadWriteNoFileOps;
    }

    public boolean areFileOperationsAllowed() {
        return this.mode == Mode.ReadWrite;
    }

    public boolean hasNodesWithDynamicMetadataElementInstancesWhichAreMandatoryButNotSet() {
        return this.structureMap.hasNodesWithDynamicMetadataElementInstancesWhichAreMandatoryButNotSet();
    }

    public boolean hasSubmittedNodes() {
        return this.structureMap.getRoot().getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.Submitted);
    }

    public boolean checkFixity() {
        return this.structureMap.checkFixity();
    }

    public boolean checkAgainstSubmissionAgreement() {
        return this.structureMap.checkAgainstSubmissionAgreement();
    }

    public List<NodeFile> filesNotAllowedBySubmissionAgreement() {
        return this.structureMap.filesNotAllowedBySubmissionAgreement();
    }

    public boolean checkAgainstSubmissionAgreement(SubmissionAgreement sa, String dssId) {
        return this.structureMap.checkAgainstSubmissionAgreement(sa, dssId);
    }

    public List<NodeFile> filesNotAllowedBySubmissionAgreement(SubmissionAgreement sa, String dssId) {
        return this.structureMap.filesNotAllowedBySubmissionAgreement(sa, dssId);
    }

    @Override
    public DocumentAbstract.Type getDocumentType() {
        return DocumentAbstract.Type.METS;
    }

    public void createEADFile(String eadFilePath) throws DocumentException, ExceptionCollectorException, IOException {
        ch.docuteam.darc.ead.Document eadDocument = ch.docuteam.darc.ead.Document.createEmpty();
        eadDocument.setId(this.getType());
        eadDocument.getArchDesc().initialize(this.structureMap.getRoot().getUnitTitle());
        eadDocument.getArchDesc().fillEADElementsFromNodeRecursively(this.structureMap.getRoot());
        eadDocument.saveAs(eadFilePath);
    }

    public void saveAndClose(boolean withBackup) throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException, OriginalSIPIsMissingException {
        this.save(withBackup, false);
    }

    public void saveWithBackup() throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException, OriginalSIPIsMissingException {
        if (this.isAtLeastOneFileNotReadable) {
            try {
                this.save(false);
            }
            catch (FileUtilExceptionListException fileUtilExceptionListException) {}
        } else if (this.isAtLeastOneFileNotWritable) {
            try {
                this.save(true);
            }
            catch (FileUtilExceptionListException fileUtilExceptionListException) {}
        } else {
            this.save(true);
        }
    }

    public void saveWithoutBackup() throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException {
        try {
            if (this.isAtLeastOneFileNotReadable) {
                try {
                    this.save(false);
                }
                catch (FileUtilExceptionListException fileUtilExceptionListException) {}
            } else if (this.isAtLeastOneFileNotWritable) {
                try {
                    this.save(false);
                }
                catch (FileUtilExceptionListException fileUtilExceptionListException) {}
            } else {
                this.save(false);
            }
        }
        catch (OriginalSIPIsMissingException originalSIPIsMissingException) {
            // empty catch block
        }
    }

    public void saveAs(String newMETSFilePath) throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException {
        if (newMETSFilePath.toLowerCase().endsWith(".xml")) {
            String oldMETSFileName = FileUtil.asFileName((String)this.filePath);
            String newSIPFolderPath = FileUtil.asParentPath((String)newMETSFilePath);
            String newMETSFileName = FileUtil.asFileName((String)newMETSFilePath);
            this.saveTo(newSIPFolderPath);
            File newFilePath = FileUtil.renameTo((String)this.filePath, (String)(this.getSIPFolder() + "/" + newMETSFileName));
            this.filePath = newFilePath.getPath();
            if (this.isWorkingCopy) {
                FileUtil.renameTo((String)(newSIPFolderPath + "/" + oldMETSFileName), (String)newMETSFilePath);
            }
        } else {
            this.saveTo(newMETSFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(String newSipFolder) throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException {
        boolean wasWorkingCopy = this.isWorkingCopy;
        try {
            this.isWorkingCopy = false;
            if (this.isModified) {
                this.saveWithoutBackup();
            }
            if (newSipFolder.toLowerCase().endsWith(".zip")) {
                ArrayList<String> files = new ArrayList<String>();
                for (File file : new File(this.getSIPFolder()).listFiles()) {
                    files.add(file.getPath());
                }
                Zipper.zip((String[])files.toArray(new String[0]), (String)newSipFolder);
            } else {
                FileUtil.copyToOverwriting((String)this.getSIPFolder(), (String)newSipFolder, (boolean)false);
            }
        }
        finally {
            this.unlockIfNecessary();
            if (wasWorkingCopy) {
                this.originalSIPFolder = newSipFolder;
                this.isWorkingCopy = true;
            } else {
                File newFile = new File(FileUtil.asCanonicalFileName((String)(newSipFolder + "/" + new File(this.filePath).getName())));
                this.filePath = newFile.getPath();
                this.originalSIPFolder = newFile.getParent();
            }
            this.mode = Mode.ReadWrite;
            this.lockIfPossibleAndRequired();
        }
    }

    public void saveAsTemplate(String templatePath) throws java.lang.Exception {
        if (this.structureMap.getRoot().isFile()) {
            throw new CantCreateTemplateWithRootFileException();
        }
        if (this.isModified) {
            this.saveWithoutBackup();
        }
        if (this.isWorkingCopy) {
            if (this.isZIPFile()) {
                Zipper.unzip((String)this.originalSIPFolder, (String)templatePath);
            } else {
                FileUtil.copyToOverwriting((String)this.originalSIPFolder, (String)templatePath, (boolean)false);
            }
        } else {
            FileUtil.copyToOverwriting((String)new File(this.filePath).getParent(), (String)templatePath, (boolean)false);
        }
        Document templateDocument = Document.openReadWrite(templatePath + "/" + DEFAULT_METS_FILE_NAME, "Document.saveAsTemplate");
        for (NodeFile f : ((NodeFolder)templateDocument.getStructureMap().getRoot()).getDescendantFiles()) {
            try {
                f.delete();
            }
            catch (FileOperationNotAllowedException fileOperationNotAllowedException) {}
        }
        for (NodeAbstract n : ((NodeFolder)templateDocument.getStructureMap().getRoot()).getWithDescendants()) {
            for (MetadataElementInstance mdei : n.getDynamicMetadataElementInstances()) {
                if (mdei.keepInTemplate()) continue;
                if (mdei.isRepeatable()) {
                    try {
                        n.deleteDynamicMetadataElementInstanceWithName(mdei.getName(), 0);
                    }
                    catch (MetadataElementCantDeleteException ex) {
                        n.setDynamicMetadataValueForName(mdei.getName(), 0, null);
                    }
                    continue;
                }
                try {
                    n.deleteDynamicMetadataElementInstanceWithName(mdei.getName(), mdei.getIndex());
                }
                catch (MetadataElementCantDeleteException ex) {
                    n.setDynamicMetadataValueForName_force(mdei.getName(), mdei.getIndex(), null);
                }
            }
        }
        templateDocument.saveWithoutBackup();
        templateDocument.unlockIfNecessary();
        templateDocument.cleanupWorkingCopy();
    }

    public void cleanupWorkingCopy() throws IOException, FileUtilExceptionListException {
        if (this.isWorkingCopy) {
            FileUtil.setWritable((File)new File(this.filePath).getParentFile().getParentFile());
            FileUtil.deleteOnExit((File)new File(this.filePath).getParentFile().getParentFile());
        }
    }

    public void revertToLastBackup() throws java.lang.Exception {
        if (!this.canWrite()) {
            throw new DocumentIsReadOnlyException(this);
        }
        String lastBackupFilePath = this.getLastBackupFilePath();
        if (lastBackupFilePath == null) {
            throw new FileNotFoundException("No backup file found: '" + this.originalSIPFolder + "'");
        }
        String securitySuffix = DOCUMENT_NAME_SUFFIX_PART_COPY + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS");
        FileUtil.renameTo((String)this.originalSIPFolder, (String)(this.originalSIPFolder + securitySuffix));
        FileUtil.moveTo((String)lastBackupFilePath, (String)this.originalSIPFolder);
        FileUtil.delete((String)(this.originalSIPFolder + securitySuffix));
        Mode originalMode = this.mode;
        this.unlock_dontCheck();
        this.cleanupWorkingCopy();
        Document newDoc = null;
        String lastMetsBackupFilePath = this.getLastMetsBackupFilePath();
        newDoc = lastMetsBackupFilePath == null ? Document.open(this.originalSIPFolder, originalMode, this.currentOperatorName, null) : Document.open(lastMetsBackupFilePath, Mode.ReadOnly, this.currentOperatorName, null);
        Element rootElement = newDoc.getRootElement();
        rootElement.detach();
        this.setRootElement(rootElement);
        this.initialize(newDoc.filePath, this.isWorkingCopy ? this.originalSIPFolder : null, originalMode, this.currentOperatorName, null);
    }

    public void lockAsSubmitRequestPending() {
        this.unlock();
        try {
            FileUtil.createFileWithContent((String)(this.originalSIPFolder + LOCK_FILE_SUFFIX), (String)NodeAbstract.SubmitStatus.getSubmitRequestPendingLockId());
            this.mode = Mode.Locked;
            this.lockedBy = NodeAbstract.SubmitStatus.getSubmitRequestPendingLockId();
            if (!this.isZIPFile()) {
                this.cleanupWorkingCopy();
                this.filePath = FileUtil.asCanonicalFileName((String)(this.getOriginalSIPFolder() + File.separator + DEFAULT_METS_FILE_NAME));
                this.isWorkingCopy = false;
            }
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void unlockIfNecessary() {
        if (this.lockedBy == null) {
            this.unlock();
        }
    }

    public boolean unlock_dontCheck() {
        try {
            FileUtil.delete((String)(this.originalSIPFolder + LOCK_FILE_SUFFIX));
            this.mode = Mode.Undefined;
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    @Deprecated
    public List<NodeAbstract> searchFor(String searchString) {
        Vector<NodeAbstract> searchHits = new Vector<NodeAbstract>();
        for (NodeAbstract node : this.structureMap.getRoot().getWithDescendants()) {
            if (!node.searchFor(searchString)) continue;
            searchHits.add(node);
        }
        return searchHits;
    }

    public List<NodeAbstract> searchForAllQuoted(String searchString) {
        Vector<NodeAbstract> searchHits = new Vector<NodeAbstract>();
        for (NodeAbstract node : this.structureMap.getRoot().getWithDescendants()) {
            if (!node.searchForAllQuoted(searchString)) continue;
            searchHits.add(node);
        }
        return searchHits;
    }

    public List<NodeAbstract> searchForAnyQuoted(String searchString) {
        Vector<NodeAbstract> searchHits = new Vector<NodeAbstract>();
        for (NodeAbstract node : this.structureMap.getRoot().getWithDescendants()) {
            if (!node.searchForAnyQuoted(searchString)) continue;
            searchHits.add(node);
        }
        return searchHits;
    }

    public void deleteDMDSection(DMDSectionAbstract dmdSection) {
        this.dmdSections.remove(dmdSection.getId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n====\tMETS-Document on '").append(this.filePath).append("'\t====\n====\tOriginal SIP:    '").append(this.originalSIPFolder).append("'\t====\n\t").append(this.label).append("/").append(this.type).append("/").append(this.objId).append(this.isModified ? " (modified)" : " (not modified)").append(this.isAtLeastOneFileNotReadable ? " (not all readable)" : " (all readable)").append(this.isAtLeastOneFileNotWritable ? " (not all writable)" : " (all writable)").append(" (").append((Object)this.mode).append(")").append(this.isWorkingCopy ? " (workingCopy)" : " (direct)").append(this.lockedBy == null ? "" : " (locked by: '" + this.lockedBy + "')").append(this.header);
        for (DMDSectionAbstract dmdSection : this.dmdSections.values()) {
            buf.append(dmdSection.toString());
        }
        buf.append(this.amdSection).append(this.fileSection).append(this.structureMap).append("\n");
        return buf.toString();
    }

    protected void initialize(String metsFilePath, String originalSIPFolder, Mode mode, String operatorName, Observer observer) {
        this.mode = mode;
        this.filePath = FileUtil.asCanonicalFileName((String)metsFilePath);
        this.currentOperatorName = operatorName;
        this.addObserver(observer);
        if (originalSIPFolder == null) {
            this.originalSIPFolder = FileUtil.asParentPath((String)metsFilePath);
            this.isWorkingCopy = false;
        } else {
            this.originalSIPFolder = originalSIPFolder;
            this.isWorkingCopy = true;
        }
        this.lockIfPossibleAndRequired();
        Element root = this.getRootElement();
        this.namespaceMETS = root.getNamespaceForPrefix("METS").getStringValue();
        Namespace premis = root.getNamespaceForPrefix("PREMIS");
        this.namespacePREMIS = premis != null ? premis.getStringValue() : "info:lc/xmlns/premis-v2";
        this.profile = root.attributeValue("PROFILE");
        this.label = root.attributeValue("LABEL");
        this.type = root.attributeValue("TYPE");
        if (this.type == null || this.type.isEmpty()) {
            Exception.remember((String)"METS file does not contain a submission agreement definition.");
        } else {
            try {
                this.saId = this.type.substring(0, this.type.lastIndexOf("_"));
                this.dssId = this.type.substring(this.type.lastIndexOf("_") + 1, this.type.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                Exception.remember((String)("METS file does not contain a valid submission agreement definition: " + this.type));
            }
        }
        this.objId = root.attributeValue("OBJID");
        this.distributeMessage("DMD Section...");
        this.dmdSections = DMDSectionAbstract.parse(this);
        this.distributeMessage("AMD Section...");
        this.amdSection = AMDSection.parse(this);
        this.distributeMessage("Header...");
        this.header = Header.parse(this);
        this.distributeMessage("File Section...");
        this.fileSection = FileSection.parse(this);
        this.distributeMessage("Struct Map...");
        this.structureMap = StructureMap.parse(this);
        this.distributeMessage("OK");
        this.isModified = false;
    }

    protected void save(boolean withBackup) throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException, OriginalSIPIsMissingException {
        this.save(withBackup, true);
    }

    public void save(boolean withBackup, boolean keepWorkingCopy) throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException, OriginalSIPIsMissingException {
        if (!this.canWrite()) {
            throw new DocumentIsReadOnlyException(this);
        }
        if (this.getStructureMap().getRoot() != null && Integer.valueOf(-1).equals(this.getStructureMap().getRoot().getOrder())) {
            this.getStructureMap().getRoot().setOrderRecursive(1, false);
        }
        boolean originalSIPIsMissing = false;
        this.header.setLastModificationDateToNow();
        this.header.setSwNameAndType();
        if (this.isWorkingCopy) {
            this.writeMETSFile();
            if (this.isZIPFile()) {
                if (withBackup) {
                    if (!new File(this.originalSIPFolder).exists()) {
                        originalSIPIsMissing = true;
                    } else {
                        if (this.isReadWriteNoFileOps()) {
                            String filename = (BackupFolder == null ? FileUtil.asFilePathWithoutExtension((String)this.originalSIPFolder) : BackupFolder + File.separator + FileUtil.asFileNameWithoutExtension((String)this.originalSIPFolder)) + "_ORIGINAL-METS_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS") + "." + FileUtil.asFileNameExtension((String)this.originalSIPFolder);
                            Zipper.zip((String)this.filePath, (String)filename);
                        } else {
                            FileUtil.renameTo((String)this.originalSIPFolder, (String)((BackupFolder == null ? FileUtil.asFilePathWithoutExtension((String)this.originalSIPFolder) : BackupFolder + File.separator + FileUtil.asFileNameWithoutExtension((String)this.originalSIPFolder)) + "_ORIGINAL_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS") + "." + FileUtil.asFileNameExtension((String)this.originalSIPFolder)));
                        }
                        this.purgeBackups();
                    }
                }
                ArrayList<String> files = new ArrayList<String>();
                for (File file : new File(this.getSIPFolder()).listFiles()) {
                    files.add(file.getPath());
                }
                Zipper.zip((String[])files.toArray(new String[0]), (String)this.originalSIPFolder);
            } else {
                if (withBackup) {
                    if (!new File(this.originalSIPFolder).exists()) {
                        originalSIPIsMissing = true;
                    } else {
                        if (BackupFolder != null) {
                            FileUtil.copyToOverwriting((String)this.originalSIPFolder, (String)(BackupFolder + "/" + FileUtil.asFileName((String)this.originalSIPFolder) + "_ORIGINAL_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS")), (boolean)true);
                        } else {
                            FileUtil.copyToOverwriting((String)this.originalSIPFolder, (String)(this.originalSIPFolder + "_ORIGINAL_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS")), (boolean)true);
                        }
                        this.purgeBackups();
                    }
                }
                String securitySuffix = DOCUMENT_NAME_SUFFIX_PART_COPY + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS");
                if (this.isAtLeastOneFileNotReadable || this.isAtLeastOneFileNotWritable) {
                    try {
                        FileUtil.copyToOverwriting((String)this.getSIPFolder(), (String)(this.originalSIPFolder + securitySuffix), (boolean)true);
                    }
                    catch (FileUtilExceptionListException ex) {
                        Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        FileUtil.copyToOverwriting((String)(this.originalSIPFolder + securitySuffix), (String)this.originalSIPFolder, (boolean)true);
                    }
                    catch (FileUtilExceptionListException ex) {
                        Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    FileUtil.setWritable((String)(this.originalSIPFolder + securitySuffix));
                    FileUtil.delete((String)(this.originalSIPFolder + securitySuffix));
                } else {
                    if (keepWorkingCopy) {
                        FileUtil.copyToOverwriting((String)this.getSIPFolder(), (String)(this.originalSIPFolder + securitySuffix), (boolean)true);
                    } else {
                        FileUtil.moveTo((String)this.getSIPFolder(), (String)(this.originalSIPFolder + securitySuffix));
                        this.cleanupWorkingCopy();
                    }
                    try {
                        FileUtil.delete((String)this.originalSIPFolder);
                    }
                    catch (FileUtilExceptionListException ex) {
                        Vector<FileUtilException> exFiles = new Vector<FileUtilException>();
                        for (FileUtilException x : ex.getAllExceptions()) {
                            exFiles.add(x);
                        }
                        throw new FileOrFolderIsInUseException(exFiles, this.originalSIPFolder, this.originalSIPFolder + securitySuffix);
                    }
                    FileUtil.renameTo((String)(this.originalSIPFolder + securitySuffix), (String)this.originalSIPFolder);
                    if (!keepWorkingCopy) {
                        this.initialize(this.originalSIPFolder + File.separator + DEFAULT_METS_FILE_NAME, null, Mode.ReadWriteNoFileOps, this.currentOperatorName, null);
                        Logger.info((Object)("Changing SIP mode to: '" + (Object)((Object)this.mode) + "': '" + this.originalSIPFolder + "'"));
                    }
                }
            }
        } else {
            if (withBackup) {
                if (!new File(this.originalSIPFolder).exists()) {
                    originalSIPIsMissing = true;
                } else {
                    if (this.isReadWriteNoFileOps()) {
                        String filename = null;
                        filename = BackupFolder == null ? FileUtil.asFilePathWithoutExtension((String)this.originalSIPFolder) + "_ORIGINAL-METS_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS") : BackupFolder + "/" + FileUtil.asFileNameWithoutExtension((String)this.originalSIPFolder) + "_ORIGINAL-METS_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS");
                        File backup = new File(filename);
                        if (!backup.exists()) {
                            backup.mkdirs();
                        }
                        FileUtil.copyToFolderOverwriting((String)this.filePath, (String)filename);
                    } else if (BackupFolder != null) {
                        FileUtil.copyToOverwriting((String)this.originalSIPFolder, (String)(BackupFolder + "/" + FileUtil.asFileName((String)this.originalSIPFolder) + "_ORIGINAL_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS")), (boolean)true);
                    } else {
                        FileUtil.copyToOverwriting((String)this.originalSIPFolder, (String)(this.originalSIPFolder + "_ORIGINAL_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS")), (boolean)true);
                    }
                    this.purgeBackups();
                }
            }
            this.writeMETSFile();
        }
        this.isModified = false;
        if (originalSIPIsMissing) {
            throw new OriginalSIPIsMissingException(this.originalSIPFolder);
        }
    }

    private void writeMETSFile() throws IOException {
        Document.writeMETSFile((org.dom4j.Document)this, this.filePath);
    }

    private static void writeMETSFile(org.dom4j.Document document, String metsFilePath) throws IOException {
        OutputStreamWriter oswriter = new OutputStreamWriter((OutputStream)new FileOutputStream(metsFilePath), "utf-8");
        OutputFormat outformat = new OutputFormat();
        outformat.setEncoding("UTF-8");
        outformat.setIndent(false);
        outformat.setNewlines(false);
        XMLWriter writer = new XMLWriter((Writer)oswriter, outformat);
        writer.write(document);
        writer.flush();
        writer.close();
    }

    private void purgeBackups() {
        if (KeepBackupsCount == null) {
            return;
        }
        final String backupPattern = this.isZIPFile() ? FileUtil.asFileNameWithoutExtension((String)this.originalSIPFolder) + "_ORIGINAL_" : FileUtil.asFileName((String)this.originalSIPFolder) + "_ORIGINAL_";
        FilenameFilter myBackups = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(backupPattern);
            }
        };
        File backupFolder = BackupFolder != null ? new File(BackupFolder) : new File(this.originalSIPFolder).getParentFile();
        List<String> backups = Arrays.asList(backupFolder.list(myBackups));
        Collections.sort(backups);
        for (int i = 0; i < backups.size() - KeepBackupsCount; ++i) {
            Logger.info((Object)("Purging '" + backupFolder + "/" + backups.get(i) + "'"));
            try {
                String backup = backups.get(i);
                FileUtil.delete((String)(backupFolder + "/" + backup));
                if (backups.size() <= i + 1) continue;
                final String backupMetsPattern = backups.get(i + 1).replace("_ORIGINAL_", "_ORIGINAL-METS_");
                FilenameFilter myMetsBackups = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains("_ORIGINAL-METS_") && name.compareTo(backupMetsPattern) < 0;
                    }
                };
                List<String> metsBackups = Arrays.asList(backupFolder.list(myMetsBackups));
                for (String metsBackup : metsBackups) {
                    Logger.info((Object)("Purging '" + backupFolder + "/" + metsBackup + "'"));
                    try {
                        FileUtil.delete((String)(backupFolder + "/" + metsBackup));
                    }
                    catch (FileUtilExceptionListException ex) {
                        Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                continue;
            }
            catch (FileUtilExceptionListException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private String getLastBackupFilePath() {
        String backupPattern;
        FilenameFilter myBackupsFilter;
        File backupFolder = BackupFolder != null ? new File(BackupFolder) : new File(this.originalSIPFolder).getParentFile();
        String[] backupsArray = backupFolder.list(myBackupsFilter = new FilenameFilter(backupPattern = this.isZIPFile() ? FileUtil.asFileNameWithoutExtension((String)this.originalSIPFolder) + "_ORIGINAL_" : FileUtil.asFileName((String)this.originalSIPFolder) + "_ORIGINAL_"){
            final /* synthetic */ String val$backupPattern;
            {
                this.val$backupPattern = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(this.val$backupPattern);
            }
        });
        if (backupsArray == null) {
            return null;
        }
        List<String> backups = Arrays.asList(backupFolder.list(myBackupsFilter));
        Collections.sort(backups);
        if (backups.isEmpty()) {
            return null;
        }
        return backupFolder + File.separator + backups.get(backups.size() - 1);
    }

    private String getLastMetsBackupFilePath() {
        String backupPattern;
        FilenameFilter myBackupsFilter;
        File backupFolder = BackupFolder != null ? new File(BackupFolder) : new File(this.originalSIPFolder).getParentFile();
        String[] backupsArray = backupFolder.list(myBackupsFilter = new FilenameFilter(backupPattern = this.isZIPFile() ? FileUtil.asFileNameWithoutExtension((String)this.originalSIPFolder) + "_ORIGINAL-METS_" : FileUtil.asFileName((String)this.originalSIPFolder) + "_ORIGINAL-METS_"){
            final /* synthetic */ String val$backupPattern;
            {
                this.val$backupPattern = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(this.val$backupPattern);
            }
        });
        if (backupsArray == null) {
            return null;
        }
        List<String> backups = Arrays.asList(backupFolder.list(myBackupsFilter));
        Collections.sort(backups);
        if (backups.size() < 2) {
            return null;
        }
        return backupFolder + File.separator + backups.get(backups.size() - 2);
    }

    protected void lockIfPossibleAndRequired() {
        String lockedBy = this.lockedByWhom();
        if (lockedBy == null) {
            if (this.canWrite()) {
                this.lock_dontCheck();
            }
        } else if (OperatingSystem.userName().equals(lockedBy)) {
            this.lockedBy = null;
        } else {
            this.lockedBy = lockedBy;
            this.mode = Mode.Locked;
        }
    }

    protected String lockedByWhom() {
        return Document.lockedByWhom(this.originalSIPFolder);
    }

    protected void lock_dontCheck() {
        try {
            FileUtil.createFileWithContent((String)(this.originalSIPFolder + LOCK_FILE_SUFFIX), (String)OperatingSystem.userName());
        }
        catch (IOException ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected boolean unlock() {
        if (!this.canWrite()) {
            return false;
        }
        return this.unlock_dontCheck();
    }

    public Document removeAllWithLevel(LevelOfDescription level) throws NodeWithLevelNotRemovableException {
        StructureMap structureMap = this.getStructureMap();
        NodeAbstract metsStructMapNode = structureMap.getRoot();
        this.checkIfTrashRemovable();
        this.removeAllWithLevel(metsStructMapNode, level);
        return this;
    }

    private boolean checkIfTrashRemovable() {
        return !this.isReadOnly();
    }

    boolean checkIfAllWithLevelRemovable(NodeAbstract root, LevelOfDescription level) {
        List<NodeAbstract> rootOrDescendants = root.getWithDescendants();
        boolean allSubtreeRemovable = true;
        for (NodeAbstract node : rootOrDescendants) {
            boolean isSelfOrDescendantRemovable = true;
            if (this.hasLevel(node, level)) {
                List<NodeAbstract> descendants = node.getWithDescendants();
                for (NodeAbstract selfOrDescendant : descendants) {
                    isSelfOrDescendantRemovable &= this.hasLevel(selfOrDescendant, level);
                }
            }
            allSubtreeRemovable &= isSelfOrDescendantRemovable;
        }
        return allSubtreeRemovable;
    }

    private boolean hasLevel(NodeAbstract metsStructMapNode, LevelOfDescription level) {
        LevelOfDescription nodeLevel = metsStructMapNode.getLevel();
        return this.isLevelEqualsWith(nodeLevel, level);
    }

    void removeAllWithLevel(NodeAbstract root, LevelOfDescription level) throws NodeWithLevelNotRemovableException {
        boolean removable = this.checkIfAllWithLevelRemovable(root, level);
        if (!removable) {
            throw new NodeWithLevelNotRemovableException("cannot execute removeAllWithLevel due to inconsistencies in levels logic", level);
        }
        this.removeLevelRecursive(root, level);
    }

    private void removeLevelRecursive(NodeAbstract metsStructMapNode, LevelOfDescription level) {
        boolean isRemovable;
        ArrayList<NodeAbstract> childrenList = new ArrayList<NodeAbstract>();
        int childCount = metsStructMapNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeAbstract metsChildNode = (NodeAbstract)metsStructMapNode.getChildAt(i);
            childrenList.add(metsChildNode);
        }
        for (NodeAbstract childNode : childrenList) {
            this.removeLevelRecursive(childNode, level);
        }
        boolean bl = isRemovable = this.hasLevel(metsStructMapNode, level) && (metsStructMapNode.getChildCount() == 0 || metsStructMapNode.isFile()) && metsStructMapNode.canWrite();
        if (isRemovable && !metsStructMapNode.isRoot().booleanValue()) {
            try {
                metsStructMapNode.delete();
            }
            catch (FileOperationNotAllowedException | FileUtilExceptionListException | IOException e) {
                Logger.error((Object)"cannot delete folder node: ", (Throwable)e);
            }
        }
    }

    private boolean isLevelEqualsWith(LevelOfDescription nodeLevel, LevelOfDescription level) {
        if (nodeLevel != null) {
            return nodeLevel.equals(level);
        }
        return false;
    }

    private static class DocumentFactory
    extends org.dom4j.DocumentFactory {
        private static final long serialVersionUID = 1L;

        private DocumentFactory() {
        }

        public Document createDocument() {
            Document document = new Document();
            document.setDocumentFactory(this);
            return document;
        }
    }

    public static enum Mode {
        Undefined,
        ReadWrite,
        ReadWriteNoFileOps,
        ReadOnly,
        Locked;

    }
}

