/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.multisequence.wu_manber.AbstractWuManberSearcher;

public class WuManberMultiByteSearcher
extends AbstractWuManberSearcher {
    public WuManberMultiByteSearcher(MultiSequenceMatcher matcher, int blockSize) {
        super(matcher, blockSize);
        if (matcher.getMinimumLength() < blockSize) {
            String message = String.format("Minimum sequence length (%d) cannot be smaller than the block size: %d", matcher.getMinimumLength(), blockSize);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long searchPosition, long lastSearchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long searchPosition, long lastSearchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        int hashBitMask = safeShifts.length - 1;
        MultiSequenceMatcher backMatcher = info.matcher;
        int lastPossiblePosition = bytes.length - 1;
        int lastPosition = toPosition < lastPossiblePosition ? toPosition : lastPossiblePosition;
        int lastMinimumPosition = this.sequences.getMinimumLength() - 1;
        int n = searchPosition = fromPosition > 0 ? fromPosition + lastMinimumPosition : lastMinimumPosition;
        while (searchPosition <= lastPosition) {
            int blockHash = 0;
            for (int blockPosition = searchPosition - this.blockSize + 1; blockPosition <= searchPosition; ++blockPosition) {
                int value = bytes[blockPosition] & 0xFF;
                blockHash = ((blockHash << 5) - blockHash) * value;
            }
            int safeShift = safeShifts[blockHash & hashBitMask];
            if (safeShift == 0) {
                List<SearchResult<SequenceMatcher>> results;
                Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(bytes, searchPosition);
                if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(searchPosition, matches, fromPosition, toPosition)).isEmpty()) {
                    return results;
                }
                ++searchPosition;
                continue;
            }
            searchPosition += safeShift;
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[block size: " + this.blockSize + " sequences:" + this.sequences + ']';
    }
}

