/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.creator;

import gov.loc.repository.bagit.annotation.Incubating;
import gov.loc.repository.bagit.creator.CreatePayloadManifestsVistor;
import gov.loc.repository.bagit.creator.CreateTagManifestsVistor;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Metadata;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.hash.Hasher;
import gov.loc.repository.bagit.hash.SupportedAlgorithm;
import gov.loc.repository.bagit.util.PathUtils;
import gov.loc.repository.bagit.writer.BagitFileWriter;
import gov.loc.repository.bagit.writer.ManifestWriter;
import gov.loc.repository.bagit.writer.MetadataWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagCreator {
    private static final Logger logger = LoggerFactory.getLogger(BagCreator.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final Version DOT_BAGIT_VERSION = new Version(2, 0);
    private static final Version LATEST_NON_DOT_BAGIT_VERSION = new Version(0, 97);

    private BagCreator() {
    }

    public static Bag bagInPlace(Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        return BagCreator.bagInPlace(LATEST_NON_DOT_BAGIT_VERSION, root, algorithms, includeHidden, new Metadata());
    }

    public static Bag bagInPlace(Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden, Metadata metadata) throws NoSuchAlgorithmException, IOException {
        return BagCreator.bagInPlace(LATEST_NON_DOT_BAGIT_VERSION, root, algorithms, includeHidden, metadata);
    }

    @Incubating
    public static Bag createDotBagit(Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        return BagCreator.bagInPlace(DOT_BAGIT_VERSION, root, algorithms, includeHidden, new Metadata());
    }

    @Incubating
    public static Bag createDotBagit(Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden, Metadata metadata) throws NoSuchAlgorithmException, IOException {
        return BagCreator.bagInPlace(DOT_BAGIT_VERSION, root, algorithms, includeHidden, metadata);
    }

    private static Bag bagInPlace(Version version, Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden, Metadata metadata) throws NoSuchAlgorithmException, IOException {
        Bag bag = new Bag(version);
        logger.info(messages.getString("creating_bag"), (Object)bag.getVersion(), (Object)root);
        bag.setRootDir(root);
        BagCreator.moveDataFilesIfNeeded(bag, includeHidden);
        BagCreator.createBagitFile(bag);
        BagCreator.createPayloadManifests(bag, algorithms, includeHidden);
        BagCreator.createMetadataFile(bag, metadata);
        BagCreator.createTagManifests(bag, algorithms, includeHidden);
        return bag;
    }

    private static void moveDataFilesIfNeeded(Bag bag, boolean includeHidden) throws IOException {
        if (bag.getVersion().isOlder(DOT_BAGIT_VERSION)) {
            Path tempDir = bag.getRootDir().resolve(System.currentTimeMillis() + ".temp");
            Files.createDirectory(tempDir, new FileAttribute[0]);
            BagCreator.moveDataFiles(bag.getRootDir(), tempDir, includeHidden);
            Files.move(tempDir, PathUtils.getDataDir(bag), new CopyOption[0]);
        } else {
            Path dotbagitDir = bag.getRootDir().resolve(".bagit");
            Files.createDirectories(dotbagitDir, new FileAttribute[0]);
        }
    }

    private static void createBagitFile(Bag bag) throws IOException {
        BagitFileWriter.writeBagitFile(bag.getVersion(), bag.getFileEncoding(), PathUtils.getBagitDir(bag));
    }

    private static void moveDataFiles(Path rootDir, Path dataDir, boolean includeHidden) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootDir);){
            for (Path path : directoryStream) {
                if (path.equals(dataDir) || PathUtils.isHidden(path) && !includeHidden) continue;
                Files.move(path, dataDir.resolve(path.getFileName()), new CopyOption[0]);
            }
        }
    }

    private static Map<Manifest, MessageDigest> calculatePayloadManifests(Bag bag, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        Path dataDir = PathUtils.getDataDir(bag);
        logger.info(messages.getString("creating_payload_manifests"));
        Map<Manifest, MessageDigest> payloadFilesMap = Hasher.createManifestToMessageDigestMap(algorithms);
        CreatePayloadManifestsVistor payloadVisitor = new CreatePayloadManifestsVistor(payloadFilesMap, includeHidden);
        Files.walkFileTree(dataDir, payloadVisitor);
        return payloadFilesMap;
    }

    private static void createPayloadManifests(Bag bag, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        Map<Manifest, MessageDigest> payloadFilesMap = BagCreator.calculatePayloadManifests(bag, algorithms, includeHidden);
        bag.getPayLoadManifests().addAll(payloadFilesMap.keySet());
        ManifestWriter.writePayloadManifests(bag.getPayLoadManifests(), PathUtils.getBagitDir(bag), bag.getRootDir(), bag.getFileEncoding());
    }

    private static void createMetadataFile(Bag bag, Metadata metadata) throws IOException {
        bag.setMetadata(metadata);
        logger.debug(messages.getString("calculating_payload_oxum"), (Object)PathUtils.getDataDir(bag));
        String payloadOxum = PathUtils.generatePayloadOxum(PathUtils.getDataDir(bag));
        bag.getMetadata().upsertPayloadOxum(payloadOxum);
        bag.getMetadata().remove("Bagging-Date");
        bag.getMetadata().add("Bagging-Date", new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH).format(new Date()));
        logger.info(messages.getString("creating_metadata_file"));
        MetadataWriter.writeBagMetadata(bag.getMetadata(), bag.getVersion(), PathUtils.getBagitDir(bag), bag.getFileEncoding());
    }

    private static Map<Manifest, MessageDigest> calculateTagManifests(Bag bag, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        logger.info(messages.getString("creating_tag_manifests"));
        Map<Manifest, MessageDigest> tagFilesMap = Hasher.createManifestToMessageDigestMap(algorithms);
        CreateTagManifestsVistor tagVistor = new CreateTagManifestsVistor(tagFilesMap, includeHidden);
        Files.walkFileTree(PathUtils.getBagitDir(bag), tagVistor);
        return tagFilesMap;
    }

    private static void createTagManifests(Bag bag, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        Map<Manifest, MessageDigest> tagFilesMap = BagCreator.calculateTagManifests(bag, algorithms, includeHidden);
        bag.getTagManifests().addAll(tagFilesMap.keySet());
        ManifestWriter.writeTagManifests(bag.getTagManifests(), PathUtils.getBagitDir(bag), bag.getRootDir(), bag.getFileEncoding());
    }
}

