/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public abstract class TiffProfile {
    protected String _profileText;
    protected int _mimeClass = 0;
    private boolean _alreadyOK = false;
    public static final int MIME_GENERIC = 0;
    public static final int MIME_FX = 1;
    public static final int MIME_1314 = 2;

    public final boolean satisfiesProfile(IFD iFD) {
        boolean bl = this.satisfiesThisProfile(iFD);
        if (bl) {
            this._alreadyOK = true;
        }
        return bl;
    }

    public abstract boolean satisfiesThisProfile(IFD var1);

    public String getText() {
        return this._profileText;
    }

    public void setAlreadyOK(boolean bl) {
        this._alreadyOK = bl;
    }

    public int getMimeClass() {
        return this._mimeClass;
    }

    public boolean isAlreadyOK() {
        return this._alreadyOK;
    }

    protected boolean satisfiesCompression(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getNisoImageMetadata().getCompressionScheme();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesCompression(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesCompression(tiffIFD, nArray);
    }

    protected boolean satisfiesPhotometricInterpretation(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getNisoImageMetadata().getColorSpace();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesPhotometricInterpretation(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesPhotometricInterpretation(tiffIFD, nArray);
    }

    protected boolean satisfiesResolutionUnit(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getNisoImageMetadata().getSamplingFrequencyUnit();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesResolutionUnit(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesResolutionUnit(tiffIFD, nArray);
    }

    protected boolean satisfiesXResolution(TiffIFD tiffIFD, int[] nArray) {
        long l = tiffIFD.getNisoImageMetadata().getXSamplingFrequency().toLong();
        for (int i = 0; i < nArray.length; ++i) {
            if (l != (long)nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesYResolution(TiffIFD tiffIFD, int[] nArray) {
        long l = tiffIFD.getNisoImageMetadata().getYSamplingFrequency().toLong();
        for (int i = 0; i < nArray.length; ++i) {
            if (l != (long)nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesSamplesPerPixel(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getNisoImageMetadata().getSamplesPerPixel();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesSamplesPerPixel(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesSamplesPerPixel(tiffIFD, nArray);
    }

    protected boolean satisfiesPlanarConfiguration(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getNisoImageMetadata().getPlanarConfiguration();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesPlanarConfiguration(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesPlanarConfiguration(tiffIFD, nArray);
    }

    protected boolean satisfiesOrientation(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getNisoImageMetadata().getOrientation();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesOrientation(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesOrientation(tiffIFD, nArray);
    }

    protected boolean satisfiesImageColorIndicator(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getImageColorIndicator();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesImageColorIndicator(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesImageColorIndicator(tiffIFD, nArray);
    }

    protected boolean satisfiesNewSubfileType(TiffIFD tiffIFD, long[] lArray) {
        long l = tiffIFD.getNewSubfileType();
        for (int i = 0; i < lArray.length; ++i) {
            if (l != lArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesNewSubfileType(TiffIFD tiffIFD, long l) {
        long[] lArray = new long[]{l};
        return this.satisfiesNewSubfileType(tiffIFD, lArray);
    }

    protected boolean satisfiesBackgroundColorIndicator(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getBackgroundColorIndicator();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesBackgroundColorIndicator(TiffIFD tiffIFD, int n) {
        int[] nArray = new int[]{n};
        return this.satisfiesBackgroundColorIndicator(tiffIFD, nArray);
    }

    protected boolean satisfiesDotRange(TiffIFD tiffIFD, int n, int n2) {
        int[] nArray = tiffIFD.getDotRange();
        if (nArray == null || nArray.length < 2) {
            return false;
        }
        return nArray[0] == n || nArray[1] == n2;
    }

    protected boolean satisfiesImageWidth(TiffIFD tiffIFD, int[] nArray) {
        long l = tiffIFD.getNisoImageMetadata().getImageWidth();
        for (int i = 0; i < nArray.length; ++i) {
            if (l != (long)nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesIndexed(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getIndexed();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesFillOrder(TiffIFD tiffIFD, int[] nArray) {
        int n = tiffIFD.getFillOrder();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }
}

