/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;

public abstract class ArchiveFileWalker<T> {
    protected abstract void handleEntry(T var1) throws IOException;

    protected final void walk(Iterable<T> iterable) throws IOException {
        try {
            this.walkInternal(iterable);
        }
        catch (CancelException cancel) {
            this.handleCancelled(cancel);
        }
    }

    private void walkInternal(Iterable<T> archiveFile) throws IOException {
        for (T entry : archiveFile) {
            this.checkIfCancelled(entry);
            this.handleEntry(entry);
        }
    }

    protected boolean isCancelled() {
        return false;
    }

    private void checkIfCancelled(T entry) throws IOException {
        if (this.isCancelled()) {
            throw new CancelException("Cancelled on entry [" + entry + "]");
        }
    }

    protected void handleCancelled(CancelException e) throws CancelException {
        throw e;
    }

    public static final class CancelException
    extends IOException {
        private static final long serialVersionUID = -8123033733467072095L;

        public CancelException(String message) {
            super(message);
        }
    }
}

