/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.byteseek.io.reader.FileReader;
import net.byteseek.io.reader.WindowReader;
import org.apache.ant.compress.util.SevenZStreamFactory;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.SevenZipIteratorAdapter;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class SevenZipArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droid;
    private IdentificationRequestFactory<InputStream> factory;
    private ResultHandler resultHandler;

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        WindowReader windowReader = request.getWindowReader();
        if (windowReader instanceof FileReader) {
            FileReader fileReader = (FileReader)windowReader;
            File file = fileReader.getFile();
            SevenZFile sevenZFile = new SevenZFile(file);
            SevenZStreamFactory sevenZStreamFactory = new SevenZStreamFactory();
            try (ArchiveInputStream archiveStream = sevenZStreamFactory.getArchiveInputStream(file, null);){
                CloseShieldInputStream closeShieldInputStream = new CloseShieldInputStream((InputStream)archiveStream);
                SevenZArchiveWalker walker = new SevenZArchiveWalker(this.droid, this.factory, (InputStream)closeShieldInputStream, request.getIdentifier(), this.resultHandler);
                walker.walk(new SevenZipIteratorAdapter(archiveStream));
            }
        }
    }

    private static ResourceId submitDirectory(URI parentName, SevenZArchiveEntry entry, String entryName, ResourceId correlationId, ResultHandler resultHandler) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        long size = entry.getSize();
        Date date = entry.getLastModifiedDate();
        long time = date == null ? -1L : date.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toTarUri(parentName, entry.getName()));
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return resultHandler.handleDirectory(result, correlationId, false);
    }

    public void setFactory(IdentificationRequestFactory<InputStream> factory) {
        this.factory = factory;
    }

    public void setDroid(AsynchDroid droid) {
        this.droid = droid;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public static class SevenZArchiveWalker
    extends ArchiveFileWalker<SevenZArchiveEntry> {
        private final AsynchDroid droid;
        private IdentificationRequestFactory<InputStream> factory;
        private InputStream in;
        private final ResourceId parentId;
        private final URI parentName;
        private final long originatorNodeId;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();
        private final ResultHandler resultHandler;

        public SevenZArchiveWalker(AsynchDroid droid, IdentificationRequestFactory<InputStream> factory, InputStream in, RequestIdentifier parent, ResultHandler resultHandler) {
            this.in = in;
            this.droid = droid;
            this.factory = factory;
            this.parentId = parent.getResourceId();
            this.parentName = parent.getUri();
            this.originatorNodeId = parent.getAncestorId();
            this.resultHandler = resultHandler;
        }

        @Override
        protected void handleEntry(SevenZArchiveEntry entry) throws IOException {
            String entryName = entry.getName();
            String prefixPath = FilenameUtils.getPath((String)entryName);
            ResourceId correlationId = this.parentId;
            if (!prefixPath.isEmpty() && (correlationId = this.directories.get(prefixPath)) == null) {
                correlationId = this.processAncestorFolders(prefixPath);
            }
            if (!(entryName = FilenameUtils.getName((String)entryName)).isEmpty()) {
                this.submit(entry, entryName, correlationId);
            }
        }

        final void submit(SevenZArchiveEntry entry, String entryName, ResourceId correlationId) throws IOException {
            long size = entry.getSize();
            Date time = new Date();
            RequestMetaData metaData = new RequestMetaData(size == -1L ? null : Long.valueOf(size), time == null ? null : Long.valueOf(time.getTime()), entryName);
            RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toSevenZUri(this.parentName, entry.getName()));
            identifier.setAncestorId(this.originatorNodeId);
            identifier.setParentResourceId(correlationId);
            if (identifier.getParentPrefix() != null && identifier.getParentPrefix().isEmpty()) {
                identifier.setParentPrefix(null);
            }
            IdentificationRequest<InputStream> request = this.factory.newRequest(metaData, identifier);
            BoundedInputStream entryInputStream = new BoundedInputStream(this.in, entry.getSize());
            entryInputStream.setPropagateClose(false);
            request.open((InputStream)entryInputStream);
            if (!entry.isDirectory()) {
                this.droid.submit(request);
            }
        }

        private ResourceId processAncestorFolders(String path) {
            int pathIndex;
            List<String> paths = ArchiveFileUtils.getAncestorPaths(path);
            ResourceId longestParentId = this.parentId;
            int longestSeenBefore = paths.size();
            ResourceId correlationId = null;
            for (pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
                correlationId = this.directories.get(paths.get(pathIndex));
                if (correlationId == null) continue;
                longestSeenBefore = pathIndex;
                longestParentId = correlationId;
                break;
            }
            for (pathIndex = longestSeenBefore - 1; pathIndex >= 0; --pathIndex) {
                String pathName = paths.get(pathIndex);
                SevenZArchiveEntry entry = new SevenZArchiveEntry();
                entry.setLastModifiedDate(new Date());
                entry.setName(pathName);
                String dirName = FilenameUtils.getName((String)pathName.substring(0, pathName.length() - 1));
                longestParentId = SevenZipArchiveHandler.submitDirectory(this.parentName, entry, dirName, longestParentId, this.resultHandler);
                this.directories.put(pathName, longestParentId);
            }
            return longestParentId;
        }
    }
}

