/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.repository.index;

import com.exlibris.core.infra.api.xmlbeans.Field;
import com.exlibris.core.infra.api.xmlbeans.MetadataIndex;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.normalizers.Normalizer;
import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.common.util.ReflectionUtil;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.common.xml.XMLNormalizer;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.repository.index.IndexingManager;
import com.exlibris.core.sdk.formatting.FormattedDocument;
import com.exlibris.core.sdk.formatting.MDRecordUtil;
import com.exlibris.digitool.repository.api.xmlbeans.Md;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CoreMetadataIndexer {
    protected static final String MD_MID = "Mid";
    protected static final String MD_DESCRIPTION = "Description";
    protected static final String MD_NAME_AND_TYPE = "NameAndType";
    protected static ExLogger logger = ExLogger.getExLogger(CoreMetadataIndexer.class);
    protected IndexingManager indexingManager = (IndexingManager)ServiceLocator.getInstance().lookUp(IndexingManager.class);

    public CoreMetadataIndexer() {
        this.indexingManager.init();
    }

    public void indexMetadata(HDeMetadata h_md) throws Exception {
        Document metadataIndexDocument = this.getMetadataIndex(h_md);
        if (metadataIndexDocument != null) {
            String metadataIndex = metadataIndexDocument.asXML();
            h_md.setIndexXml(metadataIndex);
        }
    }

    public Document getMetadataIndex(HDeMetadata h_md) throws Exception {
        if (h_md == null) {
            return null;
        }
        Md md = Md.Factory.newInstance();
        try {
            h_md.export(md);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable<String, Object> mdsParsedList = new Hashtable<String, Object>();
        Hashtable<String, String> mdsUnParsableList = new Hashtable<String, String>();
        String mainTag = md.getName() + "_" + md.getType() + "_" + "all";
        FormattedDocument fd = new FormattedDocument(mainTag);
        ArrayList<MetadataIndex> metadataIndexes = new ArrayList<MetadataIndex>();
        MetadataIndex metadataIndex = this.indexingManager.getMetadataIndex(md);
        if (metadataIndex != null) {
            metadataIndexes.add(metadataIndex);
        }
        if (metadataIndexes == null || metadataIndexes.size() == 0) {
            this.addMdSystemValues(md, fd);
            this.formatDefault(md, fd);
        } else {
            for (MetadataIndex mi : metadataIndexes) {
                if (mi == null) continue;
                String controlPrefix = null;
                this.addMdSystemValues(md, fd);
                Field[] fields = mi.getFieldArray();
                if (fields == null || fields.length == 0) {
                    this.formatDefault(md, fd);
                    continue;
                }
                for (int i = 0; i < fields.length; ++i) {
                    String[] fieldPaths = fields[i].getFieldPathArray();
                    for (int j = 0; j < fieldPaths.length; ++j) {
                        this.formatField(md, fields[i], fieldPaths[j], fd, mdsUnParsableList, mdsParsedList, controlPrefix);
                    }
                }
            }
        }
        if (fd.isEmpty()) {
            return null;
        }
        return fd.getDocument();
    }

    protected void formatDefault(Md md, FormattedDocument fd) {
        String name = md.getName();
        String type = md.getType();
        Document mdDoc = null;
        SAXReader reader = new SAXReader();
        try {
            Document document;
            mdDoc = document = reader.read((Reader)new StringReader(md.getValue()));
        }
        catch (Exception e) {
            logger.warn(DescriptorConstants.IN_UnableToParserMD, (Object)(name + ":" + type), (Object)md.getMid(), (Object)e.getMessage(), (Object)e.getMessage());
            logger.debug((Object)e.getCause(), new String[0]);
        }
        if (mdDoc == null) {
            logger.warn((Object)("Problem with MD. mid:" + md.getMid()), new String[0]);
            return;
        }
        Vector<String> v = new Vector<String>();
        Element rootElement = mdDoc.getRootElement();
        this.go(rootElement, v);
        for (int i = 0; i < v.size(); ++i) {
            String normalizedValue;
            String val = v.elementAt(i);
            if (val == null || (normalizedValue = NormalizerUtil.normalizeWithProfileName("generic", val = XMLNormalizer.normalize(val))) == null) continue;
            fd.createElement("all", normalizedValue);
        }
    }

    protected void go(Element element, Vector<String> v) {
        String textTrim = element.getTextTrim();
        if (textTrim.trim().length() != 0) {
            v.add(textTrim);
        }
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            Element son = (Element)i.next();
            this.go(son, v);
        }
    }

    protected void addMdSystemValues(Md md, FormattedDocument fd) {
        String value = md.getMid();
        List<Normalizer> midNoramlizers = this.indexingManager.getMidNoramlizers();
        if (midNoramlizers != null) {
            for (Normalizer normalizer : midNoramlizers) {
                value = normalizer.normalize(value);
            }
        }
        fd.createElement(MD_MID, value);
        if (md.getDescription() != null && md.getDescription().trim().length() > 0) {
            value = md.getDescription();
            if (midNoramlizers != null) {
                for (Normalizer normalizer : midNoramlizers) {
                    value = normalizer.normalize(value);
                }
            }
            fd.createElement(MD_DESCRIPTION, value);
        }
        value = md.getName() + md.getType();
        for (Normalizer normalizer : midNoramlizers) {
            value = normalizer.normalize(value);
        }
        fd.createElement(MD_NAME_AND_TYPE, value);
    }

    protected void formatField(Md md, Field field, String path, FormattedDocument fd, Hashtable<String, String> mdsUnParsableList, Hashtable<String, Object> mdsParsedList, String prefix) {
        String mdKey = this.createMdKey(md);
        if (mdsUnParsableList.get(mdKey) != null) {
            return;
        }
        Object mdDoc = mdsParsedList.get(mdKey);
        if (mdDoc == null) {
            mdDoc = MDRecordUtil.getMDRecordObject(md);
        }
        if (mdDoc == null) {
            mdsUnParsableList.put(mdKey, "");
            return;
        }
        mdsParsedList.put(mdKey, mdDoc);
        String type = md.getType();
        Vector<String> v = ReflectionUtil.getXPathValues(mdDoc, path);
        for (int i = 0; i < v.size(); ++i) {
            String val = v.elementAt(i);
            if (val == null) continue;
            val = XMLNormalizer.normalize(val);
            String indexCode = field.getIndexCode();
            String profileName = field.getNormalizingProfilesRef();
            String normalizedValue = NormalizerUtil.normalizeWithProfileName(profileName, val);
            if (indexCode == null || normalizedValue == null) continue;
            if (!StringUtils.isEmptyString(prefix)) {
                indexCode = prefix + "_" + indexCode;
            }
            fd.createElement(indexCode, normalizedValue);
        }
    }

    protected String createMdKey(Md md) {
        StringBuffer sb = new StringBuffer();
        if (md.getName() != null) {
            sb.append(md.getName());
        }
        if (md.getType() != null) {
            sb.append(":").append(md.getType());
        }
        if (md.getMid() != null) {
            sb.append(":").append(md.getMid());
        }
        return sb.toString();
    }
}

