/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.sa.dss;

import ch.docuteam.darc.exceptions.InvalidSubmissionAgreement;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.NodeAbstract;
import ch.docuteam.darc.sa.dss.DataSubmissionSessionCategory;
import ch.docuteam.darc.sa.dss.DataSubmissionSessionRecordType;
import ch.docuteam.darc.sa.dss.FileFormats;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class DataSubmissionSession
extends NodeAbstract {
    private static final String DATA_SUBMISSION_SESSION_ELEMENT_NAME = "dataSubmissionSession";
    private static final String DSS_TITLE = "title";
    private static final String DSS_ID = "dssID";
    private final String dssID;
    private final String title;
    private final DataSubmissionSessionCategory category;
    private final DataSubmissionSessionRecordType recordTypes;
    private final FileFormats fileFormats;

    private DataSubmissionSession(SubmissionAgreement sa, Element element) {
        this.sa = sa;
        this.element = element;
        this.dssID = element.attributeValue(DSS_ID);
        this.title = this.getElementText("SA:title", true);
        this.category = DataSubmissionSessionCategory.get(this.getElementText("SA:category", true));
        this.recordTypes = DataSubmissionSessionRecordType.get(this.getElementText("SA:recordTypes", true));
        this.fileFormats = FileFormats.parse(this.sa, this.element);
    }

    public static Map<String, DataSubmissionSession> parse(SubmissionAgreement sa, Element parent) {
        HashMap<String, DataSubmissionSession> dsss = new HashMap<String, DataSubmissionSession>();
        for (Object o : parent.selectNodes("./SA:dataSubmissionSession")) {
            DataSubmissionSession dss = new DataSubmissionSession(sa, (Element)o);
            dsss.put(dss.getDssID(), dss);
        }
        return dsss;
    }

    public static Element cloneDataSubmissionSession(SubmissionAgreement sa, String id, String title) throws InvalidSubmissionAgreement {
        Element dssElement = null;
        if (sa.getRootElement().elements(DATA_SUBMISSION_SESSION_ELEMENT_NAME).size() == 0) {
            throw new InvalidSubmissionAgreement("No <dataSubmissionSession> element found");
        }
        Element first = (Element)sa.getRootElement().elements(DATA_SUBMISSION_SESSION_ELEMENT_NAME).get(0);
        dssElement = (Element)first.clone();
        Attribute idAttribute = dssElement.attribute(DSS_ID);
        if (!idAttribute.getValue().equals(id)) {
            dssElement.remove(idAttribute);
            dssElement.addAttribute(DSS_ID, id);
            dssElement.element(DSS_TITLE).setText(title);
            sa.getRootElement().add(dssElement);
        }
        return dssElement;
    }

    public String getDssID() {
        return this.dssID;
    }

    public String getTitle() {
        return this.title;
    }

    public DataSubmissionSessionCategory getCategory() {
        return this.category;
    }

    public DataSubmissionSessionRecordType getRecordTypes() {
        return this.recordTypes;
    }

    public FileFormats getFileFormats() {
        return this.fileFormats;
    }

    public boolean allowsFile(String filePath) throws FileNotFoundException {
        if (this.fileFormats == null) {
            return true;
        }
        return this.fileFormats.allowsFile(this.dssID, filePath);
    }

    public boolean allowsFileType(String filePath, String puid, String mimeType) {
        if (this.fileFormats == null) {
            return true;
        }
        return this.fileFormats.allowsFileType(this.dssID, filePath, puid, mimeType);
    }

    public String toString() {
        return "[DSS:" + (this.dssID + "/") + (this.title + "/") + ((Object)((Object)this.category) + "/") + ((Object)((Object)this.recordTypes) + "/") + (this.fileFormats + "]");
    }
}

