/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util.mets;

import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.util.mets.DuplicateNodeFile;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;

public class DuplicateFinder {
    public static ListMultimap<String, DuplicateNodeFile> getDuplicates(NodeAbstract nodeAbstract) {
        ListMultimap<String, DuplicateNodeFile> allDuplicatesList = DuplicateFinder.getAllNodeFiles(nodeAbstract);
        return DuplicateFinder.keepOnlyDuplicates(allDuplicatesList);
    }

    static ListMultimap<String, DuplicateNodeFile> getAllNodeFiles(NodeAbstract nodeAbstract) {
        ArrayListMultimap allDuplicatesList = ArrayListMultimap.create();
        List<NodeAbstract> nodeWithDescendants = nodeAbstract.getWithDescendants();
        for (NodeAbstract node : nodeWithDescendants) {
            if (!(node instanceof NodeFile)) continue;
            DuplicateNodeFile duplicate = new DuplicateNodeFile((NodeFile)node);
            allDuplicatesList.put((Object)duplicate.getChecksum(), (Object)duplicate);
        }
        return allDuplicatesList;
    }

    static ListMultimap<String, DuplicateNodeFile> keepOnlyDuplicates(ListMultimap<String, DuplicateNodeFile> allDuplicatesList) {
        ArrayListMultimap duplicatesList = ArrayListMultimap.create();
        for (String nextKey : allDuplicatesList.keySet()) {
            List valueList = allDuplicatesList.get((Object)nextKey);
            if (valueList.size() <= 1) continue;
            duplicatesList.putAll((Object)nextKey, (Iterable)valueList);
        }
        return duplicatesList;
    }

    public static boolean areAllOtherItemsSelected(List<DuplicateNodeFile> allItems, DuplicateNodeFile selectedItem) {
        boolean allSelected = true;
        for (DuplicateNodeFile duplicate : allItems) {
            if (duplicate.equals(selectedItem) || duplicate.isSelectedForDeletion()) continue;
            allSelected = false;
        }
        return allSelected;
    }

    public static boolean deleteAsDuplicates(ListMultimap<String, DuplicateNodeFile> duplicatesListMultimap, List<DuplicateNodeFile> duplicateList) {
        boolean atLeastOneDeleted = false;
        if (duplicateList.isEmpty()) {
            return atLeastOneDeleted;
        }
        DuplicateNodeFile nodeToKeep = DuplicateFinder.getDuplicateToKeep(duplicatesListMultimap, duplicateList);
        if (nodeToKeep != null) {
            for (DuplicateNodeFile duplicate : duplicateList) {
                try {
                    duplicate.getNodeFile().deleteAsDuplicate(nodeToKeep.getNodeFile());
                    atLeastOneDeleted = true;
                }
                catch (FileOperationNotAllowedException | FileUtilExceptionListException e) {
                    Logger.error((Object)"deleteAsDuplicates failed: ", (Throwable)e);
                }
            }
        }
        return atLeastOneDeleted;
    }

    static DuplicateNodeFile getDuplicateToKeep(ListMultimap<String, DuplicateNodeFile> duplicatesListMultimap, List<DuplicateNodeFile> selectedForDeletion) {
        boolean validRequest = false;
        DuplicateNodeFile duplicateToKeep = null;
        if (selectedForDeletion.size() > 0) {
            DuplicateNodeFile duplicate = selectedForDeletion.get(0);
            List valueList = duplicatesListMultimap.get((Object)duplicate.getChecksum());
            validRequest = !selectedForDeletion.containsAll(valueList) && valueList.containsAll(selectedForDeletion);
            ArrayList notSelected = new ArrayList();
            if (validRequest) {
                notSelected.addAll(valueList);
                notSelected.removeAll(selectedForDeletion);
                if (notSelected.size() > 0) {
                    duplicateToKeep = (DuplicateNodeFile)notSelected.get(0);
                }
            }
        }
        return duplicateToKeep;
    }
}

