/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.EvaluationStrategies;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderComparator
implements Comparator<BindingSet>,
Serializable {
    private static final long serialVersionUID = -7002730491398949902L;
    private final transient Logger logger = LoggerFactory.getLogger(OrderComparator.class);
    private transient EvaluationStrategy strategy;
    private UUID strategyKey;
    private final Order order;
    private transient ValueComparator cmp;

    public OrderComparator(EvaluationStrategy strategy, Order order, ValueComparator vcmp) {
        this.strategy = strategy;
        this.order = order;
        this.cmp = vcmp;
    }

    @Override
    public int compare(BindingSet o1, BindingSet o2) {
        try {
            int compare;
            for (OrderElem element : this.order.getElements()) {
                Value v2;
                Value v1 = this.evaluate(element.getExpr(), o1);
                int compare2 = this.cmp.compare(v1, v2 = this.evaluate(element.getExpr(), o2));
                if (compare2 == 0) continue;
                return element.isAscending() ? compare2 : -compare2;
            }
            if (o1 == null || o2 == null) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : -1;
                }
            }
            if (o2.size() != o1.size()) {
                return o1.size() < o2.size() ? 1 : -1;
            }
            ArrayList o1bindingNamesOrdered = new ArrayList(o1.getBindingNames());
            Collections.sort(o1bindingNamesOrdered);
            if (!o1.getBindingNames().equals(o2.getBindingNames())) {
                ArrayList o2bindingNamesOrdered = new ArrayList(o2.getBindingNames());
                Collections.sort(o2bindingNamesOrdered);
                for (int i = 0; i < o1bindingNamesOrdered.size(); ++i) {
                    String o2bn;
                    String o1bn = (String)o1bindingNamesOrdered.get(i);
                    compare = o1bn.compareTo(o2bn = (String)o2bindingNamesOrdered.get(i));
                    if (compare == 0) continue;
                    return compare;
                }
            }
            for (String bindingName : o1bindingNamesOrdered) {
                Value v2;
                Value v1 = o1.getValue(bindingName);
                compare = this.cmp.compare(v1, v2 = o2.getValue(bindingName));
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        catch (QueryEvaluationException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return 0;
        }
        catch (IllegalArgumentException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    private Value evaluate(ValueExpr valueExpr, BindingSet o) throws QueryEvaluationException {
        try {
            return this.strategy.evaluate(valueExpr, o);
        }
        catch (ValueExprEvaluationException exc) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.strategyKey = EvaluationStrategies.register(this.strategy);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.strategy = EvaluationStrategies.get(this.strategyKey);
        this.cmp = new ValueComparator();
    }
}

