/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ZipEntryIdentificationRequest;

public class ZipArchiveContentIdentifier
extends ArchiveContentIdentifier {
    public ZipArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = this.makeContainerURI("zip", request.getFileName());
        this.setSlash1("");
        InputStream zipIn = null;
        try {
            zipIn = request.getSourceInputStream();
            try (ZipArchiveInputStream in = new ZipArchiveInputStream(zipIn);){
                ZipArchiveEntry entry = null;
                while ((entry = in.getNextZipEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    RequestMetaData metaData = new RequestMetaData(Long.valueOf(entry.getSize()), Long.valueOf(2L), name);
                    RequestIdentifier identifier = new RequestIdentifier(uri);
                    ZipEntryIdentificationRequest zipRequest = new ZipEntryIdentificationRequest(metaData, identifier, this.getTmpDir(), false);
                    this.expandContainer((IdentificationRequest)zipRequest, (InputStream)in, newPath);
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe + " (" + newPath + ")");
        }
        finally {
            if (zipIn != null) {
                try {
                    zipIn.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
        }
    }
}

