/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;

public class ListAllSignatureFilesCommand
implements DroidCommand {
    private SignatureManager signatureManager;
    private PrintWriter printWriter;

    @Override
    public void execute() {
        Map sigFiles = this.signatureManager.getAvailableSignatureFiles();
        if (sigFiles.isEmpty()) {
            this.printWriter.println(I18N.getResource("signature.none"));
        } else {
            for (SortedMap sigFilesForType : sigFiles.values()) {
                for (SignatureFileInfo info : sigFilesForType.values()) {
                    this.printWriter.println(I18N.getResource("signature.display", info.getType(), info.getVersion(), info.getFile().getName()));
                }
            }
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }
}

