/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers;

import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class QueryModelTreePrinter
extends AbstractQueryModelVisitor<RuntimeException> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String indentString = "   ";
    private StringBuilder buf = new StringBuilder(256);
    private int indentLevel = 0;

    public static String printTree(QueryModelNode node) {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        node.visit(treePrinter);
        return treePrinter.getTreeString();
    }

    public String getTreeString() {
        return this.buf.toString();
    }

    @Override
    protected void meetNode(QueryModelNode node) {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.buf.append(this.indentString);
        }
        this.buf.append(node.getSignature());
        this.buf.append(LINE_SEPARATOR);
        ++this.indentLevel;
        super.meetNode(node);
        --this.indentLevel;
    }
}

