/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLCharacterMap
extends StyleElement {
    String use;
    List<XSLCharacterMap> characterMapElements = null;
    boolean validated = false;
    boolean redundant = false;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    public StructuredQName getCharacterMapName() {
        StructuredQName name = this.getObjectName();
        if (name == null) {
            try {
                return this.makeQName(this.getAttributeValue("", "name"));
            }
            catch (Exception err) {
                return new StructuredQName("", "", "unnamedCharacterMap_" + this.hashCode());
            }
        }
        return name;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String name = null;
        this.use = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                name = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-character-maps")) {
                this.use = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (name == null) {
            this.reportAbsence("name");
            name = "unnamedCharacterMap_" + this.hashCode();
        }
        try {
            this.setObjectName(this.makeQName(name));
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
            name = "unnamedCharacterMap_" + this.hashCode();
            this.setObjectName(new StructuredQName("", "", name));
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), "XTSE0020");
            name = "unnamedCharacterMap_" + this.hashCode();
            this.setObjectName(new StructuredQName("", "", name));
        }
    }

    @Override
    public void validate(Declaration decl) throws XPathException {
        Object child;
        if (this.validated) {
            return;
        }
        this.checkTopLevel("XTSE0010");
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLOutputCharacter) continue;
            this.compileError("Only xsl:output-character is allowed within xsl:character-map", "XTSE0010");
        }
        PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
        Declaration other = psm.getCharacterMap(this.getObjectName());
        if (other.getSourceElement() != this) {
            if (decl.getPrecedence() == other.getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence", "XTSE1580");
            } else if (decl.getPrecedence() < other.getPrecedence()) {
                this.redundant = true;
            }
        }
        if (this.use != null) {
            this.characterMapElements = new ArrayList<XSLCharacterMap>(5);
            StringTokenizer st = new StringTokenizer(this.use, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String displayname = st.nextToken();
                try {
                    StructuredQName qn;
                    Declaration charMapDecl;
                    String[] parts = this.getConfiguration().getNameChecker().getQNameParts(displayname);
                    String uri = this.getURIForPrefix(parts[0], false);
                    if (uri == null) {
                        this.compileError("Undeclared namespace prefix " + Err.wrap(parts[0]) + " in character map name", "XTSE0280");
                    }
                    if ((charMapDecl = psm.getCharacterMap(qn = new StructuredQName(parts[0], uri, parts[1]))) == null) {
                        this.compileError("No character-map named '" + displayname + "' has been defined", "XTSE1590");
                        continue;
                    }
                    XSLCharacterMap ref = (XSLCharacterMap)charMapDecl.getSourceElement();
                    this.characterMapElements.add(ref);
                }
                catch (QNameException err) {
                    this.compileError("Invalid character-map name. " + err.getMessage(), "XTSE1590");
                }
            }
            for (XSLCharacterMap characterMapElement : this.characterMapElements) {
                characterMapElement.checkCircularity(this);
            }
        }
        this.validated = true;
    }

    private void checkCircularity(XSLCharacterMap origin) throws XPathException {
        if (this == origin) {
            this.compileError("The definition of the character map is circular", "XTSE1600");
            this.characterMapElements = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.characterMapElements != null) {
                for (XSLCharacterMap characterMapElement : this.characterMapElements) {
                    characterMapElement.checkCircularity(origin);
                }
            }
        }
    }

    public void assemble(IntHashMap<String> map) {
        if (this.characterMapElements != null) {
            Iterator<XSLCharacterMap> i$ = this.characterMapElements.iterator();
            while (i$.hasNext()) {
                XSLCharacterMap characterMapElement;
                XSLCharacterMap charmap = characterMapElement = i$.next();
                charmap.assemble(map);
            }
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        Object child;
        while ((child = kids.next()) != null) {
            XSLOutputCharacter oc = (XSLOutputCharacter)child;
            map.put(oc.getCodePoint(), oc.getReplacementString());
        }
        return;
    }

    @Override
    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
    }
}

