/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.exception.ConfigurationFileLoaderException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class ConfigurationFileLoader {
    private static final String DEFAULT_CONFIG_DIRECTORY = "config/";
    private final String workingDirectory;
    private String customConfigDirectory;

    public ConfigurationFileLoader() {
        this(null, null);
    }

    public ConfigurationFileLoader(String customConfigDirectory) {
        this(null, customConfigDirectory);
    }

    public ConfigurationFileLoader(String workingDirectory, String customConfigDirectory) {
        this.workingDirectory = workingDirectory != null && workingDirectory.trim() != "" ? workingDirectory : System.getProperty("user.dir");
        if (customConfigDirectory != null && customConfigDirectory.trim() != "") {
            this.customConfigDirectory = customConfigDirectory;
        }
    }

    public File load(String configurationFileName) throws ConfigurationFileLoaderException {
        File configurationFileFromCustomConfigDirectory;
        Logger.debug(String.format("Load configuration file with name %s", configurationFileName));
        if (this.customConfigDirectory != null && this.customConfigDirectory.trim() != "" && (configurationFileFromCustomConfigDirectory = this.tryLoadFromCustomConfigDirectory(configurationFileName)) != null) {
            return configurationFileFromCustomConfigDirectory;
        }
        File configurationFileFromWorkingDirectory = this.tryLoadFromWorkingDirectory(configurationFileName);
        if (configurationFileFromWorkingDirectory != null) {
            return configurationFileFromWorkingDirectory;
        }
        return this.loadFromResources(DEFAULT_CONFIG_DIRECTORY + configurationFileName);
    }

    public Properties loadProperties(String configurationFileName) throws ConfigurationFileLoaderException {
        Properties properties = new Properties();
        File configurationFile = this.load(configurationFileName);
        try (FileInputStream inputStream = new FileInputStream(configurationFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new ConfigurationFileLoaderException("Unable to load properties from configuration file: " + configurationFile.getAbsolutePath());
        }
        return properties;
    }

    private File tryLoadFromCustomConfigDirectory(String configurationFileName) throws ConfigurationFileLoaderException {
        String absoluteCustomConfigurationFilePath = this.customConfigDirectory + "/" + configurationFileName;
        File absoluteCustomConfigurationFile = new File(absoluteCustomConfigurationFilePath);
        if (absoluteCustomConfigurationFile.exists()) {
            Logger.debug(String.format("Return custom configuration file %s", absoluteCustomConfigurationFile.getAbsolutePath()));
            return absoluteCustomConfigurationFile;
        }
        String relativeCustomConfigurationFilePath = this.workingDirectory + "/" + this.customConfigDirectory + "/" + configurationFileName;
        File relativeCustomConfigurationFile = new File(relativeCustomConfigurationFilePath);
        if (relativeCustomConfigurationFile.exists()) {
            Logger.debug(String.format("Return custom configuration file %s", relativeCustomConfigurationFile.getAbsolutePath()));
            return relativeCustomConfigurationFile;
        }
        return null;
    }

    private File tryLoadFromWorkingDirectory(String configurationFileName) {
        Path configurationFilePath = Paths.get(this.workingDirectory + "/" + DEFAULT_CONFIG_DIRECTORY + configurationFileName, new String[0]);
        if (Files.exists(configurationFilePath, new LinkOption[0])) {
            Logger.debug(String.format("Return configuration file from 'config/' directory relative to working directory: %s", configurationFilePath));
            return configurationFilePath.toFile();
        }
        return null;
    }

    private File loadFromResources(String filePath) throws ConfigurationFileLoaderException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resource = classLoader.getResource(filePath);
        if (resource != null) {
            Logger.debug(String.format("Return configuration file from classpath: %s", resource.toString()));
            try {
                return new File(resource.toURI());
            }
            catch (URISyntaxException e) {
                throw new ConfigurationFileLoaderException(String.format("Could not load configuration file from resources: %s", resource), e);
            }
        }
        throw new ConfigurationFileLoaderException(String.format("Configuration file not found in resources: %s", filePath));
    }
}

