/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.filter.CommandLineFilter;
import uk.gov.nationalarchives.droid.command.filter.DqlFilterParser;
import uk.gov.nationalarchives.droid.command.filter.SimpleFilter;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.report.ReportTransformException;
import uk.gov.nationalarchives.droid.report.ReportTransformerImpl;
import uk.gov.nationalarchives.droid.report.interfaces.Report;
import uk.gov.nationalarchives.droid.report.interfaces.ReportCancelledException;
import uk.gov.nationalarchives.droid.report.interfaces.ReportManager;
import uk.gov.nationalarchives.droid.report.interfaces.ReportRequest;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;
import uk.gov.nationalarchives.droid.report.interfaces.ReportXmlWriter;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ReportCommand
implements DroidCommand {
    private static final String DROID_REPORT_XML = "DROID Report XML";
    private static final String PDF_FORMAT = "PDF";
    private static final String XHTML_TRANSFORM_LOCATION = "Web page.html.xsl";
    private static final String UTF8 = "UTF-8";
    private String[] profiles;
    private ReportManager reportManager;
    private ProfileManager profileManager;
    private ReportXmlWriter reportXmlWriter;
    private String destination;
    private String reportType;
    private DroidGlobalConfig config;
    private String reportOutputType = "pdf";
    private DqlFilterParser dqlFilterParser;
    private CommandLineFilter cliFilter;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute() throws CommandExecutionException {
        ArrayList<String> profileIds = new ArrayList<String>();
        SimpleFilter filter = null;
        if (this.cliFilter != null) {
            filter = new SimpleFilter(this.cliFilter.getFilterType());
            for (String dql : this.cliFilter.getFilters()) {
                filter.add(this.dqlFilterParser.parse(dql));
            }
        }
        for (String profileLocation : this.profiles) {
            try {
                ProfileInstance profile = this.profileManager.open(Paths.get(profileLocation, new String[0]), new ProgressObserver(){

                    public void onProgress(Integer progress) {
                    }
                });
                profileIds.add(profile.getUuid());
            }
            catch (IOException e) {
                throw new CommandExecutionException(e);
            }
        }
        ReportRequest request = new ReportRequest();
        request.setProfileIds(profileIds);
        List reportSpecs = this.reportManager.listReportSpecs();
        for (ReportSpec reportSpec : reportSpecs) {
            if (!reportSpec.getName().equals(this.reportType)) continue;
            request.setReportSpec(reportSpec);
            break;
        }
        if (request.getReportSpec() == null) {
            throw new CommandExecutionException(String.format("Report [%s] not found.", this.reportType));
        }
        this.writeReport(request, filter);
        this.profileManager.closeProfile((String)profileIds.get(0));
    }

    private void writeReport(ReportRequest request, Filter optionalFilter) throws CommandExecutionException {
        block40: {
            try {
                Report report = this.reportManager.generateReport(request, optionalFilter, null);
                ReportTransformerImpl transformer = new ReportTransformerImpl();
                transformer.setConfig(this.config);
                String message = String.format("Exporting report as [%s] to: [%s]", this.reportOutputType, this.destination);
                this.log.info(message);
                Path destinationPath = Paths.get(this.destination, new String[0]);
                if (DROID_REPORT_XML.equalsIgnoreCase(this.reportOutputType)) {
                    try (BufferedWriter tempReport = Files.newBufferedWriter(destinationPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                        this.reportXmlWriter.writeReport(report, (Writer)tempReport);
                        break block40;
                    }
                }
                Path tempFile = Files.createTempFile(this.config.getTempDir(), "report~", ".xml", new FileAttribute[0]);
                try (BufferedWriter tempReport = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                    this.reportXmlWriter.writeReport(report, (Writer)tempReport);
                }
                if (PDF_FORMAT.equalsIgnoreCase(this.reportOutputType)) {
                    try (BufferedReader reader = Files.newBufferedReader(tempFile, StandardCharsets.UTF_8);
                         OutputStream out = Files.newOutputStream(destinationPath, new OpenOption[0]);){
                        transformer.transformToPdf((Reader)reader, XHTML_TRANSFORM_LOCATION, out);
                        break block40;
                    }
                }
                ReportSpec spec = request.getReportSpec();
                Path xslFile = this.getXSLFile(spec.getXslTransforms());
                if (xslFile == null) break block40;
                try (BufferedReader reader = Files.newBufferedReader(tempFile, StandardCharsets.UTF_8);
                     BufferedWriter out = Files.newBufferedWriter(destinationPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                    transformer.transformUsingXsl((Reader)reader, xslFile, (Writer)out);
                }
            }
            catch (IOException | TransformerException | ReportTransformException | ReportCancelledException e) {
                throw new CommandExecutionException(e.getMessage(), e);
            }
        }
    }

    private Path getXSLFile(List<Path> xslTransforms) {
        for (Path file : xslTransforms) {
            String transformName = StringUtils.substringBefore((String)file.getFileName().toString(), (String)".");
            if (!transformName.equalsIgnoreCase(this.reportOutputType)) continue;
            return file;
        }
        return null;
    }

    public void setProfiles(String[] profileList) {
        this.profiles = profileList;
    }

    String[] getProfiles() {
        return this.profiles;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    String getDestination() {
        return this.destination;
    }

    public void setReportManager(ReportManager reportManager) {
        this.reportManager = reportManager;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void setReportOutputType(String reportOutputType) {
        this.reportOutputType = reportOutputType;
    }

    public void setReportXmlWriter(ReportXmlWriter reportXmlWriter) {
        this.reportXmlWriter = reportXmlWriter;
    }

    public void setFilter(CommandLineFilter filter) {
        this.cliFilter = filter;
    }

    public void setDqlFilterParser(DqlFilterParser dqlFilterParser) {
        this.dqlFilterParser = dqlFilterParser;
    }

    public DroidGlobalConfig getConfig() {
        return this.config;
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }
}

