/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.ant.compress.util.SevenZStreamFactory;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.io.input.BoundedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.SevenZipEntryIdentificationRequest;

public class SevenZipArchiveContainerIdentifier
extends ArchiveContentIdentifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SevenZipArchiveContainerIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, archiveConfiguration);
    }

    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = this.makeContainerURI("7z", request.getFileName());
        this.setSlash1("");
        if (request.getClass().isAssignableFrom(FileSystemIdentificationRequest.class)) {
            FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)request;
            try {
                SevenZStreamFactory sevenZStreamFactory = new SevenZStreamFactory();
                try (ArchiveInputStream archiveStream = sevenZStreamFactory.getArchiveInputStream(req.getFile().toFile(), null);){
                    SevenZArchiveEntry entry;
                    while ((entry = (SevenZArchiveEntry)archiveStream.getNextEntry()) != null) {
                        this.processEntry(entry, archiveStream, uri, newPath);
                    }
                }
            }
            catch (IOException e) {
                System.err.println(e + " (" + newPath + ")");
            }
        } else {
            this.log.info("Identification request for 7z archive ignored due to limited support.");
        }
    }

    private void processEntry(SevenZArchiveEntry entry, ArchiveInputStream archiveStream, URI uri, String newPath) throws CommandExecutionException {
        String name = entry.getName();
        if (!entry.isDirectory()) {
            RequestMetaData metaData = new RequestMetaData(Long.valueOf(entry.getSize()), Long.valueOf(2L), name);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            SevenZipEntryIdentificationRequest req = new SevenZipEntryIdentificationRequest(metaData, identifier, this.getTmpDir());
            BoundedInputStream entryStream = new BoundedInputStream((InputStream)archiveStream, entry.getSize());
            entryStream.setPropagateClose(false);
            this.expandContainer((IdentificationRequest)req, (InputStream)entryStream, newPath);
        } else {
            this.log.debug("processing directory : " + entry.getName());
        }
    }
}

