/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.warc.WarcReader;
import org.jwat.warc.WarcReaderFactory;
import org.jwat.warc.WarcRecord;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.WebArchiveEntryRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class WarcArchiveContentIdentifier
extends ArchiveContentIdentifier {
    public WarcArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, archiveConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        int httpACCEPTED = 200;
        String newPath = this.makeContainerURI("warc", request.getFileName());
        this.setSlash1("");
        WebArchiveEntryRequestFactory factory = new WebArchiveEntryRequestFactory();
        try {
            InputStream warcIn = request.getSourceInputStream();
            WarcReader warcReader = WarcReaderFactory.getReader((InputStream)warcIn);
            Iterator iterator = warcReader.iterator();
            try {
                WarcRecord record = null;
                while (iterator.hasNext()) {
                    record = (WarcRecord)iterator.next();
                    if (!"response".equals(record.header.warcTypeStr) || record.getHttpHeader() == null || 200 != record.getHttpHeader().statusCode) continue;
                    String name = record.header.warcTargetUriStr;
                    Long time = record.header.warcDate == null ? null : Long.valueOf(record.header.warcDate.getTime());
                    RequestMetaData metaData = new RequestMetaData(record.header.contentLength, time, name);
                    RequestIdentifier identifier = new RequestIdentifier(uri);
                    IdentificationRequest warcRequest = factory.newRequest(metaData, identifier);
                    ByteCountingPushBackInputStream in = (ByteCountingPushBackInputStream)record.getPayloadContent();
                    this.expandContainer(warcRequest, (InputStream)in, newPath);
                }
            }
            finally {
                if (warcIn != null) {
                    warcIn.close();
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe + ": " + newPath);
        }
    }
}

