/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.filter.Creator;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DirectoryStreamFilterCreator {
    private static final String STRING_DOT = ".";
    private final boolean recursive;
    private final String[] extensions;

    public DirectoryStreamFilterCreator(boolean recursive, String[] extensions) {
        this.recursive = recursive;
        this.extensions = extensions;
    }

    public DirectoryStreamFilterCreator() {
        this(false, null);
    }

    public DirectoryStream.Filter<Path> create() {
        DirectoryStream.Filter<Path> filter = this.recursive ? new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                boolean retVal = true;
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    if (DirectoryStreamFilterCreator.this.extensions == null || DirectoryStreamFilterCreator.this.extensions.length == 0) {
                        retVal = true;
                    } else {
                        retVal = false;
                        for (String extension : DirectoryStreamFilterCreator.this.extensions) {
                            if (!entry.getFileName().toString().endsWith(DirectoryStreamFilterCreator.STRING_DOT + extension)) continue;
                            retVal = true;
                        }
                    }
                }
                return retVal;
            }
        } : new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                boolean retVal = false;
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    if (DirectoryStreamFilterCreator.this.extensions == null || DirectoryStreamFilterCreator.this.extensions.length == 0) {
                        retVal = true;
                    } else {
                        for (String extension : DirectoryStreamFilterCreator.this.extensions) {
                            if (!entry.getFileName().toString().endsWith(DirectoryStreamFilterCreator.STRING_DOT + extension)) continue;
                            retVal = true;
                        }
                    }
                }
                return retVal;
            }
        };
        return filter;
    }
}

