/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

@Deprecated
public class CSVFileReader {
    protected static final Character DefaultSeparator = Character.valueOf(';');
    protected static final Character QuoteCharacter = Character.valueOf('\"');
    protected List<List<String>> list = new ArrayList<List<String>>();
    protected List<String> header = new ArrayList<String>();

    public CSVFileReader(String csvFilePath) throws IOException {
        this(csvFilePath, DefaultSeparator);
    }

    public CSVFileReader(String csvFilePath, Character separator) throws IOException {
        this(csvFilePath, separator, true);
    }

    public CSVFileReader(String csvFilePath, boolean hasHeaderLine) throws IOException {
        this(csvFilePath, DefaultSeparator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVFileReader(String csvFilePath, Character separator, boolean hasHeaderLine) throws IOException {
        Logger.info("Reading file: " + csvFilePath);
        try (BufferedReader reader = new BufferedReader(new FileReader(csvFilePath));){
            String line;
            boolean is1stLine = true;
            do {
                if ((line = reader.readLine()) == null) {
                    break;
                }
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                List<String> tokensTrimmed = CSVFileReader.split(line, separator);
                if (hasHeaderLine && is1stLine) {
                    is1stLine = false;
                    this.header = tokensTrimmed;
                    continue;
                }
                this.list.add(tokensTrimmed);
            } while (line != null);
        }
    }

    private static List<String> split(String line, Character separator) {
        if (!line.contains(QuoteCharacter.toString())) {
            String[] tokens = line.split(separator.toString());
            ArrayList<String> tokensTrimmed = new ArrayList<String>(tokens.length);
            for (String s : tokens) {
                tokensTrimmed.add(s.trim());
            }
            return tokensTrimmed;
        }
        boolean isWithinQuotes = false;
        Vector<String> tokens = new Vector<String>(StringUtil.occurrencesOf(line, 1 + separator.toString()));
        StringBuilder tokenBuilder = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            Character c = Character.valueOf(line.charAt(i));
            if (c.equals(QuoteCharacter)) {
                if (isWithinQuotes) {
                    if (Character.valueOf(line.charAt(i + 1)).equals(QuoteCharacter)) {
                        tokenBuilder.append(c);
                        ++i;
                        continue;
                    }
                    tokens.add(tokenBuilder.toString().trim());
                    tokenBuilder = new StringBuilder();
                    isWithinQuotes = false;
                    ++i;
                    continue;
                }
                isWithinQuotes = true;
                continue;
            }
            if (c.equals(separator)) {
                if (isWithinQuotes) {
                    tokenBuilder.append(c);
                    continue;
                }
                tokens.add(tokenBuilder.toString().trim());
                tokenBuilder = new StringBuilder();
                continue;
            }
            tokenBuilder.append(c);
        }
        tokens.add(tokenBuilder.toString().trim());
        return tokens;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<String> get(int i) {
        return this.list.get(i);
    }

    public String get(int row, int column) {
        return this.list.get(row).get(column);
    }

    public String get(int row, String columnName) {
        return this.get(row, this.indexOfColumn(columnName));
    }

    public List<List<String>> getAll() {
        return this.list;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<String> findFirstRow(int column, String find) {
        for (List<String> tokens : this.list) {
            if (!tokens.get(column).equals(find)) continue;
            return tokens;
        }
        return null;
    }

    public List<String> findFirstRowIgnoreCase(int column, String find) {
        for (List<String> tokens : this.list) {
            if (!tokens.get(column).equalsIgnoreCase(find)) continue;
            return tokens;
        }
        return null;
    }

    public List<String> findFirstRowContaining(int column, String find) {
        for (List<String> tokens : this.list) {
            if (!tokens.get(column).contains(find)) continue;
            return tokens;
        }
        return null;
    }

    public List<String> findFirstRow(String columnName, String find) {
        return this.findFirstRow(this.indexOfColumn(columnName), find);
    }

    public List<String> findFirstRowIgnoreCase(String columnName, String find) {
        return this.findFirstRowIgnoreCase(this.indexOfColumn(columnName), find);
    }

    public List<String> findFirstRowContaining(String columnName, String find) {
        return this.findFirstRowContaining(this.indexOfColumn(columnName), find);
    }

    public List<List<String>> findAllRows(int column, String find) {
        Vector<List<String>> found = new Vector<List<String>>();
        for (List<String> tokens : this.list) {
            if (!tokens.get(column).equals(find)) continue;
            found.add(tokens);
        }
        return found;
    }

    public List<List<String>> findAllRowsIgnoreCase(int column, String find) {
        Vector<List<String>> found = new Vector<List<String>>();
        for (List<String> tokens : this.list) {
            if (!tokens.get(column).equalsIgnoreCase(find)) continue;
            found.add(tokens);
        }
        return found;
    }

    public List<List<String>> findAllRowsContaining(int column, String find) {
        Vector<List<String>> found = new Vector<List<String>>();
        for (List<String> tokens : this.list) {
            if (!tokens.get(column).contains(find)) continue;
            found.add(tokens);
        }
        return found;
    }

    public List<List<String>> findAllRows(String columnName, String find) {
        return this.findAllRows(this.indexOfColumn(columnName), find);
    }

    public List<List<String>> findAllRowsIgnoreCase(String columnName, String find) {
        return this.findAllRowsIgnoreCase(this.indexOfColumn(columnName), find);
    }

    public List<List<String>> findAllRowsContaining(String columnName, String find) {
        return this.findAllRowsContaining(this.indexOfColumn(columnName), find);
    }

    private int indexOfColumn(String columnName) {
        int column = this.header.indexOf(columnName);
        if (column == -1) {
            throw new IndexOutOfBoundsException("ColumnName not found: '" + columnName + "'");
        }
        return column;
    }
}

