/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.sunraster.PaletteSunRasterEncoder;
import com.sun.jimi.core.encoder.sunraster.RGBSunRasterEncoder;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import com.sun.jimi.core.options.SunRasterOptions;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.PropertyOwner;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;
import java.util.Enumeration;

public class SunRasterEncoder
extends JimiEncoderBase
implements OptionsObject {
    protected int state_;
    protected OutputStream output_;
    static final boolean DEFAULT_COMPRESSION = true;
    protected boolean useRLE_ = true;
    static final String OPTION_COMPRESSION = "compression";
    static final Boolean[] POSSIBLE_COMPRESSION_VALUES = PropertyOwner.BOOLEAN_ARRAY;
    static final String[] OPTION_NAMES = new String[]{"compression"};

    public void clearProperties() {
        this.setUseRLE(true);
    }

    protected SpecificEncoder createEncoder() throws JimiException {
        SpecificEncoder specificEncoder;
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        SunRasterHeader sunRasterHeader = new SunRasterHeader(adaptiveRasterImage);
        ColorModel colorModel = adaptiveRasterImage.getColorModel();
        if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() == 8) {
            specificEncoder = new PaletteSunRasterEncoder();
            ((PaletteSunRasterEncoder)specificEncoder).setUseRLE(this.useRLE_);
        } else {
            specificEncoder = new RGBSunRasterEncoder();
        }
        specificEncoder.initEncoder(sunRasterHeader, this.output_, adaptiveRasterImage);
        return specificEncoder;
    }

    public boolean driveEncoder() throws JimiException {
        try {
            SpecificEncoder specificEncoder = this.createEncoder();
            specificEncoder.doImageEncode();
        }
        catch (JimiException jimiException) {
            this.state_ = 1;
            throw jimiException;
        }
        this.state_ = 2;
        return false;
    }

    public OptionsObject getOptionsObject() {
        return this;
    }

    public Object getPossibleValuesForProperty(String string) {
        if (string.equalsIgnoreCase(OPTION_COMPRESSION)) {
            return POSSIBLE_COMPRESSION_VALUES;
        }
        return null;
    }

    public Object getProperty(String string) {
        return null;
    }

    public String getPropertyDescription(String string) throws InvalidOptionException {
        if (string.equalsIgnoreCase(OPTION_COMPRESSION)) {
            return "RLE compression tends to be smaller than not using compression";
        }
        throw new InvalidOptionException("No such option");
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(OPTION_NAMES);
    }

    public int getState() {
        return this.state_;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.output_ = outputStream;
        if (adaptiveRasterImage.getOptions() instanceof SunRasterOptions) {
            this.setUseRLE(((SunRasterOptions)adaptiveRasterImage.getOptions()).isUsingRLE());
        }
    }

    public void setProperty(String string, Object object) throws InvalidOptionException {
        if (string.equalsIgnoreCase(OPTION_COMPRESSION)) {
            try {
                this.setUseRLE((Boolean)object);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidOptionException("Must specify a java.lang.Boolean value");
            }
        }
        throw new InvalidOptionException("No such option");
    }

    void setUseRLE(boolean bl) {
        this.useRLE_ = bl;
    }
}

