/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import org.apache.commons.lang.StringUtils;

public class GeneralServerUtil {
    private static final ExLogger log = ExLogger.getExLogger(GeneralServerUtil.class);

    public static String getAppRole() {
        String appRole = GlobalProperties.getInstance().getProperty("app.role");
        if (StringUtils.isBlank((String)appRole)) {
            log.warn((Object)"No global property app.role found. Using system property APP_ROLE", new String[0]);
            appRole = System.getProperty("APP_ROLE");
        }
        return appRole;
    }

    public static boolean serverHasRepRole() {
        return GeneralServerUtil.hasRole("REP");
    }

    public static boolean serverHasDepRole() {
        return GeneralServerUtil.hasRole("DEP");
    }

    public static boolean serverHasPerRole() {
        return GeneralServerUtil.hasRole("PER");
    }

    public static boolean serverHasDelRole() {
        return GeneralServerUtil.hasRole("DEL");
    }

    public static boolean serverHasIdxRole() {
        return GeneralServerUtil.hasRole("IDX");
    }

    private static boolean hasRole(String role) {
        String appRole = GeneralServerUtil.getAppRole();
        if (StringUtils.isEmpty((String)appRole)) {
            log.warn((Object)("Server has no role, won't start " + role + " services"), new String[0]);
        }
        return StringUtils.contains((String)appRole, (String)role);
    }
}

