/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.dmdsec;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.dmdsec.DMDSectionAbstract;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.out.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class DmdSectionWithMarc
extends DMDSectionAbstract {
    private static final String OAI_MARC_SCHEMA_LOCATION = "http://www.openarchives.org/OAI/1.1/oai_marc.xsd";
    private static final String OAI_MARC_NAMESPACE_URI = "http://www.openarchives.org/OAI/1.1/oai_marc";

    public DmdSectionWithMarc(NodeAbstract structMapNode, Element oaiMarcNode, Document mets) {
        super(mets);
        Namespace oaiMarcNamespace = this.addMarcNamespaceAndSchemaIfNecessary(mets);
        this.recursivelySetNamespace(oaiMarcNode, oaiMarcNamespace);
        Element mdWrap = this.element.addElement("METS:mdWrap").addAttribute("MDTYPE", "MARC");
        Element xmlData = mdWrap.addElement("METS:xmlData");
        xmlData.add(oaiMarcNode);
        this.addMetadataInformationToStructureMap(structMapNode, this.getId(), mets);
    }

    private void addMetadataInformationToStructureMap(NodeAbstract structMapNode, String marcNodeId, Document mets) {
        Element metadataElement = structMapNode.getElement().addElement("METS:div").addAttribute("LABEL", "MARC").addAttribute("TYPE", "metadata");
        metadataElement.addAttribute("DMDID", marcNodeId);
    }

    private Namespace addMarcNamespaceAndSchemaIfNecessary(Document mets) {
        Logger.debug((Object)"Addinng MARC namespace to root element");
        mets.getRootElement().addNamespace("oai_marc", OAI_MARC_NAMESPACE_URI);
        Namespace oaiMarcNamespace = mets.getRootElement().getNamespaceForPrefix("oai_marc");
        Attribute schemaLocation = mets.getRootElement().attribute("schemaLocation");
        if (!schemaLocation.getValue().contains(OAI_MARC_SCHEMA_LOCATION)) {
            schemaLocation.setValue(schemaLocation.getValue() + "   " + OAI_MARC_NAMESPACE_URI + "   " + OAI_MARC_SCHEMA_LOCATION);
        }
        return oaiMarcNamespace;
    }

    private void recursivelySetNamespace(Element element, Namespace namespace) {
        Logger.debug((Object)"Adding proper namespace for MARC");
        element.setQName(new QName(element.getName(), namespace));
        for (Object subElement : element.elements()) {
            this.recursivelySetNamespace((Element)subElement, namespace);
        }
    }
}

