/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.filter.Creator.DirectoryStreamFilterCreator;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class NoProfileRunCommand
implements DroidCommand {
    private static final String EXTENSION_FILTER_NOT_APPLICABLE = "Ignoring extension filter option since it is not applicable when the selected resource is a file.";
    private static final String RECURSE_NOT_APPLICABLE = "Ignoring recurse folders option since it is not applicable when the selected resource is a file.";
    private static final String MULTIPLE_RESOURCES_SPECIFIED = "You specified more than one folder/file. Only the first item specified (%s) will be processed";
    private static final String FORWARD_SLASH = "/";
    private static final String BACKWARD_SLASH = "\\";
    private static final String PRINTABLE_TRUE = "True";
    private static final String PRINTABLE_FALSE = "False";
    private static final String PRINTABLE_ALL = "All";
    private static final String PRINTABLE_NONE = "None";
    private String fileSignaturesFileName;
    private String containerSignaturesFileName;
    private String[] resources;
    private String[] extensions;
    private int maxBytesToScan = -1;
    private boolean quietFlag;
    private boolean recursive;
    private boolean expandAllArchives;
    private String[] expandArchiveTypes;
    private boolean expandAllWebArchives;
    private String[] expandWebArchiveTypes;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute() throws CommandExecutionException {
        List matchedFiles;
        Path targetDirectoryOrFile = Paths.get(this.resources[0], new String[0]);
        if (!this.quietFlag) {
            this.outputRuntimeInformation(targetDirectoryOrFile);
        }
        if (Files.isDirectory(targetDirectoryOrFile, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStreamFilterCreator(this.recursive, this.extensions).create();
            try {
                matchedFiles = FileUtil.listFiles((Path)targetDirectoryOrFile, (boolean)this.recursive, filter);
            }
            catch (IOException e) {
                throw new CommandExecutionException("Can't find input files");
            }
        } else if (Files.isRegularFile(targetDirectoryOrFile, new LinkOption[0])) {
            matchedFiles = new ArrayList<Path>();
            matchedFiles.add(targetDirectoryOrFile);
        } else {
            throw new CommandExecutionException(String.format("The specified input %s was not found", targetDirectoryOrFile));
        }
        BinarySignatureIdentifier binarySignatureIdentifier = new BinarySignatureIdentifier();
        Path fileSignaturesFile = Paths.get(this.fileSignaturesFileName, new String[0]);
        if (!Files.exists(fileSignaturesFile, new LinkOption[0])) {
            throw new CommandExecutionException("Signature file not found");
        }
        binarySignatureIdentifier.setSignatureFile(this.fileSignaturesFileName);
        try {
            binarySignatureIdentifier.init();
        }
        catch (SignatureParseException e) {
            throw new CommandExecutionException("Can't parse signature file");
        }
        binarySignatureIdentifier.setMaxBytesToScan((long)this.maxBytesToScan);
        String path = fileSignaturesFile.toAbsolutePath().toString();
        String slash = path.contains(FORWARD_SLASH) ? FORWARD_SLASH : BACKWARD_SLASH;
        ContainerSignatureDefinitions containerSignatureDefinitions = null;
        if (this.containerSignaturesFileName != null) {
            Path containerSignaturesFile = Paths.get(this.containerSignaturesFileName, new String[0]);
            if (!Files.exists(containerSignaturesFile, new LinkOption[0])) {
                throw new CommandExecutionException("Container signature file not found");
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(containerSignaturesFile, new OpenOption[0]));){
                ContainerSignatureSaxParser parser = new ContainerSignatureSaxParser();
                containerSignatureDefinitions = parser.parse((InputStream)in);
            }
            catch (SignatureParseException e) {
                throw new CommandExecutionException("Can't parse container signature file");
            }
            catch (IOException | JAXBException ioe) {
                throw new CommandExecutionException(ioe);
            }
        }
        path = "";
        ResultPrinter resultPrinter = new ResultPrinter(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash, new ArchiveConfiguration(this.expandAllArchives, this.expandArchiveTypes, this.expandAllWebArchives, this.expandWebArchiveTypes));
        for (Path file : matchedFiles) {
            String fileName = file.toAbsolutePath().toString();
            URI uri = file.toUri();
            RequestMetaData metaData = new RequestMetaData(Long.valueOf(FileUtil.sizeQuietly((Path)file)), Long.valueOf(FileUtil.lastModifiedQuietly((Path)file).toMillis()), fileName);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            identifier.setParentId(Long.valueOf(1L));
            try (FileSystemIdentificationRequest request = new FileSystemIdentificationRequest(metaData, identifier);){
                request.open((Object)file);
                IdentificationResultCollection results = binarySignatureIdentifier.matchBinarySignatures((IdentificationRequest)request);
                resultPrinter.print(results, (IdentificationRequest)request);
            }
            catch (FileNotFoundException fnfe) {
                this.log.error("error processing files", (Throwable)fnfe);
                throw new CommandExecutionException(fnfe);
            }
            catch (IOException e) {
                throw new CommandExecutionException(e);
            }
        }
    }

    private void outputRuntimeInformation(Path targetDirectoryOrFile) {
        if (this.resources.length > 1) {
            System.out.println(String.format(MULTIPLE_RESOURCES_SPECIFIED, targetDirectoryOrFile));
        }
        String versionString = ResourceBundle.getBundle("options").getString("version_no");
        System.out.println("DROID " + versionString + " No Profile mode: Runtime Information");
        System.out.println("Selected folder or file: " + this.resources[0]);
        System.out.println("Binary signature file: " + this.fileSignaturesFileName);
        System.out.println("Container signature file: " + (this.containerSignaturesFileName == null ? " None" : this.containerSignaturesFileName));
        if (Files.isDirectory(targetDirectoryOrFile, new LinkOption[0])) {
            System.out.println("Recurse folders: " + (this.recursive ? PRINTABLE_TRUE : PRINTABLE_FALSE));
            if (this.extensions == null) {
                System.out.println("Extension filter: No filter set");
            } else {
                System.out.println("Extension filter: " + Arrays.toString(this.extensions).replace("[", "").replace("]", "").trim());
            }
        }
        if (!Files.isDirectory(targetDirectoryOrFile, new LinkOption[0])) {
            if (this.recursive) {
                System.out.println(RECURSE_NOT_APPLICABLE);
            }
            if (this.extensions != null) {
                System.out.println(EXTENSION_FILTER_NOT_APPLICABLE);
            }
        }
        System.out.println("Open archives: " + (this.expandAllArchives ? PRINTABLE_ALL : (this.expandArchiveTypes != null && this.expandArchiveTypes.length > 0 ? String.join((CharSequence)", ", this.expandArchiveTypes) : PRINTABLE_NONE)));
        System.out.println("Open web archives: " + (this.expandAllWebArchives ? PRINTABLE_ALL : (this.expandWebArchiveTypes != null && this.expandWebArchiveTypes.length > 0 ? String.join((CharSequence)", ", this.expandWebArchiveTypes) : PRINTABLE_NONE)));
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public void setSignatureFile(String signatureFile) {
        this.fileSignaturesFileName = signatureFile;
    }

    public void setContainerSignatureFile(String containerSignatureFile) {
        this.containerSignaturesFileName = containerSignatureFile;
    }

    public void setExpandAllWebArchives(boolean expandAllWebArchives) {
        this.expandAllWebArchives = expandAllWebArchives;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setExtensionFilter(String[] extensionsFilter) {
        this.extensions = extensionsFilter;
    }

    public void setQuiet(boolean quiet) {
        this.quietFlag = quiet;
    }

    public void setExpandWebArchiveTypes(String[] expandWebArchiveTypes) {
        this.expandWebArchiveTypes = expandWebArchiveTypes;
    }

    public void setExpandAllArchives(boolean expandAllArchives) {
        this.expandAllArchives = expandAllArchives;
    }

    public void setExpandArchiveTypes(String[] expandArchiveTypes) {
        this.expandArchiveTypes = expandArchiveTypes;
    }
}

