/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util.file;

import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.util.file.NormalizedFileName;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameNormalizer {
    private String configFileName = "/config/fileNameNormalizer.properties";
    private String charConversionMapFileName = "/config/charConversionMap.properties";
    private String prefix = "";
    private String suffix = "";
    private int maxLength = -1;
    private String fileNameRegex = "[a-zA-Z0-9.\\-\\/+=@_ ]*$";
    private Map<String, String> charConversionMap = new HashMap<String, String>();

    public FileNameNormalizer(String configDir) {
        if (configDir != null && !configDir.trim().isEmpty()) {
            this.configFileName = configDir + File.separator + "fileNameNormalizer.properties";
            this.charConversionMapFileName = configDir + File.separator + "charConversionMap.properties";
        }
        this.initialize();
    }

    FileNameNormalizer(String configFileName, String charConversionMapFileName) {
        this.configFileName = configFileName;
        this.charConversionMapFileName = charConversionMapFileName;
        this.initialize();
    }

    boolean isFileNameNormalizerConfigured() {
        boolean isFileNameNormalizerConfigured;
        boolean bl = isFileNameNormalizerConfigured = !this.getPrefix().isEmpty() || !this.getSuffix().isEmpty() || this.getMaxLength() > 0 || this.getCharConversionMap().size() > 0;
        if (!isFileNameNormalizerConfigured) {
            Logger.warn((Object)"FileNameNormalizer is not configured, please provide configuration in fileNameNormalizer.properties and charConversionMap.properties");
        }
        return isFileNameNormalizerConfigured;
    }

    private void initialize() {
        this.initializeFieldsFromPropertyFile();
        this.initializeCharConversionMap();
    }

    private void initializeFieldsFromPropertyFile() {
        String fileNameRegexString;
        String maxLengthString;
        Properties properties = this.getProperties(this.configFileName);
        if (properties.getProperty("prefix") != null) {
            this.prefix = properties.getProperty("prefix");
            Logger.info((Object)("    FileNameNormalizer prefix: " + this.prefix));
        }
        if (properties.getProperty("suffix") != null) {
            this.suffix = properties.getProperty("suffix");
            Logger.info((Object)("    FileNameNormalizer suffix: " + this.suffix));
        }
        if ((maxLengthString = properties.getProperty("maxLength")) != null && !maxLengthString.isEmpty()) {
            this.maxLength = Long.valueOf(maxLengthString).intValue();
            Logger.info((Object)("    FileNameNormalizer maxlength: " + this.prefix));
        }
        if ((fileNameRegexString = properties.getProperty("fileNameRegex")) != null && !fileNameRegexString.isEmpty()) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(fileNameRegexString);
            }
            catch (Exception e) {
                Logger.error((Object)("initializeFieldsFromPropertyFile - the provided FILE_NAME_REGEX is not valid: " + fileNameRegexString));
            }
            if (pattern != null) {
                this.fileNameRegex = fileNameRegexString;
                Logger.info((Object)("    FileNameNormalizer regex: " + this.fileNameRegex));
            }
        }
    }

    private void initializeCharConversionMap() {
        Properties properties = this.getProperties(this.charConversionMapFileName);
        Logger.info((Object)("    CharConversionMap from: " + this.charConversionMapFileName));
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            this.charConversionMap.put(string, value);
            Logger.debug((Object)("    from: " + string + ", to: " + value));
        }
    }

    private Properties getProperties(String configFileName) {
        Properties properties = new Properties();
        try (InputStream in = ResourceUtil.getFileOrResourceInputStream((String)configFileName);){
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            Logger.error((Object)("cannot read property file: " + configFileName), (Throwable)e);
        }
        return properties;
    }

    String getPrefix() {
        return this.prefix;
    }

    void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    String getSuffix() {
        return this.suffix;
    }

    void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getFileNameRegex() {
        return this.fileNameRegex;
    }

    public void setFileNameRegex(String fileNameRegex) {
        this.fileNameRegex = fileNameRegex;
    }

    Map<String, String> getCharConversionMap() {
        return this.charConversionMap;
    }

    void setCharConversionMap(Map<String, String> charConversionMap) {
        this.charConversionMap = charConversionMap;
    }

    <K, V> Map<List<NodeAbstract>, List<NodeAbstract>> normalizeAllFileAndFolderNames(Document metsDocument) {
        StructureMap structureMap = metsDocument.getStructureMap();
        NodeAbstract nodeAbstract = structureMap.getRoot();
        return this.normalizeFilesAndFolderNamesAndRename(nodeAbstract);
    }

    public <K, V> Map<List<NodeAbstract>, List<NodeAbstract>> normalizeFilesAndFolderNamesAndRename(NodeAbstract nodeAbstract) {
        ArrayList<NodeAbstract> renamedNodes = new ArrayList<NodeAbstract>();
        if (!this.isFileNameNormalizerConfigured()) {
            return Collections.singletonMap(new ArrayList(), new ArrayList());
        }
        ArrayList<NodeAbstract> notRenamed = new ArrayList<NodeAbstract>();
        Map<NodeAbstract, NormalizedFileName> nodesToNormalizedFileNameMap = this.normalizeFileAndFolderNames(nodeAbstract);
        for (NodeAbstract node : nodesToNormalizedFileNameMap.keySet()) {
            NormalizedFileName normalizedFileName = nodesToNormalizedFileNameMap.get(node);
            if (this.isFileNameNormalizedAndAllowed(normalizedFileName)) {
                try {
                    Logger.debug((Object)("normalizeFilesAndFolderNamesAndRename - rename from: " + normalizedFileName.getOriginal() + " to " + normalizedFileName.getNormalized()));
                    node.rename(normalizedFileName.getNormalized());
                    renamedNodes.add(node);
                }
                catch (FileAlreadyExistsException | FileOperationNotAllowedException | IOException e) {
                    Logger.error((Object)("normalizeFilesAndFolderNamesAndRename - failed to rename node: " + node.getLabel()), (Throwable)e);
                }
                continue;
            }
            if (normalizedFileName.isFileNameNormalized()) {
                Logger.info((Object)("normalizeFilesAndFolderNamesAndRename - cannot rename node: " + node.getLabel()));
                notRenamed.add(node);
                continue;
            }
            Logger.debug((Object)("normalizeFilesAndFolderNamesAndRename - this is already normalized: " + node.getLabel()));
        }
        return Collections.singletonMap(renamedNodes, notRenamed);
    }

    public <K, V> Map<List<NodeAbstract>, List<NodeAbstract>> normalizeFilesAndFolderNamesAndRename(List<NodeAbstract> selectedNodes) {
        ArrayList renamedNodes = new ArrayList();
        ArrayList notRenamed = new ArrayList();
        for (NodeAbstract node : selectedNodes) {
            Map<List<NodeAbstract>, List<NodeAbstract>> partialResultMap = this.normalizeFilesAndFolderNamesAndRename(node);
            renamedNodes.addAll(partialResultMap.keySet().iterator().next());
            notRenamed.addAll(partialResultMap.values().iterator().next());
        }
        return Collections.singletonMap(renamedNodes, notRenamed);
    }

    Map<NodeAbstract, NormalizedFileName> normalizeFileAndFolderNames(NodeAbstract nodeAbstract) {
        HashMap<NodeAbstract, NormalizedFileName> nodesToNormalizedFileNameMap = new HashMap<NodeAbstract, NormalizedFileName>();
        try {
            HashMap<NodeAbstract, String> nodesToUniqueFileNamesMap = new HashMap<NodeAbstract, String>();
            List<NodeAbstract> nodeWithDescendants = nodeAbstract.getWithDescendants();
            for (NodeAbstract node : nodeWithDescendants) {
                NormalizedFileName normalizedFileName = this.normalizeNameAndAddUniqueId(node, nodesToUniqueFileNamesMap);
                nodesToNormalizedFileNameMap.put(node, normalizedFileName);
            }
        }
        catch (Exception e) {
            Logger.error((Object)"normalizeFileAndFolderNames failed: ", (Throwable)e);
        }
        return nodesToNormalizedFileNameMap;
    }

    boolean isFileNameNormalizedAndAllowed(NormalizedFileName normalizedFileName) {
        boolean isFileNameNormalizedAndAllowed;
        boolean bl = isFileNameNormalizedAndAllowed = normalizedFileName.isFileNameNormalized() && this.isFileNameValid(normalizedFileName.getNormalized()) && FileUtil.isFileNameAllowed((String)normalizedFileName.getNormalized());
        if (!isFileNameNormalizedAndAllowed) {
            Logger.debug((Object)("isFileNameNormalizedAndAllowed returns false for: " + normalizedFileName.getNormalized()));
        }
        return isFileNameNormalizedAndAllowed;
    }

    NormalizedFileName normalizeNameAndAddUniqueId(NodeAbstract metsNode, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        if (metsNode == null) {
            return null;
        }
        NormalizedFileName normalizedFileName = this.createNormalizedFileName(metsNode);
        return this.normalizeName(normalizedFileName).addUniqueId(nodesToUniqueFileNamesMap);
    }

    NormalizedFileName normalizeName(NormalizedFileName normalizedFileName) {
        if (!this.isFileNameValid(normalizedFileName.getNormalized())) {
            normalizedFileName.replaceForbiddenChars(this.getCharConversionMap());
        }
        return normalizedFileName.trimToMaxLength(this.getMaxLength(), this.getPrefix(), this.getSuffix()).addPrefix(this.getPrefix()).addSuffix(this.getSuffix()).addExtension();
    }

    NormalizedFileName createNormalizedFileName(NodeAbstract metsNode) {
        return new NormalizedFileName(metsNode);
    }

    boolean isFileNameValid(String name) {
        Pattern pattern = Pattern.compile(this.fileNameRegex);
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }
}

