/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.EnumerationType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TextHandler
extends HandlerBase {
    private static final String NAME = "TEXT";
    private static final String RELEASE = "1.4";
    private static final int[] DATE = new int[]{2005, 7, 26};
    private static final String NOTE = "This is the default JHOVE output handler";
    private static final String RIGHTS = "Copyright 2003-2005 by JSTOR and the President and Fellows of Harvard College. Released under the terms of the GNU Lesser General Public License.";
    private NumberFormat _format;
    private double _sampleRate;

    public TextHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        this._format = NumberFormat.getInstance();
        this._format.setGroupingUsed(false);
        this._format.setMinimumFractionDigits(0);
    }

    public void show() {
        String string = TextHandler.getIndent((int)(++this._level));
        --this._level;
    }

    public void show(App app) {
        Module module;
        String string;
        String string2 = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string2 + "App:");
        this._writer.println(string2 + " API: " + this._je.getRelease() + ", " + HandlerBase.date.format(this._je.getDate()));
        String string3 = this._je.getConfigFile();
        if (string3 != null) {
            this._writer.println(string2 + " Configuration: " + string3);
        }
        if ((string = this._je.getSaxClass()) != null) {
            this._writer.println(string2 + " SAXparser: " + string);
        }
        if ((string = this._je.getJhoveHome()) != null) {
            this._writer.println(string2 + " JhoveHome: " + string);
        }
        if ((string = this._je.getEncoding()) != null) {
            this._writer.println(string2 + " Encoding: " + string);
        }
        if ((string = this._je.getTempDirectory()) != null) {
            this._writer.println(string2 + " TempDirectory: " + string);
        }
        this._writer.println(string2 + " BufferSize: " + this._je.getBufferSize());
        Iterator iterator = this._je.getModuleMap().keySet().iterator();
        while (iterator.hasNext()) {
            module = this._je.getModule((String)iterator.next());
            this._writer.println(string2 + " Module: " + module.getName() + " " + module.getRelease());
        }
        iterator = this._je.getHandlerMap().keySet().iterator();
        while (iterator.hasNext()) {
            module = this._je.getHandler((String)iterator.next());
            this._writer.println(string2 + " OutputHandler: " + module.getName() + " " + module.getRelease());
        }
        this._writer.println(string2 + " Usage: " + app.getUsage());
        this._writer.println(string2 + " Rights: " + app.getRights());
        --this._level;
    }

    public void show(OutputHandler outputHandler) {
        String string;
        String string2 = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string2 + "Handler: " + outputHandler.getName());
        this._writer.println(string2 + " Release: " + outputHandler.getRelease());
        this._writer.println(string2 + " Date: " + HandlerBase.date.format(outputHandler.getDate()));
        List list = outputHandler.getSpecification();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.showDocument((Document)list.get(i), "Specification");
        }
        Agent agent = outputHandler.getVendor();
        if (agent != null) {
            this.showAgent(agent, "Vendor");
        }
        if ((string = outputHandler.getNote()) != null) {
            this._writer.println(string2 + " Note: " + string);
        }
        if ((string = outputHandler.getRights()) != null) {
            this._writer.println(string2 + " Rights: " + string);
        }
    }

    public void show(Module module) {
        Agent agent;
        int n;
        String string;
        String string2 = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string2 + "Module: " + module.getName());
        this._writer.println(string2 + " Release: " + module.getRelease());
        this._writer.println(string2 + " Date: " + HandlerBase.date.format(module.getDate()));
        String[] stringArray = module.getFormat();
        if (stringArray.length > 0) {
            this._writer.print(string2 + " Format: " + stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this._writer.print(", " + stringArray[i]);
            }
            this._writer.println();
        }
        if ((string = module.getCoverage()) != null) {
            this._writer.println(string2 + " Coverage: " + string);
        }
        if ((stringArray = module.getMimeType()).length > 0) {
            this._writer.print(string2 + " MIMEtype: " + stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this._writer.print(", " + stringArray[i]);
            }
            this._writer.println();
        }
        List list = module.getSignature();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showSignature((Signature)list.get(n));
        }
        list = module.getSpecification();
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showDocument((Document)list.get(n), "Specification");
        }
        List list2 = module.getFeatures();
        if (list2 != null) {
            agent = list2.iterator();
            while (agent.hasNext()) {
                string = (String)agent.next();
                this._writer.println(string2 + "  Feature: " + string);
            }
        }
        this._writer.println(string2 + " Methodology:");
        string = module.getWellFormedNote();
        if (string != null) {
            this._writer.println(string2 + "  Well-formed: " + string);
        }
        if ((string = module.getValidityNote()) != null) {
            this._writer.println(string2 + "  Validity: " + string);
        }
        if ((string = module.getRepInfoNote()) != null) {
            this._writer.println(string2 + "  RepresentationInformation: " + string);
        }
        if ((agent = module.getVendor()) != null) {
            this.showAgent(agent, "Vendor");
        }
        if ((string = module.getNote()) != null) {
            this._writer.println(string2 + " Note: " + string);
        }
        if ((string = module.getRights()) != null) {
            this._writer.println(string2 + " Rights: " + string);
        }
        --this._level;
    }

    public void show(RepInfo repInfo) {
        Map map;
        int n;
        String string;
        long l;
        Date date;
        String string2 = TextHandler.getIndent((int)(++this._level));
        Module module = repInfo.getModule();
        this._writer.println(string2 + "RepresentationInformation: " + repInfo.getUri());
        if (module != null) {
            this._writer.println(string2 + " ReportingModule: " + module.getName() + ", Rel. " + module.getRelease() + " (" + TextHandler.date.format(module.getDate()) + ")");
        }
        if ((date = repInfo.getCreated()) != null) {
            this._writer.println(string2 + " Created: " + dateTime.format(date));
        }
        if ((date = repInfo.getLastModified()) != null) {
            this._writer.println(string2 + " LastModified: " + dateTime.format(date));
        }
        if ((l = repInfo.getSize()) > -1L) {
            this._writer.println(string2 + " Size: " + l);
        }
        if ((string = repInfo.getFormat()) != null) {
            this._writer.println(string2 + " Format: " + string);
        }
        if ((string = repInfo.getVersion()) != null) {
            this._writer.println(string2 + " Version: " + string);
        }
        if (!this._je.getSignatureFlag()) {
            this._writer.print(string2 + " Status: ");
            switch (repInfo.getWellFormed()) {
                case 1: {
                    string = "Well-Formed";
                    break;
                }
                case 0: {
                    string = "Not well-formed";
                    break;
                }
                default: {
                    string = "Unknown";
                }
            }
            if (repInfo.getWellFormed() == 1) {
                switch (repInfo.getValid()) {
                    case 1: {
                        string = string + " and valid";
                        break;
                    }
                    case 0: {
                        string = string + ", but not valid";
                    }
                }
            }
            this._writer.println(string);
        } else {
            this._writer.print(string2 + " Status: ");
            switch (repInfo.getWellFormed()) {
                case 1: {
                    string = "Well-Formed";
                    break;
                }
                default: {
                    string = "Not well-formed";
                }
            }
            this._writer.println(string);
        }
        List list = repInfo.getSigMatch();
        int n2 = list.size();
        if (n2 > 0) {
            this._writer.println(string2 + " SignatureMatches:");
            for (n = 0; n < n2; ++n) {
                this._writer.println(string2 + "  " + (String)list.get(n));
            }
        }
        list = repInfo.getMessage();
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showMessage((Message)list.get(n));
        }
        string = repInfo.getMimeType();
        if (string != null) {
            this._writer.println(string2 + " MIMEtype: " + string);
        }
        if ((n2 = (list = repInfo.getProfile()).size()) > 0) {
            this._writer.print(string2 + " Profile: " + (String)list.get(0));
            for (n = 1; n < n2; ++n) {
                this._writer.print(", " + (String)list.get(n));
            }
            this._writer.println();
        }
        if ((map = repInfo.getProperty()) != null) {
            for (String string3 : map.keySet()) {
                this.showProperty(repInfo.getProperty(string3), string3, string2);
            }
        }
        list = repInfo.getChecksum();
        n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            this.showChecksum((Checksum)list.get(i));
        }
        --this._level;
    }

    private void showAgent(Agent agent, String string) {
        String string2 = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string2 + string + ": " + agent.getName());
        this._writer.println(string2 + " Type: " + agent.getType().toString());
        String string3 = agent.getAddress();
        if (string3 != null) {
            this._writer.println(string2 + " Address: " + string3);
        }
        if ((string3 = agent.getTelephone()) != null) {
            this._writer.println(string2 + " Telephone: " + string3);
        }
        if ((string3 = agent.getFax()) != null) {
            this._writer.println(string2 + " Fax: " + string3);
        }
        if ((string3 = agent.getEmail()) != null) {
            this._writer.println(string2 + " Email: " + string3);
        }
        if ((string3 = agent.getWeb()) != null) {
            this._writer.println(string2 + " Web: " + string3);
        }
        --this._level;
    }

    private void showChecksum(Checksum checksum) {
        String string = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string + "Checksum: " + checksum.getValue());
        this._writer.println(string + " Type: " + checksum.getType().toString());
        --this._level;
    }

    private void showDocument(Document document, String string) {
        int n;
        String string2 = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string2 + string + ": " + document.getTitle());
        this._writer.println(string2 + " Type: " + document.getType());
        List list = document.getAuthor();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showAgent((Agent)list.get(n), "Author");
        }
        list = document.getPublisher();
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showAgent((Agent)list.get(n), "Publisher");
        }
        String string3 = document.getEdition();
        if (string3 != null) {
            this._writer.println(string2 + " Edition: " + string3);
        }
        if ((string3 = document.getDate()) != null) {
            this._writer.println(string2 + " Date: " + string3);
        }
        if ((string3 = document.getEnumeration()) != null) {
            this._writer.println(string2 + " Enumeration: " + string3);
        }
        if ((string3 = document.getPages()) != null) {
            this._writer.println(string2 + " Pages: " + string3);
        }
        list = document.getIdentifier();
        n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            this.showIdentifier((Identifier)list.get(i));
        }
        string3 = document.getNote();
        if (string3 != null) {
            this._writer.println(string2 + " Note: " + string3);
        }
        --this._level;
    }

    public void showFooter() {
        --this._level;
        this._writer.flush();
    }

    public void showHeader() {
        String string = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string + this._app.getName() + " (Rel. " + this._app.getRelease() + ", " + HandlerBase.date.format(this._app.getDate()) + ")");
        this._writer.println(string + " Date: " + HandlerBase.dateTime.format(new Date()));
    }

    private void showIdentifier(Identifier identifier) {
        String string = TextHandler.getIndent((int)(++this._level));
        this._writer.println(string + "Identifier: " + identifier.getValue());
        this._writer.println(string + " Type: " + identifier.getType().toString());
        String string2 = identifier.getNote();
        if (string2 != null) {
            this._writer.println(string + " Note: " + string2);
        }
        --this._level;
    }

    private void showMessage(Message message) {
        String string = TextHandler.getIndent((int)(++this._level));
        String string2 = message instanceof ErrorMessage ? "ErrorMessage: " : (message instanceof InfoMessage ? "InfoMessage: " : "Message: ");
        String string3 = message.getMessage();
        String string4 = message.getSubMessage();
        if (string4 != null) {
            string3 = string3 + ": " + string4;
        }
        this._writer.println(string + string2 + string3);
        long l = message.getOffset();
        if (l > -1L) {
            this._writer.println(string + " Offset: " + l);
        }
        --this._level;
    }

    private void showSignature(Signature signature) {
        String string;
        String string2;
        String string3 = TextHandler.getIndent((int)(++this._level));
        String string4 = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this._writer.println(string3 + signature.getType().toString() + ": " + string4);
        if (signature.getType().equals((EnumerationType)SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this._writer.println(string3 + " Offset: " + ((InternalSignature)signature).getOffset());
        }
        if ((string2 = signature.getNote()) != null) {
            this._writer.println(string3 + " Note: " + string2);
        }
        if ((string = signature.getUse().toString()) != null) {
            this._writer.println(string3 + " Use: " + string);
        }
        --this._level;
    }

    private void showProperty(Property property, String string, String string2) {
        PropertyArity propertyArity = property.getArity();
        if (string == null) {
            this._writer.print(string2 + "  ");
        } else {
            this._writer.print(string2 + " " + string + ": ");
        }
        if (propertyArity.equals((EnumerationType)PropertyArity.SCALAR)) {
            this.showScalarProperty(property, string2);
        } else if (propertyArity.equals((EnumerationType)PropertyArity.LIST)) {
            this.showListProperty(property, string2);
        } else if (propertyArity.equals((EnumerationType)PropertyArity.MAP)) {
            this.showMapProperty(property, string2);
        } else if (propertyArity.equals((EnumerationType)PropertyArity.SET)) {
            this.showSetProperty(property, string2);
        } else if (propertyArity.equals((EnumerationType)PropertyArity.ARRAY)) {
            this.showArrayProperty(property, string2);
        } else {
            this._writer.println();
        }
    }

    private void showScalarProperty(Property property, String string) {
        PropertyType propertyType = property.getType();
        if (PropertyType.PROPERTY.equals((EnumerationType)propertyType)) {
            this._writer.println();
            Property property2 = (Property)property.getValue();
            this.showProperty(property2, property2.getName(), string + " ");
        } else if (PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType)) {
            this.showNisoImageMetadata((NisoImageMetadata)property.getValue(), string + " ", this._je.getShowRawFlag());
        } else if (PropertyType.AESAUDIOMETADATA.equals((EnumerationType)propertyType)) {
            this.showAESAudioMetadata((AESAudioMetadata)property.getValue(), string + " ", this._je.getShowRawFlag());
        } else {
            this._writer.println(property.getValue().toString());
        }
    }

    private void showListProperty(Property property, String string) {
        boolean bl = PropertyType.PROPERTY.equals((EnumerationType)property.getType());
        boolean bl2 = PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)property.getType());
        List list = (List)property.getValue();
        int n = list.size();
        if (n > 0) {
            if (bl) {
                this._writer.println();
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                if (bl) {
                    object = (Property)list.get(i);
                    this.showProperty((Property)object, object.getName(), string + " ");
                    continue;
                }
                if (bl2) {
                    this.showNisoImageMetadata((NisoImageMetadata)list.get(i), string + " ", this._je.getShowRawFlag());
                    continue;
                }
                object = list.get(i);
                if (i == 0) {
                    this._writer.print(object);
                    continue;
                }
                this._writer.print(", " + object);
            }
        }
        if (!bl || n == 0) {
            this._writer.println();
        }
    }

    private void showMapProperty(Property property, String string) {
        boolean bl = PropertyType.PROPERTY.equals((EnumerationType)property.getType());
        boolean bl2 = PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)property.getType());
        Map map = (Map)property.getValue();
        Set set = map.keySet();
        for (Object k : set) {
            Object v = map.get(k);
            if (bl) {
                Property property2 = (Property)v;
                this.showProperty(property2, property2.getName(), string + " ");
                String string2 = k.toString();
                if (property2.getName().equals(string2)) continue;
                this._writer.println("    Key: " + string2);
                continue;
            }
            if (bl2) {
                this.showNisoImageMetadata((NisoImageMetadata)v, string + " ", this._je.getShowRawFlag());
                continue;
            }
            this._writer.println("   " + v.toString());
            this._writer.println("     Key: " + k.toString());
        }
    }

    private void showSetProperty(Property property, String string) {
        boolean bl = PropertyType.PROPERTY.equals((EnumerationType)property.getType());
        boolean bl2 = PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)property.getType());
        Set set = (Set)property.getValue();
        Iterator iterator = set.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl) {
                Property property2 = (Property)e;
                this.showProperty(property2, property2.getName(), string + " ");
                continue;
            }
            if (bl2) {
                this.showNisoImageMetadata((NisoImageMetadata)e, string + " ", this._je.getShowRawFlag());
                continue;
            }
            if (bl3) {
                this._writer.print(e.toString());
                bl3 = false;
                continue;
            }
            this._writer.print(", " + e.toString());
        }
        this._writer.println();
    }

    private void showArrayProperty(Property property, String string) {
        boolean[] blArray = null;
        byte[] byArray = null;
        char[] cArray = null;
        Date[] dateArray = null;
        double[] dArray = null;
        float[] fArray = null;
        int[] nArray = null;
        long[] lArray = null;
        Object[] objectArray = null;
        Property[] propertyArray = null;
        short[] sArray = null;
        String[] stringArray = null;
        Rational[] rationalArray = null;
        NisoImageMetadata[] nisoImageMetadataArray = null;
        int n = 0;
        PropertyType propertyType = property.getType();
        if (PropertyType.BOOLEAN.equals((EnumerationType)propertyType)) {
            blArray = (boolean[])property.getValue();
            n = blArray.length;
        } else if (PropertyType.BYTE.equals((EnumerationType)propertyType)) {
            byArray = (byte[])property.getValue();
            n = byArray.length;
        } else if (PropertyType.CHARACTER.equals((EnumerationType)propertyType)) {
            cArray = (char[])property.getValue();
            n = cArray.length;
        } else if (PropertyType.DATE.equals((EnumerationType)propertyType)) {
            dateArray = (Date[])property.getValue();
            n = dateArray.length;
        } else if (PropertyType.DOUBLE.equals((EnumerationType)propertyType)) {
            dArray = (double[])property.getValue();
            n = dArray.length;
        } else if (PropertyType.FLOAT.equals((EnumerationType)propertyType)) {
            fArray = (float[])property.getValue();
            n = fArray.length;
        } else if (PropertyType.INTEGER.equals((EnumerationType)propertyType)) {
            nArray = (int[])property.getValue();
            n = nArray.length;
        } else if (PropertyType.LONG.equals((EnumerationType)propertyType)) {
            lArray = (long[])property.getValue();
            n = lArray.length;
        } else if (PropertyType.OBJECT.equals((EnumerationType)propertyType)) {
            objectArray = (Object[])property.getValue();
            n = objectArray.length;
        } else if (PropertyType.SHORT.equals((EnumerationType)propertyType)) {
            sArray = (short[])property.getValue();
            n = sArray.length;
        } else if (PropertyType.STRING.equals((EnumerationType)propertyType)) {
            stringArray = (String[])property.getValue();
            n = stringArray.length;
        } else if (PropertyType.RATIONAL.equals((EnumerationType)propertyType)) {
            rationalArray = (Rational[])property.getValue();
            n = rationalArray.length;
        } else if (PropertyType.PROPERTY.equals((EnumerationType)propertyType)) {
            propertyArray = (Property[])property.getValue();
            n = propertyArray.length;
        } else if (PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType)) {
            nisoImageMetadataArray = (NisoImageMetadata[])property.getValue();
            n = nisoImageMetadataArray.length;
        }
        for (int i = 0; i < n; ++i) {
            String string2;
            if (PropertyType.BOOLEAN.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(blArray[i]);
            } else if (PropertyType.BYTE.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(byArray[i]);
            } else if (PropertyType.CHARACTER.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(cArray[i]);
            } else if (PropertyType.DATE.equals((EnumerationType)propertyType)) {
                string2 = dateArray[i].toString();
            } else if (PropertyType.DOUBLE.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(dArray[i]);
            } else if (PropertyType.FLOAT.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(fArray[i]);
            } else if (PropertyType.INTEGER.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(nArray[i]);
            } else if (PropertyType.LONG.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(lArray[i]);
            } else if (PropertyType.OBJECT.equals((EnumerationType)propertyType)) {
                string2 = objectArray[i].toString();
            } else if (PropertyType.SHORT.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(sArray[i]);
            } else if (PropertyType.STRING.equals((EnumerationType)propertyType)) {
                string2 = stringArray[i];
            } else if (PropertyType.RATIONAL.equals((EnumerationType)propertyType)) {
                string2 = rationalArray[i].toString();
            } else {
                NisoImageMetadata nisoImageMetadata;
                if (PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType)) {
                    if (i == 0) {
                        this._writer.println();
                    }
                    nisoImageMetadata = nisoImageMetadataArray[i];
                    this.showNisoImageMetadata(nisoImageMetadata, string + " ", this._je.getShowRawFlag());
                    continue;
                }
                if (PropertyType.PROPERTY.equals((EnumerationType)propertyType)) {
                    if (i == 0) {
                        this._writer.println();
                    }
                    nisoImageMetadata = propertyArray[i];
                    this.showProperty((Property)nisoImageMetadata, nisoImageMetadata.getName(), string + " ");
                    continue;
                }
                string2 = "<error>";
            }
            if (i == 0) {
                this._writer.print(string2);
                continue;
            }
            this._writer.print(", " + string2);
        }
        if (propertyType != PropertyType.PROPERTY && propertyType != PropertyType.NISOIMAGEMETADATA) {
            this._writer.println();
        }
    }

    private void showAESAudioMetadata(AESAudioMetadata aESAudioMetadata, String string, boolean bl) {
        int n;
        AESAudioMetadata.FormatRegion formatRegion;
        List list;
        Object object;
        String[] stringArray;
        long l;
        int n2;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        this._sampleRate = aESAudioMetadata.getSampleRate();
        this._writer.println();
        String string6 = aESAudioMetadata.getAnalogDigitalFlag();
        if (string6 != null) {
            this._writer.println(string2 + "AnalogDigitalFlag: " + string6);
        }
        if ((string6 = aESAudioMetadata.getSchemaVersion()) != null) {
            this._writer.println(string2 + "SchemaVersion: " + string6);
        }
        if ((string6 = aESAudioMetadata.getFormat()) != null) {
            this._writer.println(string2 + "Format: " + string6);
        }
        if ((string6 = aESAudioMetadata.getSpecificationVersion()) != null) {
            this._writer.println(string2 + "SpecificationVersion: " + string6);
        }
        if ((string6 = aESAudioMetadata.getAppSpecificData()) != null) {
            this._writer.println(string2 + "AppSpecificData: " + string6);
        }
        if ((string6 = aESAudioMetadata.getAudioDataEncoding()) != null) {
            this._writer.println(string2 + "AudioDataEncoding: " + string6);
        }
        if ((n2 = aESAudioMetadata.getByteOrder()) != -1) {
            this._writer.println(string2 + "ByteOrder: " + (n2 == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN"));
        }
        if ((l = aESAudioMetadata.getFirstSampleOffset()) != -1L) {
            this._writer.println(string2 + "FirstSampleOffset: " + Long.toString(l));
        }
        if ((stringArray = aESAudioMetadata.getUse()) != null) {
            this._writer.println(string2 + "Use:");
            this._writer.println(string3 + "UseType: " + stringArray[0]);
            this._writer.println(string3 + "OtherType: " + stringArray[1]);
        }
        if ((string6 = aESAudioMetadata.getPrimaryIdentifier()) != null) {
            object = aESAudioMetadata.getPrimaryIdentifierType();
            this._writer.println(string2 + "PrimaryIdentifier: " + string6);
            if (object != null) {
                this._writer.println(string3 + "IdentifierType: " + (String)object);
            }
        }
        if (!(object = aESAudioMetadata.getFaceList()).isEmpty()) {
            list = (AESAudioMetadata.Face)object.get(0);
            this._writer.println(string2 + "Face: ");
            this._writer.println(string3 + "TimeLine: ");
            formatRegion = list.getStartTime();
            if (formatRegion != null) {
                this.writeAESTimeRange(string3, (AESAudioMetadata.TimeDesc)formatRegion, list.getDuration());
            }
            if ((n = aESAudioMetadata.getNumChannels()) != -1) {
                this._writer.println(string4 + "NumChannels: " + Integer.toString(n));
            }
            String[] stringArray2 = aESAudioMetadata.getMapLocations();
            for (int i = 0; i < n; ++i) {
                this._writer.println(string4 + "Stream:");
                this._writer.println(string5 + "ChannelNum: " + Integer.toString(i));
                this._writer.println(string5 + "ChannelAssignment: " + stringArray2[i]);
            }
        }
        if (!(list = aESAudioMetadata.getFormatList()).isEmpty()) {
            formatRegion = (AESAudioMetadata.FormatRegion)list.get(0);
            n = formatRegion.getBitDepth();
            double d = formatRegion.getSampleRate();
            int n3 = formatRegion.getWordSize();
            String[] stringArray3 = formatRegion.getBitrateReduction();
            if (n != -1 || d != -1.0 || n3 != -1) {
                this._writer.println(string2 + "FormatList:");
                this._writer.println(string3 + "FormatRegion:");
                if (n != -1) {
                    this._writer.println(string4 + "BitDepth: " + Integer.toString(n));
                }
                if (d != -1.0) {
                    this._writer.println(string4 + "SampleRate: " + Double.toString(d));
                }
                if (n3 != -1) {
                    this._writer.println(string4 + "WordSize: " + Integer.toString(n3));
                }
                if (stringArray3 != null) {
                    this._writer.println(string4 + "BitrateReduction");
                    this._writer.println(string5 + "CodecName: " + stringArray3[0]);
                    this._writer.println(string5 + "codecNameVersion: " + stringArray3[1]);
                    this._writer.println(string5 + "codecCreatorApplication: " + stringArray3[2]);
                    this._writer.println(string5 + "codecCreatorApplicationVersion: " + stringArray3[3]);
                    this._writer.println(string5 + "codecQuality: " + stringArray3[4]);
                    this._writer.println(string5 + "dataRate: " + stringArray3[5]);
                    this._writer.println(string5 + "dataRateMode: " + stringArray3[6]);
                }
            }
        }
    }

    private void writeAESTimeRange(String string, AESAudioMetadata.TimeDesc timeDesc, AESAudioMetadata.TimeDesc timeDesc2) {
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        this._writer.println(string2 + "StartTime:");
        this._writer.println(string3 + "FrameCount: 30");
        this._writer.println(string3 + "TimeBase: 1000");
        this._writer.println(string3 + "VideoField: FIELD_1");
        this._writer.println(string3 + "CountingMode: NTSC_NON_DROP_FRAME");
        this._writer.println(string3 + "Hours: " + Integer.toString(timeDesc.getHours()));
        this._writer.println(string3 + "Minutes: " + Integer.toString(timeDesc.getMinutes()));
        this._writer.println(string3 + "Seconds: " + Integer.toString(timeDesc.getSeconds()));
        this._writer.println(string3 + "Frames: " + Integer.toString(timeDesc.getFrames()));
        this._writer.println(string3 + "Samples: ");
        double d = timeDesc.getSampleRate();
        if (d == 1.0) {
            d = this._sampleRate;
        }
        this._writer.println(string4 + "SampleRate: S" + Integer.toString((int)d));
        this._writer.println(string4 + "NumberOfSamples: " + Integer.toString(timeDesc.getSamples()));
        this._writer.println(string3 + "FilmFraming: NOT_APPLICABLE");
        this._writer.println(string4 + "Type: ntscFilmFramingType");
        if (timeDesc2 != null) {
            this._writer.println(string2 + "Duration:");
            this._writer.println(string3 + "FrameCount: 30");
            this._writer.println(string3 + "TimeBase: 1000");
            this._writer.println(string3 + "VideoField: FIELD_1");
            this._writer.println(string3 + "CountingMode: NTSC_NON_DROP_FRAME");
            this._writer.println(string3 + "Hours: " + Integer.toString(timeDesc2.getHours()));
            this._writer.println(string3 + "Minutes: " + Integer.toString(timeDesc2.getMinutes()));
            this._writer.println(string3 + "Seconds: " + Integer.toString(timeDesc2.getSeconds()));
            this._writer.println(string3 + "Frames: " + Integer.toString(timeDesc2.getFrames()));
            this._writer.println(string3 + "Samples: ");
            d = timeDesc2.getSampleRate();
            if (d == 1.0) {
                d = this._sampleRate;
            }
            this._writer.println(string4 + "SampleRate: S" + Integer.toString((int)d));
            this._writer.println(string4 + "NumberOfSamples: " + Integer.toString(timeDesc2.getSamples()));
            this._writer.println(string3 + "FilmFraming: NOT_APPLICABLE");
            this._writer.println(string4 + "Type: ntscFilmFramingType");
        }
    }

    protected void showNisoImageMetadata(NisoImageMetadata nisoImageMetadata, String string, boolean bl) {
        if ("0.2".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata02(nisoImageMetadata, string, bl);
        } else {
            this.showNisoImageMetadata10(nisoImageMetadata, string, bl);
        }
    }

    private void showNisoImageMetadata02(NisoImageMetadata nisoImageMetadata, String string, boolean bl) {
        String[] stringArray;
        int n;
        Rational rational;
        double[] dArray;
        double d;
        int n2;
        long l;
        long[] lArray;
        int n3;
        Rational[] rationalArray;
        int[] nArray;
        int n4;
        String string2 = string + " ";
        this._writer.println();
        String string3 = nisoImageMetadata.getMimeType();
        if (string3 != null) {
            this._writer.println(string2 + "MIMEType: " + string3);
        }
        if ((string3 = nisoImageMetadata.getByteOrder()) != null) {
            this._writer.println(string2 + "ByteOrder: " + string3);
        }
        if ((n4 = nisoImageMetadata.getCompressionScheme()) != -1) {
            this._writer.println(string2 + "CompressionScheme: " + this.addIntegerValue(n4, NisoImageMetadata.COMPRESSION_SCHEME, NisoImageMetadata.COMPRESSION_SCHEME_INDEX, bl));
        }
        if ((n4 = nisoImageMetadata.getCompressionLevel()) != -1) {
            this._writer.println(string2 + "CompressionLevel: " + n4);
        }
        if ((n4 = nisoImageMetadata.getColorSpace()) != -1) {
            this._writer.println(string2 + "ColorSpace: " + this.addIntegerValue(n4, NisoImageMetadata.COLORSPACE, NisoImageMetadata.COLORSPACE_INDEX, bl));
        }
        if ((string3 = nisoImageMetadata.getProfileName()) != null) {
            this._writer.println(string2 + "ProfileName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProfileURL()) != null) {
            this._writer.println(string2 + "ProfileURL: " + string3);
        }
        if ((nArray = nisoImageMetadata.getYCbCrSubSampling()) != null) {
            this._writer.print(string2 + "YCbCrSubSampling: " + nArray[0]);
            for (int i = 1; i < nArray.length; ++i) {
                this._writer.print(", " + nArray[i]);
            }
            this._writer.println();
        }
        if ((n4 = nisoImageMetadata.getYCbCrPositioning()) != -1) {
            this._writer.println(string2 + "YCbCrPositioning: " + this.addIntegerValue(n4, NisoImageMetadata.YCBCR_POSITIONING, bl));
        }
        if ((rationalArray = nisoImageMetadata.getYCbCrCoefficients()) != null) {
            this._writer.print(string2 + "YCbCrCoefficients: " + this.addRationalValue(rationalArray[0], bl));
            for (n3 = 1; n3 < rationalArray.length; ++n3) {
                this._writer.print(", " + this.addRationalValue(rationalArray[n3], bl));
            }
            this._writer.println();
        }
        if ((rationalArray = nisoImageMetadata.getReferenceBlackWhite()) != null) {
            this._writer.print(string2 + "ReferenceBlackWhite: " + this.addRationalValue(rationalArray[0], bl));
            for (n3 = 1; n3 < rationalArray.length; ++n3) {
                this._writer.print(", " + this.addRationalValue(rationalArray[n3], bl));
            }
            this._writer.println();
        }
        if ((n4 = nisoImageMetadata.getSegmentType()) != -1) {
            this._writer.println(string2 + "SegmentType: " + this.addIntegerValue(n4, NisoImageMetadata.SEGMENT_TYPE, bl));
        }
        if ((lArray = nisoImageMetadata.getStripOffsets()) != null) {
            this._writer.print(string2 + "StripOffsets: " + lArray[0]);
            for (int i = 1; i < lArray.length; ++i) {
                this._writer.print(", " + lArray[i]);
            }
            this._writer.println();
        }
        if ((l = nisoImageMetadata.getRowsPerStrip()) != -1L) {
            this._writer.println(string2 + "RowsPerStrip: " + l);
        }
        if ((lArray = nisoImageMetadata.getStripByteCounts()) != null) {
            this._writer.print(string2 + "StripByteCounts: " + lArray[0]);
            for (n2 = 1; n2 < lArray.length; ++n2) {
                this._writer.print(", " + lArray[n2]);
            }
            this._writer.println();
        }
        if ((l = nisoImageMetadata.getTileWidth()) != -1L) {
            this._writer.println(string2 + "TileWidth: " + l);
        }
        if ((l = nisoImageMetadata.getTileLength()) != -1L) {
            this._writer.println(string2 + "TileLength: " + l);
        }
        if ((lArray = nisoImageMetadata.getTileOffsets()) != null) {
            this._writer.print(string2 + "TileOffsets: " + lArray[0]);
            for (n2 = 1; n2 < lArray.length; ++n2) {
                this._writer.print(", " + lArray[n2]);
            }
            this._writer.println();
        }
        if ((lArray = nisoImageMetadata.getTileByteCounts()) != null) {
            this._writer.print(string2 + "TileByteCounts: " + lArray[0]);
            for (n2 = 1; n2 < lArray.length; ++n2) {
                this._writer.print(", " + lArray[n2]);
            }
            this._writer.println();
        }
        if ((n4 = nisoImageMetadata.getPlanarConfiguration()) != -1) {
            this._writer.println(string2 + "PlanarConfiguration: " + this.addIntegerValue(n4, NisoImageMetadata.PLANAR_CONFIGURATION, bl));
        }
        if ((string3 = nisoImageMetadata.getImageIdentifier()) != null) {
            this._writer.println(string2 + "ImageIdentifier: " + string3);
        }
        if ((string3 = nisoImageMetadata.getImageIdentifierLocation()) != null) {
            this._writer.println(string2 + "ImageIdentifierLocation: " + string3);
        }
        if ((l = nisoImageMetadata.getFileSize()) != -1L) {
            this._writer.println(string2 + "FileSize: " + l);
        }
        if ((n4 = nisoImageMetadata.getChecksumMethod()) != -1) {
            this._writer.println(string2 + "ChecksumMethod: " + this.addIntegerValue(n4, NisoImageMetadata.CHECKSUM_METHOD, bl));
        }
        if ((string3 = nisoImageMetadata.getChecksumValue()) != null) {
            this._writer.println(string2 + "ChecksumValue: " + string3);
        }
        if ((n4 = nisoImageMetadata.getOrientation()) != -1) {
            this._writer.println(string2 + "Orientation: " + this.addIntegerValue(n4, NisoImageMetadata.ORIENTATION, bl));
        }
        if ((n4 = nisoImageMetadata.getDisplayOrientation()) != -1) {
            this._writer.println(string2 + "DisplayOrientation: " + this.addIntegerValue(n4, NisoImageMetadata.DISPLAY_ORIENTATION, bl));
        }
        if ((l = nisoImageMetadata.getXTargetedDisplayAR()) != -1L) {
            this._writer.println(string2 + "XTargetedDisplayAR: " + l);
        }
        if ((l = nisoImageMetadata.getYTargetedDisplayAR()) != -1L) {
            this._writer.println(string2 + "YTargetedDisplayAR: " + l);
        }
        if ((string3 = nisoImageMetadata.getPreferredPresentation()) != null) {
            this._writer.println(string2 + "PreferredPresentation: " + string3);
        }
        if ((string3 = nisoImageMetadata.getSourceType()) != null) {
            this._writer.println(string2 + "SourceType: " + string3);
        }
        if ((string3 = nisoImageMetadata.getImageProducer()) != null) {
            this._writer.println(string2 + "ImageProducer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getHostComputer()) != null) {
            this._writer.println(string2 + "HostComputer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getOS()) != null) {
            this._writer.println(string2 + "OperatingSystem: " + string3);
        }
        if ((string3 = nisoImageMetadata.getOSVersion()) != null) {
            this._writer.println(string2 + "OSVersion: " + string3);
        }
        if ((string3 = nisoImageMetadata.getDeviceSource()) != null) {
            this._writer.println(string2 + "DeviceSource: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerManufacturer()) != null) {
            this._writer.println(string2 + "ScannerManufacturer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerModelName()) != null) {
            this._writer.println(string2 + "ScannerModelName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerModelNumber()) != null) {
            this._writer.println(string2 + "ScannerModelNumber: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerModelSerialNo()) != null) {
            this._writer.println(string2 + "ScannerModelSerialNo: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScanningSoftware()) != null) {
            this._writer.println(string2 + "ScanningSoftware: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScanningSoftwareVersionNo()) != null) {
            this._writer.println(string2 + "ScanningSoftwareVersionNo: " + string3);
        }
        if ((d = nisoImageMetadata.getPixelSize()) != -1.0) {
            this._writer.println(string2 + "PixelSize: " + d);
        }
        if ((d = nisoImageMetadata.getXPhysScanResolution()) != -1.0) {
            this._writer.println(string2 + "XPhysScanResolution: " + d);
        }
        if ((d = nisoImageMetadata.getYPhysScanResolution()) != -1.0) {
            this._writer.println(string2 + "YPhysScanResolution: " + d);
        }
        if ((string3 = nisoImageMetadata.getDigitalCameraManufacturer()) != null) {
            this._writer.println(string2 + "DigitalCameraManufacturer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getDigitalCameraModel()) != null) {
            this._writer.println(string2 + "DigitalCameraModel: " + string3);
        }
        if ((d = nisoImageMetadata.getFNumber()) != -1.0) {
            this._writer.println(string2 + "FNumber: " + d);
        }
        if ((d = nisoImageMetadata.getExposureTime()) != -1.0) {
            this._writer.println(string2 + "ExposureTime: " + d);
        }
        if ((d = nisoImageMetadata.getBrightness()) != -1.0) {
            this._writer.println(string2 + "Brightness: " + d);
        }
        if ((d = nisoImageMetadata.getExposureBias()) != -1.0) {
            this._writer.println(string2 + "ExposureBias: " + d);
        }
        if ((dArray = nisoImageMetadata.getSubjectDistance()) != null) {
            this._writer.print(string2 + "SubjectDistance: " + dArray[0]);
            for (int i = 1; i < dArray.length; ++i) {
                this._writer.print(", " + dArray[i]);
            }
            this._writer.println();
        }
        if ((n4 = nisoImageMetadata.getMeteringMode()) != -1) {
            this._writer.println(string2 + "MeteringMode: " + this.addIntegerValue(n4, NisoImageMetadata.METERING_MODE, bl));
        }
        if ((n4 = nisoImageMetadata.getSceneIlluminant()) != -1) {
            this._writer.println(string2 + "SceneIlluminant: " + this.addIntegerValue(n4, NisoImageMetadata.METERING_MODE, bl));
        }
        if ((d = nisoImageMetadata.getColorTemp()) != -1.0) {
            this._writer.println(string2 + "ColorTemp: " + d);
        }
        if ((d = nisoImageMetadata.getFocalLength()) != -1.0) {
            this._writer.println(string2 + "FocalLength: " + d);
        }
        if ((n4 = nisoImageMetadata.getFlash()) != -1) {
            this._writer.println(string2 + "Flash: " + this.addIntegerValue(n4, NisoImageMetadata.FLASH, bl));
        }
        if ((d = nisoImageMetadata.getFlashEnergy()) != -1.0) {
            this._writer.println(string2 + "FlashEnergy: " + d);
        }
        if ((n4 = nisoImageMetadata.getFlashReturn()) != -1) {
            this._writer.println(string2 + "FlashReturn: " + this.addIntegerValue(n4, NisoImageMetadata.FLASH_RETURN, bl));
        }
        if ((n4 = nisoImageMetadata.getBackLight()) != -1) {
            this._writer.println(string2 + "BackLight: " + this.addIntegerValue(n4, NisoImageMetadata.BACKLIGHT, bl));
        }
        if ((d = nisoImageMetadata.getExposureIndex()) != -1.0) {
            this._writer.println(string2 + "ExposureIndex: " + d);
        }
        if ((n4 = nisoImageMetadata.getAutoFocus()) != -1) {
            this._writer.println(string2 + "AutoFocus: " + this.addIntegerValue(n4, NisoImageMetadata.AUTOFOCUS, bl));
        }
        if ((d = nisoImageMetadata.getXPrintAspectRatio()) != -1.0) {
            this._writer.println(string2 + "XPrintAspectRatio: " + d);
        }
        if ((d = nisoImageMetadata.getYPrintAspectRatio()) != -1.0) {
            this._writer.println(string2 + "YPrintAspectRatio: " + d);
        }
        if ((n4 = nisoImageMetadata.getSensor()) != -1) {
            this._writer.println(string2 + "Sensor: " + this.addIntegerValue(n4, NisoImageMetadata.SENSOR, bl));
        }
        if ((string3 = nisoImageMetadata.getDateTimeCreated()) != null) {
            this._writer.println(string2 + "DateTimeCreated: " + string3);
        }
        if ((string3 = nisoImageMetadata.getMethodology()) != null) {
            this._writer.println(string2 + "Methodology: " + string3);
        }
        if ((n4 = nisoImageMetadata.getSamplingFrequencyPlane()) != -1) {
            this._writer.println(string2 + "SamplingFrequencyPlane: " + this.addIntegerValue(n4, NisoImageMetadata.SAMPLING_FREQUENCY_PLANE, bl));
        }
        if ((n4 = nisoImageMetadata.getSamplingFrequencyUnit()) != -1) {
            this._writer.println(string2 + "SamplingFrequencyUnit: " + this.addIntegerValue(n4, NisoImageMetadata.SAMPLING_FREQUENCY_UNIT, bl));
        }
        if ((rational = nisoImageMetadata.getXSamplingFrequency()) != null) {
            this._writer.println(string2 + "XSamplingFrequency: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getYSamplingFrequency()) != null) {
            this._writer.println(string2 + "YSamplingFrequency: " + this.addRationalValue(rational, bl));
        }
        if ((l = nisoImageMetadata.getImageWidth()) != -1L) {
            this._writer.println(string2 + "ImageWidth: " + l);
        }
        if ((l = nisoImageMetadata.getImageLength()) != -1L) {
            this._writer.println(string2 + "ImageLength: " + l);
        }
        if ((d = nisoImageMetadata.getSourceXDimension()) != -1.0) {
            this._writer.println(string2 + "SourceXDimension: " + d);
        }
        if ((n4 = nisoImageMetadata.getSourceXDimensionUnit()) != -1) {
            this._writer.println(string2 + "SourceXDimensionUnit: " + this.addIntegerValue(n4, NisoImageMetadata.SOURCE_DIMENSION_UNIT, bl));
        }
        if ((d = nisoImageMetadata.getSourceYDimension()) != -1.0) {
            this._writer.println(string2 + "SourceYDimension: " + l);
        }
        if ((n4 = nisoImageMetadata.getSourceYDimensionUnit()) != -1) {
            this._writer.println(string2 + "SourceYDimensionUnit: " + this.addIntegerValue(n4, NisoImageMetadata.SOURCE_DIMENSION_UNIT, bl));
        }
        if ((nArray = nisoImageMetadata.getBitsPerSample()) != null) {
            this._writer.print(string2 + "BitsPerSample: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((n4 = nisoImageMetadata.getSamplesPerPixel()) != -1) {
            this._writer.println(string2 + "SamplesPerPixel: " + n4);
        }
        if ((nArray = nisoImageMetadata.getExtraSamples()) != null) {
            this._writer.print(string2 + "ExtraSamples: " + this.addIntegerValue(nArray[0], NisoImageMetadata.EXTRA_SAMPLES, bl));
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + this.addIntegerValue(nArray[n], NisoImageMetadata.EXTRA_SAMPLES, bl));
            }
            this._writer.println();
        }
        if ((string3 = nisoImageMetadata.getColormapReference()) != null) {
            this._writer.println(string2 + "ColormapReference: " + string3);
        }
        if ((nArray = nisoImageMetadata.getColormapBitCodeValue()) != null) {
            this._writer.print(string2 + "ColormapBitCodeValue: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((nArray = nisoImageMetadata.getColormapRedValue()) != null) {
            this._writer.print(string2 + "ColormapRedValue: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((nArray = nisoImageMetadata.getColormapGreenValue()) != null) {
            this._writer.print(string2 + "ColormapGreenValue: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((nArray = nisoImageMetadata.getColormapBlueValue()) != null) {
            this._writer.print(string2 + "ColormapBlueValue: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((nArray = nisoImageMetadata.getGrayResponseCurve()) != null) {
            this._writer.print(string2 + "GrayResponseCurve: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((n4 = nisoImageMetadata.getGrayResponseUnit()) != -1) {
            this._writer.println(string2 + "GrayResponseUnit: " + this.addIntegerValue(n4, NisoImageMetadata.GRAY_RESPONSE_UNIT, bl));
        }
        if ((rational = nisoImageMetadata.getWhitePointXValue()) != null) {
            this._writer.println(string2 + "WhitePointXValue: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getWhitePointYValue()) != null) {
            this._writer.println(string2 + "WhitePointXValue: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedX()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesRedX: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedY()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesRedY: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenX()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesGreenX: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenY()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesGreenY: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueX()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesBlueX: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueY()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesBlueY: " + this.addRationalValue(rational, bl));
        }
        if ((n4 = nisoImageMetadata.getTargetType()) != -1) {
            this._writer.println(string2 + "TargetType: " + this.addIntegerValue(n4, NisoImageMetadata.TARGET_TYPE, bl));
        }
        if ((string3 = nisoImageMetadata.getTargetIDManufacturer()) != null) {
            this._writer.println(string2 + "TargetIDManufacturer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getTargetIDName()) != null) {
            this._writer.println(string2 + "TargetIDName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getTargetIDNo()) != null) {
            this._writer.println(string2 + "TargetIDNo: " + string3);
        }
        if ((string3 = nisoImageMetadata.getTargetIDMedia()) != null) {
            this._writer.println(string2 + "TargetIDMedia: " + string3);
        }
        if ((string3 = nisoImageMetadata.getImageData()) != null) {
            this._writer.println(string2 + "ImageData: " + string3);
        }
        if ((string3 = nisoImageMetadata.getPerformanceData()) != null) {
            this._writer.println(string2 + "PerformanceData: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProfiles()) != null) {
            this._writer.println(string2 + "Profiles: " + string3);
        }
        if ((string3 = nisoImageMetadata.getDateTimeProcessed()) != null) {
            this._writer.println(string2 + "DateTimeProcessed: " + string3);
        }
        if ((string3 = nisoImageMetadata.getSourceData()) != null) {
            this._writer.println(string2 + "SourceData: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProcessingAgency()) != null) {
            this._writer.println(string2 + "ProcessingAgency: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProcessingSoftwareName()) != null) {
            this._writer.println(string2 + "ProcessingSoftwareName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProcessingSoftwareVersion()) != null) {
            this._writer.println(string2 + "ProcessingSoftwareVersion: " + string3);
        }
        if ((stringArray = nisoImageMetadata.getProcessingActions()) != null) {
            this._writer.print(string2 + "ProcessingActions: " + stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this._writer.print(", " + stringArray[i]);
            }
            this._writer.println();
        }
    }

    private void showNisoImageMetadata10(NisoImageMetadata nisoImageMetadata, String string, boolean bl) {
        String[] stringArray;
        int n;
        Rational rational;
        double[] dArray;
        double d;
        int n2;
        Rational[] rationalArray;
        int[] nArray;
        int n3;
        long l;
        String string2 = string + " ";
        this._writer.println();
        String string3 = nisoImageMetadata.getImageIdentifier();
        if (string3 != null) {
            this._writer.println(string2 + "ImageIdentifier: " + string3);
        }
        if ((l = nisoImageMetadata.getFileSize()) != -1L) {
            this._writer.println(string2 + "FileSize: " + l);
        }
        if ((string3 = nisoImageMetadata.getByteOrder()) != null) {
            if (string3.startsWith("big")) {
                string3 = "big_endian";
            } else if (string3.startsWith("little")) {
                string3 = "little_endian";
            }
            this._writer.println(string2 + "ByteOrder: " + string3);
        }
        if ((n3 = nisoImageMetadata.getCompressionScheme()) != -1) {
            this._writer.println(string2 + "CompressionScheme: " + this.addIntegerValue(n3, NisoImageMetadata.COMPRESSION_SCHEME, NisoImageMetadata.COMPRESSION_SCHEME_INDEX, bl));
        }
        if ((n3 = nisoImageMetadata.getCompressionLevel()) != -1) {
            this._writer.println(string2 + "CompressionLevel: " + n3);
        }
        if ((n3 = nisoImageMetadata.getChecksumMethod()) != -1) {
            this._writer.println(string2 + "ChecksumMethod: " + this.addIntegerValue(n3, NisoImageMetadata.CHECKSUM_METHOD, bl));
        }
        if ((string3 = nisoImageMetadata.getChecksumValue()) != null) {
            this._writer.println(string2 + "ChecksumValue: " + string3);
        }
        if ((l = nisoImageMetadata.getImageWidth()) != -1L) {
            this._writer.println(string2 + "ImageWidth: " + l);
        }
        if ((l = nisoImageMetadata.getImageLength()) != -1L) {
            this._writer.println(string2 + "ImageHeight: " + l);
        }
        if ((n3 = nisoImageMetadata.getColorSpace()) != -1) {
            this._writer.println(string2 + "ColorSpace: " + this.addIntegerValue(n3, NisoImageMetadata.COLORSPACE, NisoImageMetadata.COLORSPACE_INDEX, bl));
        }
        if ((string3 = nisoImageMetadata.getProfileName()) != null) {
            this._writer.println(string2 + "iccProfileName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProfileURL()) != null) {
            this._writer.println(string2 + "iccProfileURL: " + string3);
        }
        if ((nArray = nisoImageMetadata.getYCbCrSubSampling()) != null) {
            this._writer.print(string2 + "YCbCrSubSampling: " + nArray[0]);
            for (int i = 1; i < nArray.length; ++i) {
                this._writer.print(", " + nArray[i]);
            }
            this._writer.println();
        }
        if ((rationalArray = nisoImageMetadata.getYCbCrCoefficients()) != null) {
            this._writer.print(string2 + "YCbCrCoefficients: " + this.addRationalValue(rationalArray[0], bl));
            for (n2 = 1; n2 < rationalArray.length; ++n2) {
                this._writer.print(", " + this.addRationalValue(rationalArray[n2], bl));
            }
            this._writer.println();
        }
        if ((rationalArray = nisoImageMetadata.getReferenceBlackWhite()) != null) {
            this._writer.print(string2 + "ReferenceBlackWhite: " + this.addRationalValue(rationalArray[0], bl));
            for (n2 = 1; n2 < rationalArray.length; ++n2) {
                this._writer.print(", " + this.addRationalValue(rationalArray[n2], bl));
            }
            this._writer.println();
        }
        if ((string3 = nisoImageMetadata.getSourceType()) != null) {
            this._writer.println(string2 + "SourceType: " + string3);
        }
        if ((string3 = nisoImageMetadata.getSourceID()) != null) {
            this._writer.println(string2 + "SourceID" + string3);
        }
        if ((d = nisoImageMetadata.getSourceXDimension()) != -1.0) {
            this._writer.println(string2 + "SourceXDimension: " + d);
        }
        if ((n3 = nisoImageMetadata.getSourceXDimensionUnit()) != -1) {
            this._writer.println(string2 + "SourceXDimensionUnit: " + this.addIntegerValue(n3, NisoImageMetadata.SOURCE_DIMENSION_UNIT, bl));
        }
        if ((d = nisoImageMetadata.getSourceYDimension()) != -1.0) {
            this._writer.println(string2 + "SourceYDimension: " + l);
        }
        if ((n3 = nisoImageMetadata.getSourceYDimensionUnit()) != -1) {
            this._writer.println(string2 + "SourceYDimensionUnit: " + this.addIntegerValue(n3, NisoImageMetadata.SOURCE_DIMENSION_UNIT, bl));
        }
        if ((string3 = nisoImageMetadata.getDateTimeCreated()) != null) {
            this._writer.println(string2 + "DateTimeCreated: " + string3);
        }
        if ((string3 = nisoImageMetadata.getImageProducer()) != null) {
            this._writer.println(string2 + "ImageProducer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getDeviceSource()) != null) {
            this._writer.println(string2 + "CaptureDevice: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerManufacturer()) != null) {
            this._writer.println(string2 + "ScannerManufacturer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerModelName()) != null) {
            this._writer.println(string2 + "ScannerModelName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerModelNumber()) != null) {
            this._writer.println(string2 + "ScannerModelNumber: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScannerModelSerialNo()) != null) {
            this._writer.println(string2 + "ScannerModelSerialNo: " + string3);
        }
        double d2 = nisoImageMetadata.getXPhysScanResolution();
        double d3 = nisoImageMetadata.getYPhysScanResolution();
        if (d2 != -1.0 && d3 != -1.0) {
            double d4 = d2 > d3 ? d2 : d3;
            this._writer.println(string2 + "MaximumOpticalResolution: " + Double.toString(d4));
        }
        if ((string3 = nisoImageMetadata.getScanningSoftware()) != null) {
            this._writer.println(string2 + "ScanningSoftware: " + string3);
        }
        if ((string3 = nisoImageMetadata.getScanningSoftwareVersionNo()) != null) {
            this._writer.println(string2 + "ScanningSoftwareVersionNo: " + string3);
        }
        if ((string3 = nisoImageMetadata.getDigitalCameraManufacturer()) != null) {
            this._writer.println(string2 + "DigitalCameraManufacturer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getDigitalCameraModel()) != null) {
            this._writer.println(string2 + "DigitalCameraModel: " + string3);
        }
        if ((d = nisoImageMetadata.getFNumber()) != -1.0) {
            this._writer.println(string2 + "FNumber: " + d);
        }
        if ((d = nisoImageMetadata.getExposureTime()) != -1.0) {
            this._writer.println(string2 + "ExposureTime: " + d);
        }
        if ((d = nisoImageMetadata.getBrightness()) != -1.0) {
            this._writer.println(string2 + "BrightnessValue: " + d);
        }
        if ((d = nisoImageMetadata.getExposureBias()) != -1.0) {
            this._writer.println(string2 + "ExposureBiasValue: " + d);
        }
        if ((dArray = nisoImageMetadata.getSubjectDistance()) != null) {
            this._writer.print(string2 + "SubjectDistance: " + dArray[0]);
            for (int i = 1; i < dArray.length; ++i) {
                this._writer.print(", " + dArray[i]);
            }
            this._writer.println();
        }
        if ((n3 = nisoImageMetadata.getMeteringMode()) != -1) {
            this._writer.println(string2 + "MeteringMode: " + this.addIntegerValue(n3, NisoImageMetadata.METERING_MODE, bl));
        }
        if ((n3 = nisoImageMetadata.getFlash()) != -1) {
            this._writer.println(string2 + "Flash: " + this.addIntegerValue(n3, NisoImageMetadata.FLASH, bl));
        }
        if ((d = nisoImageMetadata.getFocalLength()) != -1.0) {
            this._writer.println(string2 + "FocalLength: " + d);
        }
        if ((d = nisoImageMetadata.getFlashEnergy()) != -1.0) {
            this._writer.println(string2 + "FlashEnergy: " + d);
        }
        if ((n3 = nisoImageMetadata.getBackLight()) != -1) {
            this._writer.println(string2 + "BackLight: " + this.addIntegerValue(n3, NisoImageMetadata.BACKLIGHT, bl));
        }
        if ((d = nisoImageMetadata.getExposureIndex()) != -1.0) {
            this._writer.println(string2 + "ExposureIndex: " + d);
        }
        if ((n3 = nisoImageMetadata.getAutoFocus()) != -1) {
            this._writer.println(string2 + "AutoFocus: " + this.addIntegerValue(n3, NisoImageMetadata.AUTOFOCUS, bl));
        }
        if ((d = nisoImageMetadata.getXPrintAspectRatio()) != -1.0) {
            this._writer.println(string2 + "XPrintAspectRatio: " + d);
        }
        if ((d = nisoImageMetadata.getYPrintAspectRatio()) != -1.0) {
            this._writer.println(string2 + "YPrintAspectRatio: " + d);
        }
        if ((n3 = nisoImageMetadata.getOrientation()) != -1) {
            this._writer.println(string2 + "Orientation: " + this.addIntegerValue(n3, NisoImageMetadata.ORIENTATION, bl));
        }
        if ((string3 = nisoImageMetadata.getMethodology()) != null) {
            this._writer.println(string2 + "Methodology: " + string3);
        }
        if ((n3 = nisoImageMetadata.getSamplingFrequencyPlane()) != -1) {
            this._writer.println(string2 + "SamplingFrequencyPlane: " + this.addIntegerValue(n3, NisoImageMetadata.SAMPLING_FREQUENCY_PLANE, bl));
        }
        if ((n3 = nisoImageMetadata.getSamplingFrequencyUnit()) != -1) {
            this._writer.println(string2 + "SamplingFrequencyUnit: " + this.addIntegerValue(n3, NisoImageMetadata.SAMPLING_FREQUENCY_UNIT, bl));
        }
        if ((rational = nisoImageMetadata.getXSamplingFrequency()) != null) {
            this._writer.println(string2 + "XSamplingFrequency: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getYSamplingFrequency()) != null) {
            this._writer.println(string2 + "YSamplingFrequency: " + this.addRationalValue(rational, bl));
        }
        if ((nArray = nisoImageMetadata.getBitsPerSample()) != null) {
            this._writer.print(string2 + "BitsPerSample: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
            this._writer.println(string2 + "BitsPerSampleUnit: integer");
        }
        if ((n3 = nisoImageMetadata.getSamplesPerPixel()) != -1) {
            this._writer.println(string2 + "SamplesPerPixel: " + n3);
        }
        if ((nArray = nisoImageMetadata.getExtraSamples()) != null) {
            this._writer.print(string2 + "ExtraSamples: " + this.addIntegerValue(nArray[0], NisoImageMetadata.EXTRA_SAMPLES, bl));
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + this.addIntegerValue(nArray[n], NisoImageMetadata.EXTRA_SAMPLES, bl));
            }
            this._writer.println();
        }
        if ((string3 = nisoImageMetadata.getColormapReference()) != null) {
            this._writer.println(string2 + "ColormapReference: " + string3);
        }
        if ((nArray = nisoImageMetadata.getGrayResponseCurve()) != null) {
            this._writer.print(string2 + "GrayResponseCurve: " + nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                this._writer.print(", " + nArray[n]);
            }
            this._writer.println();
        }
        if ((n3 = nisoImageMetadata.getGrayResponseUnit()) != -1) {
            this._writer.println(string2 + "GrayResponseUnit: " + this.addIntegerValue(n3, NisoImageMetadata.GRAY_RESPONSE_UNIT, bl));
        }
        if ((rational = nisoImageMetadata.getWhitePointXValue()) != null) {
            this._writer.println(string2 + "WhitePointXValue: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getWhitePointYValue()) != null) {
            this._writer.println(string2 + "WhitePointXValue: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedX()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesRedX: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedY()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesRedY: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenX()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesGreenX: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenY()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesGreenY: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueX()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesBlueX: " + this.addRationalValue(rational, bl));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueY()) != null) {
            this._writer.println(string2 + "PrimaryChromaticitiesBlueY: " + this.addRationalValue(rational, bl));
        }
        if ((n3 = nisoImageMetadata.getTargetType()) != -1) {
            this._writer.println(string2 + "TargetType: " + this.addIntegerValue(n3, NisoImageMetadata.TARGET_TYPE, bl));
        }
        if ((string3 = nisoImageMetadata.getTargetIDManufacturer()) != null) {
            this._writer.println(string2 + "TargetIDManufacturer: " + string3);
        }
        if ((string3 = nisoImageMetadata.getTargetIDName()) != null) {
            this._writer.println(string2 + "TargetIDName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getTargetIDNo()) != null) {
            this._writer.println(string2 + "TargetIDNo: " + string3);
        }
        if ((string3 = nisoImageMetadata.getTargetIDMedia()) != null) {
            this._writer.println(string2 + "TargetIDMedia: " + string3);
        }
        if ((string3 = nisoImageMetadata.getImageData()) != null) {
            this._writer.println(string2 + "ExternalTarget: " + string3);
        }
        if ((string3 = nisoImageMetadata.getPerformanceData()) != null) {
            this._writer.println(string2 + "PerformanceData: " + string3);
        }
        if ((string3 = nisoImageMetadata.getSourceData()) != null) {
            this._writer.println(string2 + "SourceData: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProcessingAgency()) != null) {
            this._writer.println(string2 + "ProcessingAgency: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProcessingSoftwareName()) != null) {
            this._writer.println(string2 + "ProcessingSoftwareName: " + string3);
        }
        if ((string3 = nisoImageMetadata.getProcessingSoftwareVersion()) != null) {
            this._writer.println(string2 + "ProcessingSoftwareVersion: " + string3);
        }
        if ((string3 = nisoImageMetadata.getOS()) != null) {
            this._writer.println(string2 + "OperatingSystem: " + string3);
        }
        if ((string3 = nisoImageMetadata.getOSVersion()) != null) {
            this._writer.println(string2 + "OSVersion: " + string3);
        }
        if ((stringArray = nisoImageMetadata.getProcessingActions()) != null) {
            this._writer.print(string2 + "ProcessingActions: " + stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this._writer.print(", " + stringArray[i]);
            }
            this._writer.println();
        }
    }

    private String addIntegerValue(int n, String[] stringArray, boolean bl) {
        String string = null;
        string = !bl && 0 <= n && n < stringArray.length ? stringArray[n] : Integer.toString(n);
        return string;
    }

    private String addIntegerValue(int n, String[] stringArray, int[] nArray, boolean bl) {
        String string = null;
        boolean bl2 = false;
        if (!bl) {
            int n2 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                n2 = i;
                break;
            }
            if (n2 > -1) {
                string = stringArray[n2];
            } else {
                bl2 = true;
            }
        }
        if (bl || bl2) {
            string = Integer.toString(n);
        }
        return string;
    }

    private String addRationalValue(Rational rational, boolean bl) {
        String string = null;
        string = !bl ? this._format.format(rational.toDouble()) : rational.toString();
        return string;
    }
}

