/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class SampleChunk
extends Chunk {
    public SampleChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        long manufacturer = module.readUnsignedInt(this._dstream);
        long product = module.readUnsignedInt(this._dstream);
        long samplePeriod = module.readUnsignedInt(this._dstream);
        long unityNote = module.readUnsignedInt(this._dstream);
        long pitchFraction = module.readUnsignedInt(this._dstream);
        long smpteFormat = module.readUnsignedInt(this._dstream);
        int sampleOffsetHour = ModuleBase.readSignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int sampleOffsetMinute = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int sampleOffsetSecond = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int sampleOffsetFrames = ModuleBase.readSignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        Property[] smpteArr = new Property[]{new Property("Hour", PropertyType.INTEGER, (Object)new Integer(sampleOffsetHour)), new Property("Minute", PropertyType.INTEGER, (Object)new Integer(sampleOffsetMinute)), new Property("Second", PropertyType.INTEGER, (Object)new Integer(sampleOffsetSecond)), new Property("Frames", PropertyType.INTEGER, (Object)new Integer(sampleOffsetFrames))};
        int nLoops = (int)module.readUnsignedInt(this._dstream);
        long extraBytes = module.readUnsignedInt(this._dstream);
        Property[] loopProps = new Property[nLoops];
        for (int i = 0; i < nLoops; ++i) {
            long cuePoint = module.readUnsignedInt(this._dstream);
            int type = (int)module.readUnsignedInt(this._dstream);
            int start = (int)module.readUnsignedInt(this._dstream);
            int end = (int)module.readUnsignedInt(this._dstream);
            long fraction = module.readUnsignedInt(this._dstream);
            long playCount = module.readUnsignedInt(this._dstream);
            Property[] lp = new Property[]{new Property("CuePointID", PropertyType.LONG, (Object)new Long(cuePoint)), new Property("Type", PropertyType.INTEGER, (Object)new Integer(type)), new Property("Start", PropertyType.INTEGER, (Object)new Integer(start)), new Property("End", PropertyType.INTEGER, (Object)new Integer(end)), new Property("Fraction", PropertyType.LONG, (Object)new Long(fraction)), new Property("PlayCount", PropertyType.LONG, (Object)new Long(playCount))};
            loopProps[i] = new Property("Loop", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)lp);
        }
        Property[] propArr = new Property[]{new Property("Manufacturer", PropertyType.LONG, (Object)new Long(manufacturer)), new Property("Product", PropertyType.LONG, (Object)new Long(product)), new Property("SamplePeriod", PropertyType.LONG, (Object)new Long(samplePeriod)), new Property("UnityNote", PropertyType.LONG, (Object)new Long(unityNote)), new Property("PitchFraction", PropertyType.LONG, (Object)new Long(pitchFraction)), new Property("SMPTEFormat", PropertyType.LONG, (Object)new Long(smpteFormat)), new Property("SMPTEOffset", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)smpteArr), new Property("Loops", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)loopProps), new Property("ExtraDataBytes", PropertyType.LONG, (Object)new Long(extraBytes))};
        module.addSample(new Property("Sample", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propArr));
        module.skipBytes(this._dstream, (int)extraBytes, this._module);
        return true;
    }
}

