/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.Descriptor;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRoles;
import com.exlibris.core.infra.model.consortium.HFrInstitution;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.PDSManager;
import com.exlibris.core.infra.svc.api.UserManager;
import com.exlibris.core.infra.svc.api.config.PrivilegeCacheManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import com.exlibris.core.infra.svc.api.utils.PdsUserData;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class PdsUtils {
    public static final String PDS_HANDLE_EMPTY_ERROR = "pdsHandle cannot be empty";
    private static final ExLogger log = ExLogger.getExLogger(PdsUtils.class);

    public static PdsUserData getPdsUserData(String pdsHandle) {
        List<HFrUserRoles> userRoles;
        PdsUserData pdsUserData = new PdsUserData();
        pdsUserData.setValidPdsHandle(true);
        Descriptor descriptor = new Descriptor();
        PDSManager pdManager = (PDSManager)ServiceLocator.getInstance().lookUp(PDSManager.class);
        PdsUserInfo userInfo = pdManager.ValidatePdsHandle(pdsHandle, descriptor);
        if (userInfo == null) {
            descriptor = DescriptorConstants.DP_InvalidPdsHandle;
            String[] vars = new String[]{pdsHandle};
            descriptor.initMessage(vars);
            pdsUserData.setValidPdsHandle(false);
            pdsUserData.setDescriptor(descriptor);
            return pdsUserData;
        }
        String institutionIdStr = userInfo.getBorDeptM();
        ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
        HFrInstitution institution = consMng.findInstitutionByCode(institutionIdStr);
        HFrUser user = null;
        String userIdStr = null;
        try {
            UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
            user = depMng.getUserByName(userInfo.getUserName());
            userIdStr = user.getId().toString();
        }
        catch (Exception e) {
            descriptor = DescriptorConstants.DP_InvalidUserOrInstitution;
            String[] vars = new String[]{userIdStr, institutionIdStr};
            descriptor.initMessage(vars);
            pdsUserData.setValidPdsHandle(false);
            pdsUserData.setDescriptor(descriptor);
            return pdsUserData;
        }
        pdsUserData.setInstitution(institution);
        pdsUserData.setUser(user);
        try {
            userRoles = pdManager.getUserRoleByUserAndInstitution(user, institution.getPath());
        }
        catch (InfraException e) {
            log.error("Unable to get user roles for userName: " + user.getUserName(), new String[0]);
            return pdsUserData;
        }
        HashSet<String> privileges = new HashSet<String>();
        for (HFrUserRoles role : userRoles) {
            if (!role.getStatus().equals((Object)HFrUserRoles.Status.ACTIVE)) continue;
            String userRoleName = Integer.toString(role.getRoleType());
            privileges.addAll(PrivilegeCacheManager.getInstance().getPrivileges2Role(userRoleName));
        }
        pdsUserData.setPrivileges(privileges);
        return pdsUserData;
    }

    public static boolean validatePdsHandle(String pdsHandle, Descriptor descriptor) {
        PDSManager pdManager = (PDSManager)ServiceLocator.getInstance().lookUp(PDSManager.class);
        PdsUserInfo userInfo = pdManager.ValidatePdsHandle(pdsHandle, descriptor);
        if (userInfo == null) {
            return false;
        }
        String institutionIdStr = userInfo.getBorDeptM();
        String userIdStr = null;
        try {
            UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
            userIdStr = depMng.getUserByName(userInfo.getUserName()).getId().toString();
        }
        catch (Exception e) {
            descriptor = DescriptorConstants.DP_InvalidUserOrInstitution;
            String[] vars = new String[]{userIdStr, institutionIdStr};
            descriptor.initMessage(vars);
            return false;
        }
        return true;
    }

    public static Locale getUserLocale(String pdsHandle) {
        HFrUser user = PdsUtils.getLogInUser(pdsHandle);
        if (user == null) {
            new Locale("en");
        }
        return new Locale(user.getDefaultLanguage());
    }

    public static HFrUser getLogInUser(String pdsHandle) {
        PdsConnector pdsConnector = PdsConnector.getInstance();
        PdsUserInfo userInfo = pdsConnector.getUserInfo(pdsHandle);
        UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
        try {
            return depMng.getUserByName(userInfo.getUserName());
        }
        catch (InfraException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void quietPDSLogout(String sessionId, Object pdsHandle) {
        GeneralParameterManager gpMan = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String pdsURL = gpMan.getParameter("pds", "pds_internal_url");
        if (StringUtils.isBlank((String)pdsURL)) {
            pdsURL = gpMan.getParameter("pds", "pds_url");
        }
        if (pdsURL.indexOf("?") == -1) {
            pdsURL = pdsURL + "?";
        } else if (pdsURL.indexOf("?") != pdsURL.length() - 1) {
            pdsURL = pdsURL + "&";
        }
        String pdsLogoutUrl = pdsURL + "func=logout&pds_handle=" + pdsHandle;
        InputStream input = null;
        try {
            URL url = new URL(pdsLogoutUrl);
            URLConnection connection = url.openConnection();
            connection.setReadTimeout(30000);
            input = connection.getInputStream();
            IOUtil.toString(input);
            if (input == null) return;
        }
        catch (Exception e) {
            try {
                log.warn((Object)("couldn't revoke pds (" + pdsHandle + ") handle of session: " + sessionId), e, new String[0]);
                if (input == null) return;
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                IOUtil.closeQuietly(input);
                throw throwable;
            }
            IOUtil.closeQuietly(input);
            return;
        }
        IOUtil.closeQuietly(input);
        return;
    }
}

