/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.md;

import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.dps.sdk.deposit.IEParserImpl;
import com.exlibris.dps.sdk.md.MetadataParser;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import gov.loc.mets.AmdSecType;
import gov.loc.mets.MetsDocument;
import org.apache.xmlbeans.XmlObject;

public class MetadataParserImpl
extends IEParserImpl
implements MetadataParser {
    public MetadataParserImpl(MetsDocument metsDoc) {
        super(metsDoc);
    }

    @Override
    public void createMetadataMets(HDeMetadata metadata) throws Exception {
        if (metadata.getMdId() == 71) {
            XmlObject mdXML = this.getXmlObject(metadata.getValue());
            this.mets.set(mdXML);
        } else {
            DnxDocumentHelper helper = new DnxDocumentHelper(DnxDocumentFactory.getInstance().createDnxDocument());
            String entType = this.getEntPrefix(metadata);
            AmdSecType amd = this.getAmd(entType + "-amd", true);
            DnxDocument dnx = this.addMetaDataAMDSecToDnx(metadata, helper.getDocument());
            XmlObject mdDataXML = this.getXmlObject(dnx.toString());
            amd.getTechMDArray(0).getMdWrap().getXmlData().set(mdDataXML);
            if (metadata.getMdId() == 11 || metadata.getMdId() == 51) {
                XmlObject mdRightsXML = this.getXmlObject(metadata.getValue());
                amd.getRightsMDArray(0).getMdWrap().setOTHERMDTYPE("ar_policy");
                amd.getRightsMDArray(0).getMdWrap().getXmlData().set(mdRightsXML);
            } else if (metadata.getMdId() == 41) {
                DublinCore cmsDc = DublinCoreFactory.getInstance().createDocument(metadata.getValue());
                this.setIEDublinCore(cmsDc);
                this.mets.getDmdSecArray(0).setID(entType + "-dmd");
                amd.setRightsMDArray(null);
            }
            amd.setSourceMDArray(null);
            amd.setDigiprovMDArray(null);
        }
    }

    private String getEntPrefix(HDeMetadata metadata) {
        String type = null;
        switch (metadata.getMdId()) {
            case 11: 
            case 51: {
                type = "ar";
                break;
            }
            case 41: {
                type = "cms";
                break;
            }
            case 71: {
                type = "collection";
                break;
            }
        }
        return type;
    }

    private DnxDocument addMetaDataAMDSecToDnx(HDeMetadata md, DnxDocument dnx) {
        DnxDocumentHelper helper = new DnxDocumentHelper(dnx);
        DnxDocumentHelper.MetaData metadata = helper.new DnxDocumentHelper.MetaData();
        metadata.setMID(md.getMid());
        metadata.setUUID(md.getId().toString());
        metadata.setCreationDate(DateHandler.getStringFormatFromCalendar(md.getCreateDate()));
        metadata.setCreatedBy(md.getCreator());
        if (md.getModificationDate() != null) {
            metadata.setModificationDate(DateHandler.getStringFormatFromCalendar(md.getModificationDate()));
        }
        String modifiedBy = md.getModifiedBy() == null ? "" : md.getModifiedBy();
        metadata.setModifiedBy(modifiedBy);
        metadata.setMetadataType(md.getMdId() + "");
        String description = md.getDescription() == null ? "" : md.getDescription();
        metadata.setDescription(description);
        String externalSystem = md.getExternalSystem() == null ? "" : md.getExternalSystem();
        metadata.setExternalSystem(externalSystem);
        String externalSystemId = md.getExternalSystemId() == null ? "" : md.getExternalSystemId();
        metadata.setExternalRecordId(externalSystemId);
        if (md.getApplication() != null) {
            metadata.setApplication(md.getApplication());
        }
        return helper.getDocument();
    }
}

