/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import bsh.EvalError;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantAddException;
import ch.docuteam.darc.exceptions.MetadataElementCantDeleteException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementInstance;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class LevelMetadataElement {
    private final LevelOfDescription level;
    private final MetadataElement metadataElement;
    private final boolean isMandatory;
    private final boolean isAlwaysDisplayed;
    private final boolean isRepeatable;
    private final boolean isReadOnly;
    private final boolean keepInTemplate;
    private int displayRows;

    LevelMetadataElement(LevelOfDescription level, String metadataElementName, String isMandatory, String isAlwaysDisplayed, String isRepeatable, String isReadOnly, String keepInTemplate, String displayRows) throws MetadataElementIsNotDefinedException {
        this.level = level;
        this.metadataElement = MetadataElement.get(metadataElementName);
        if (this.metadataElement == null) {
            throw new MetadataElementIsNotDefinedException(level, metadataElementName);
        }
        this.isMandatory = new Boolean(isMandatory);
        this.isAlwaysDisplayed = new Boolean(isAlwaysDisplayed);
        this.isRepeatable = new Boolean(isRepeatable);
        this.isReadOnly = new Boolean(isReadOnly);
        this.keepInTemplate = new Boolean(keepInTemplate);
        try {
            this.displayRows = new Integer(displayRows);
        }
        catch (NumberFormatException x) {
            this.displayRows = 0;
        }
        Logger.debug((Object)("Created: " + this.toStringLong()));
    }

    public String getId() {
        return this.metadataElement.getId();
    }

    public LevelOfDescription getLevel() {
        return this.level;
    }

    public MetadataElement getMetadataElement() {
        return this.metadataElement;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean isAlwaysDisplayed() {
        return this.isAlwaysDisplayed;
    }

    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean keepInTemplate() {
        return this.keepInTemplate;
    }

    public int getDisplayRows() {
        return this.displayRows;
    }

    public boolean canAddOneInstanceToNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.isRepeatable) {
            return true;
        }
        if (this.isMandatory || this.isAlwaysDisplayed) {
            return false;
        }
        return this.metadataElement.getValueFromNode(node) == null;
    }

    public boolean canDeleteOneInstanceFromNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List<String> values = this.metadataElement.getValueFromNode(node);
        return !(this.isRepeatable ? values != null && values.size() <= 1 && (this.isMandatory || this.isAlwaysDisplayed) : this.isMandatory || this.isAlwaysDisplayed);
    }

    public List<String> getAllValuesFromNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList value = this.metadataElement.getValueFromNode(node);
        return value == null ? new ArrayList() : value;
    }

    public String getValueFromNode(int i, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List<String> value = this.metadataElement.getValueFromNode(node);
        return value == null ? null : value.get(i);
    }

    public void setValueInNode(int i, String newValue, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, LevelMetadataElementIsReadOnly {
        if (this.isReadOnly) {
            throw new LevelMetadataElementIsReadOnly(this.level, this.metadataElement.getAccessorName());
        }
        this.validateValueAgainstNode(newValue, node);
        this.setValueInNode_NoCheck(i, newValue, node);
    }

    public void setValueInNode_NoCheck(int i, String newValue, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        if (!this.getMetadataElement().isPostActionDefined()) {
            this.setValueInNode_Basic(i, newValue, node);
        } else {
            List<String> values = this.metadataElement.getValueFromNode(node);
            if (values == null) {
                values = new ArrayList<String>(1);
            }
            String oldValue = null;
            if (!values.isEmpty()) {
                oldValue = values.get(i);
            }
            this.setValueInNode_Basic(i, newValue, node);
            this.getMetadataElement().executePostActionInNode(oldValue, newValue, node, i);
        }
    }

    public void setValueInNode_Basic(int i, String newValue, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List<String> values = this.metadataElement.getValueFromNode(node);
        if (values == null) {
            values = new ArrayList<String>(1);
        }
        if (values.isEmpty() || i == values.size()) {
            values.add(newValue);
        } else {
            values.set(i, newValue);
        }
        if (values.size() == 1 && newValue == null) {
            values = null;
        }
        this.metadataElement.setValueInNode(values, node);
    }

    public void clearValueInNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.metadataElement.setValueInNode(null, node);
    }

    public String getDefaultValueFromNode(NodeAbstract node) throws EvalError, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementAllowedValuesException {
        return this.getMetadataElement().getDefaultValueFromNode(node);
    }

    public void validateValueAgainstNode(String value, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementAllowedValuesException {
        this.getMetadataElement().validateValueAgainstNode(value, node);
    }

    public List<MetadataElementInstance> getMetadataElementInstancesOfNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<MetadataElementInstance> mdElementInstances = new ArrayList<MetadataElementInstance>();
        if (this.isRepeatable) {
            List<String> values = this.metadataElement.getValueFromNode(node);
            if (values != null) {
                int i = 0;
                for (String value : values) {
                    mdElementInstances.add(new MetadataElementInstance(this, node, value, i++));
                }
            }
        } else {
            String value = this.getValueFromNode(0, node);
            mdElementInstances.add(new MetadataElementInstance(this, node, value, 0));
        }
        return mdElementInstances;
    }

    public void addMetadataElementInstanceToNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementCantAddException, EvalError, MetadataElementValidatorException, MetadataElementAllowedValuesException {
        String defaultValue;
        if (!this.canAddOneInstanceToNode(node)) {
            throw new MetadataElementCantAddException(this.getId());
        }
        List<String> values = this.metadataElement.getValueFromNode(node);
        if (this.isRepeatable) {
            if (values == null) {
                values = new ArrayList<String>();
            }
        } else {
            if (values != null) {
                throw new MetadataElementCantAddException(this.getId());
            }
            values = new ArrayList<String>();
        }
        values.add((defaultValue = this.getDefaultValueFromNode(node)) != null ? defaultValue : "");
        this.metadataElement.setValueInNode(values, node);
    }

    public void deleteMetadataElementInstanceFromNode(NodeAbstract node, int i) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementCantDeleteException {
        if (!this.canDeleteOneInstanceFromNode(node)) {
            throw new MetadataElementCantDeleteException(this.getId());
        }
        List<String> values = this.metadataElement.getValueFromNode(node);
        if (this.isRepeatable) {
            if (this.isMandatory && values.size() <= 1) {
                throw new MetadataElementCantDeleteException(this.getId());
            }
            values.remove(i);
            if (values.isEmpty()) {
                values = null;
            }
        } else {
            if (this.isMandatory) {
                throw new MetadataElementCantDeleteException(this.getId());
            }
            values = null;
        }
        this.metadataElement.setValueInNode(values, node);
    }

    public void deleteMetadataElementInstanceFromNodeWithoutCheck(NodeAbstract node, MetadataElementInstance mde) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementCantDeleteException {
        List<String> values = this.metadataElement.getValueFromNode(node);
        if (this.isRepeatable) {
            values.remove(mde.getIndex());
            if (values.isEmpty()) {
                values = null;
            }
        } else {
            values = null;
        }
        this.metadataElement.setValueInNode(values, node);
    }

    public String toString() {
        return I18N.translate((String)this.metadataElement.getAccessorName());
    }

    public String toStringLong() {
        return "[LevelMetadataElement: " + this.level.getName() + "-" + this.metadataElement + " " + this.isMandatory + " " + this.isRepeatable + " " + this.isReadOnly + " " + this.keepInTemplate + " " + this.displayRows + "]";
    }
}

