/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.domain;

import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Metadata;
import gov.loc.repository.bagit.domain.Version;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Bag {
    private Version version = new Version(-1, -1);
    private Charset fileEncoding = StandardCharsets.UTF_8;
    private Set<Manifest> payLoadManifests = new HashSet<Manifest>();
    private Set<Manifest> tagManifests = new HashSet<Manifest>();
    private List<FetchItem> itemsToFetch = new ArrayList<FetchItem>();
    private Metadata metadata = new Metadata();
    private Path rootDir;

    public Bag() {
    }

    public Bag(Version version) {
        this.version = version;
    }

    public Bag(Bag bag) {
        this.version = bag.getVersion();
        this.fileEncoding = bag.fileEncoding;
        this.itemsToFetch = bag.getItemsToFetch();
        this.metadata = bag.getMetadata();
        this.payLoadManifests = bag.getPayLoadManifests();
        this.tagManifests = bag.getTagManifests();
        this.rootDir = bag.getRootDir();
    }

    public Version getVersion() {
        return this.version;
    }

    public Set<Manifest> getPayLoadManifests() {
        return this.payLoadManifests;
    }

    public void setPayLoadManifests(Set<Manifest> payLoadManifests) {
        this.payLoadManifests = payLoadManifests;
    }

    public Set<Manifest> getTagManifests() {
        return this.tagManifests;
    }

    public void setTagManifests(Set<Manifest> tagManifests) {
        this.tagManifests = tagManifests;
    }

    public List<FetchItem> getItemsToFetch() {
        return this.itemsToFetch;
    }

    public void setItemsToFetch(List<FetchItem> itemsToFetch) {
        this.itemsToFetch = itemsToFetch;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Charset getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(Charset fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(95);
        sb.append("Bag [version=").append(this.version).append(", fileEncoding=").append(this.fileEncoding).append(", payLoadManifests=[");
        for (Manifest payloadManifest : this.payLoadManifests) {
            sb.append(payloadManifest).append(' ');
        }
        sb.append("], tagManifests=[");
        for (Manifest tagManifest : this.tagManifests) {
            sb.append(tagManifest).append(' ');
        }
        sb.append("], itemsToFetch=").append(this.itemsToFetch).append(", metadata=").append(this.metadata).append(']');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.version) + Objects.hash(this.fileEncoding) + Objects.hash(this.payLoadManifests) + Objects.hash(this.tagManifests) + Objects.hash(this.itemsToFetch) + Objects.hash(this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bag)) {
            return false;
        }
        Bag other = (Bag)obj;
        return Objects.equals(this.version, other.getVersion()) && Objects.equals(this.fileEncoding, other.getFileEncoding()) && Objects.equals(this.payLoadManifests, other.getPayLoadManifests()) && Objects.equals(this.tagManifests, other.getTagManifests()) && Objects.equals(this.itemsToFetch, other.getItemsToFetch()) && Objects.equals(this.metadata, other.getMetadata());
    }

    public Path getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(Path rootDir) {
        this.rootDir = rootDir;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

