/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.aiff.AiffStrings;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class InstrumentChunk
extends Chunk {
    public InstrumentChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        int baseNote = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int detune = ModuleBase.readSignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int lowNote = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int highNote = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int lowVelocity = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int highVelocity = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
        int gain = module.readSignedShort(this._dstream);
        Loop sustainLoop = this.readLoop(module);
        Loop releaseLoop = this.readLoop(module);
        ArrayList<Property> propList = new ArrayList<Property>(9);
        propList.add(new Property("BaseNote", PropertyType.INTEGER, (Object)new Integer(baseNote)));
        propList.add(new Property("Detune", PropertyType.INTEGER, (Object)new Integer(detune)));
        propList.add(new Property("LowNote", PropertyType.INTEGER, (Object)new Integer(lowNote)));
        propList.add(new Property("HighNote", PropertyType.INTEGER, (Object)new Integer(highNote)));
        propList.add(new Property("LowVelocity", PropertyType.INTEGER, (Object)new Integer(lowVelocity)));
        propList.add(new Property("HighVelocity", PropertyType.INTEGER, (Object)new Integer(highVelocity)));
        propList.add(new Property("Gain", PropertyType.INTEGER, (Object)new Integer(gain)));
        propList.add(sustainLoop.loopProp("SustainLoop"));
        propList.add(releaseLoop.loopProp("ReleaseLoop"));
        module.addAiffProperty(new Property("Instrument", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }

    private Loop readLoop(AiffModule module) throws IOException {
        int playMode = module.readSignedShort(this._dstream);
        int beginLoop = module.readUnsignedShort(this._dstream);
        int endLoop = module.readUnsignedShort(this._dstream);
        return new Loop(playMode, beginLoop, endLoop);
    }

    private class Loop {
        public int playMode;
        public int beginLoop;
        public int endLoop;

        public Loop(int playMode, int beginLoop, int endLoop) {
            this.playMode = playMode;
            this.beginLoop = beginLoop;
            this.endLoop = endLoop;
        }

        public Property loopProp(String name) {
            Property[] propArr = new Property[]{InstrumentChunk.this._module.addIntegerProperty("PlayMode", this.playMode, AiffStrings.LOOP_TYPE), new Property("BeginLoop", PropertyType.INTEGER, (Object)new Integer(this.beginLoop)), new Property("EndLoop", PropertyType.INTEGER, (Object)new Integer(this.endLoop))};
            return new Property(name, PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propArr);
        }
    }
}

