/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.file.FileInputSocket;
import de.schlichtherle.truezip.fs.file.FileOutputSocket;
import de.schlichtherle.truezip.fs.file.TempFilePool;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.Pool;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class FileEntry
extends FsEntry
implements IOEntry<FileEntry>,
Pool.Releasable<IOException> {
    private static final File CURRENT_DIRECTORY = new File(".");
    private final File file;
    private final String name;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    volatile TempFilePool pool;

    FileEntry(File file) {
        assert (null != file);
        this.file = file;
        this.name = file.toString();
    }

    FileEntry(File file, FsEntryName name) {
        assert (null != file);
        this.file = new File(file, name.getPath());
        this.name = name.toString();
    }

    final FileEntry createTempFile() throws IOException {
        TempFilePool pool = this.pool;
        if (null == pool) {
            this.pool = pool = new TempFilePool(this.getParent(), this.getFileName());
        }
        return pool.allocate();
    }

    private File getParent() {
        File file = this.file.getParentFile();
        return null != file ? file : CURRENT_DIRECTORY;
    }

    private String getFileName() {
        return this.file.getName();
    }

    public void release() throws IOException {
    }

    final File getFile() {
        return this.file;
    }

    public final String getName() {
        return this.name.replace(File.separatorChar, '/');
    }

    public final Set<Entry.Type> getTypes() {
        if (this.file.isFile()) {
            return FILE_TYPE_SET;
        }
        if (this.file.isDirectory()) {
            return DIRECTORY_TYPE_SET;
        }
        if (this.file.exists()) {
            return SPECIAL_TYPE_SET;
        }
        return Collections.emptySet();
    }

    public final boolean isType(Entry.Type type) {
        switch (type) {
            case FILE: {
                return this.file.isFile();
            }
            case DIRECTORY: {
                return this.file.isDirectory();
            }
            case SPECIAL: {
                return this.file.exists() && !this.file.isFile() && !this.file.isDirectory();
            }
        }
        return false;
    }

    public final long getSize(Entry.Size type) {
        return this.file.exists() ? this.file.length() : -1L;
    }

    public final long getTime(Entry.Access type) {
        return Entry.Access.WRITE == type && this.file.exists() ? this.file.lastModified() : -1L;
    }

    @Nullable
    public final Set<String> getMembers() {
        String[] list = this.file.list();
        return null == list ? null : new HashSet<String>(Arrays.asList(list));
    }

    public final InputSocket<FileEntry> getInputSocket() {
        return new FileInputSocket(this);
    }

    public final OutputSocket<FileEntry> getOutputSocket() {
        return new FileOutputSocket(this, (BitField<FsOutputOption>)FsOutputOptions.NONE, null);
    }

    final OutputSocket<FileEntry> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileOutputSocket(this, options, template);
    }
}

