/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.IOException;
import org.jwat.arc.ArcHeader;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcRecordBase;
import org.jwat.arc.ArcWriter;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.HttpHeader;
import org.jwat.common.Payload;

public class ArcRecord
extends ArcRecordBase {
    public static final int TOSTRING_BUFFER_SIZE = 256;

    protected ArcRecord() {
    }

    public static ArcRecord createRecord(ArcWriter writer) {
        ArcRecord ar = new ArcRecord();
        ar.trailingNewLines = 1;
        ar.diagnostics = new Diagnostics();
        ar.header = ArcHeader.initHeader(writer, ar.diagnostics);
        writer.fieldParsers.diagnostics = ar.diagnostics;
        return ar;
    }

    public static ArcRecord parseArcRecord(ArcReader reader, Diagnostics<Diagnosis> diagnostics, ArcHeader header, ByteCountingPushBackInputStream in) throws IOException {
        ArcRecord ar = new ArcRecord();
        ar.recordType = 2;
        ar.reader = reader;
        ar.diagnostics = diagnostics;
        ar.header = header;
        ar.in = in;
        ar.processPayload(in, reader);
        ar.consumed = in.getConsumed() - ar.header.startOffset;
        return ar;
    }

    @Override
    protected void processPayload(ByteCountingPushBackInputStream in, ArcReader reader) throws IOException {
        this.payload = null;
        if (this.header.archiveLength != null && this.header.archiveLength > 0L) {
            String digestAlgorithm = null;
            if (reader.bBlockDigest) {
                digestAlgorithm = reader.blockDigestAlgorithm;
            }
            this.payload = Payload.processPayload(in, this.header.archiveLength, reader.payloadHeaderMaxSize, digestAlgorithm);
            this.payload.setOnClosedHandler(this);
            if (HttpHeader.isSupported(this.header.urlScheme)) {
                digestAlgorithm = null;
                if (reader.bPayloadDigest) {
                    digestAlgorithm = reader.payloadDigestAlgorithm;
                }
                this.httpHeader = HttpHeader.processPayload(1, this.payload.getInputStream(), this.header.archiveLength, digestAlgorithm);
                if (this.httpHeader != null) {
                    if (this.httpHeader.isValid()) {
                        this.payload.setPayloadHeaderWrapped(this.httpHeader);
                    } else {
                        this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "http header", "Unable to parse http header!"));
                    }
                }
            }
        } else if (HttpHeader.isSupported(this.header.urlScheme)) {
            this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "ARC file", "Expected payload not found in the record block"));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("\nArcRecord [");
        builder.append(super.toString());
        builder.append(']');
        if (this.httpHeader != null) {
            builder.append(this.httpHeader.toString());
        }
        return builder.toString();
    }
}

