/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.dao.ejb3;

import com.exlibris.core.infra.common.dao.ejb3.BoundedVariable;
import com.exlibris.core.infra.common.dao.ejb3.GenericEjb3Dao;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.JdbcConnectionUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.Session;

public abstract class GenericRepEjb3Dao<T, ID extends Serializable>
extends GenericEjb3Dao<T, ID> {
    private static final ExLogger log = ExLogger.getExLogger(GenericRepEjb3Dao.class, "RPS");
    protected final String PIDS_TMP_TABLE = "selected_pid_tmp_table";
    protected static final int batchSize = 1000;

    @Override
    @PersistenceContext(unitName="ros")
    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    @Override
    protected EntityManager getEntityManager() {
        if (this.em == null) {
            throw new IllegalStateException("EntityManager has not been set on DAO before usage");
        }
        return this.em;
    }

    @Override
    public String[] getIndexArr() {
        String[] indexArr = new String[]{"HDEMETADATA_ID1", "HPAPROCESS_ID1", "HPAPROCESSEXECUTION_ID1", "HPATASK_ID1", "HPATASKCHAIN_ID1", "HDESET_ID1", "HDEMEMBER_ID1", "SIP_REGISTRY_ID1", "REPPROFILE_ID1", "DeliveryViewer_ID1"};
        return indexArr;
    }

    public List<String> getPidsList(String sql, List<BoundedVariable> boundedVariables, int firstResult, int maxResults) {
        ArrayList<BoundedVariable> momentaryBoundedVariables = new ArrayList<BoundedVariable>(boundedVariables);
        sql = this.addBoundariesToNativeQuery(sql, momentaryBoundedVariables, firstResult, maxResults);
        Query query = this.getEntityManager().createNativeQuery(sql);
        this.setQueryParameters(momentaryBoundedVariables, query);
        List objList = query.getResultList();
        ArrayList<String> pidsList = new ArrayList<String>();
        for (Object obj : objList) {
            if (obj instanceof Object[]) {
                Object[] pids = (Object[])obj;
                String pid = (String)pids[0];
                pidsList.add(pid);
                continue;
            }
            pidsList.add((String)obj);
        }
        return pidsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillTemporaryTable(List<String> pids) {
        PreparedStatement ps = null;
        Connection connection = ((Session)this.em.getDelegate()).connection();
        String sql = "insert into selected_pid_tmp_table (ID, PID) values(HIBERNATE_SEQUENCE.NEXTVAL,?)";
        try {
            int[] counts;
            ps = connection.prepareStatement(sql);
            for (int i = 0; i < pids.size(); ++i) {
                ps.setString(1, pids.get(i));
                ps.addBatch();
                if (i == 0 || i % 1000 != 0) continue;
                counts = ps.executeBatch();
                this.checkBatch("selected_pid_tmp_table", counts);
            }
            counts = ps.executeBatch();
            this.checkBatch("selected_pid_tmp_table", counts);
        }
        catch (Exception e) {
            log.error("Failed insert into selected_pid_tmp_table", e, new String[0]);
        }
        finally {
            JdbcConnectionUtil.closeConnections(null, ps, null);
        }
    }
}

