/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.filter;

import com.exlibris.core.infra.common.util.GeneralServerUtil;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.ws.RestrictedIPChecker;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class WebServiceFilter
implements Filter {
    final String HTTP = "http";
    final String HTTPS = "https";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int idx = ((HttpServletRequest)request).getRequestURI().toString().lastIndexOf("/");
        String serviceName = ((HttpServletRequest)request).getRequestURI().toString().substring(idx + 1);
        Boolean hasAccess = RestrictedIPChecker.getInstance().checkAccess(request.getRemoteAddr(), serviceName);
        if (!hasAccess.booleanValue()) {
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        String queryString = ((HttpServletRequest)request).getQueryString();
        boolean sslRequest = false;
        if (queryString != null && queryString.toLowerCase().contains("wsdl")) {
            String uri = ((HttpServletRequest)request).getRequestURI().toString();
            if (uri.contains("/dpsws/repository") && !GeneralServerUtil.serverHasRepRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to repository web services.");
                return;
            }
            if (uri.contains("/dpsws/backoffice") && !GeneralServerUtil.serverHasRepRole() && !GeneralServerUtil.serverHasDepRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to backoffice web services.");
                return;
            }
            if (uri.contains("/dpsws/deposit") && !GeneralServerUtil.serverHasDepRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to deposit web services.");
                return;
            }
            if (uri.contains("/dpsws/delivery") && !GeneralServerUtil.serverHasDelRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to delivery web services.");
                return;
            }
            if (uri.contains("/dpsws/permanent") && !GeneralServerUtil.serverHasPerRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to permanent web services.");
                return;
            }
        }
        String url = ((HttpServletRequest)request).getRequestURL().toString();
        if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.rep")) && GeneralServerUtil.serverHasRepRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.rep.host"))) {
            sslRequest = true;
        } else if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.del")) && GeneralServerUtil.serverHasDelRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.del.host"))) {
            sslRequest = true;
        } else if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.dep")) && GeneralServerUtil.serverHasDepRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.dep.host"))) {
            sslRequest = true;
        } else if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.per")) && GeneralServerUtil.serverHasPerRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.per.host"))) {
            sslRequest = true;
        }
        if (sslRequest) {
            HttpServletRequestWrapper wrapped = new HttpServletRequestWrapper((HttpServletRequest)request){

                public StringBuffer getRequestURL() {
                    String originalUrl = ((HttpServletRequest)this.getRequest()).getRequestURL().toString();
                    return new StringBuffer(originalUrl.replace("http", "https"));
                }
            };
            chain.doFilter((ServletRequest)wrapped, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

