/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.pds;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class PdsConnector {
    private static final ExLogger log = ExLogger.getExLogger(PdsConnector.class);
    private static PdsConnector INSTANCE = new PdsConnector();
    private final Hashtable m_pdsInfoCache = new Hashtable();
    private long m_lastCleaned = 0L;
    private static final long CLEAR_INTERVAL_MS = 300000L;
    private GeneralParameterManager gpm;

    private PdsConnector() {
    }

    public static PdsConnector getInstance() {
        return INSTANCE;
    }

    private synchronized void cleanPdsInfoCache() {
        if (System.currentTimeMillis() > this.m_lastCleaned + 300000L) {
            this.m_pdsInfoCache.clear();
            this.m_lastCleaned = System.currentTimeMillis();
        }
    }

    public String getId(String handle) throws InfraException {
        if (handle == null) {
            throw new InfraException(DescriptorConstants.LY_CantGetIDFromPds, (Object)handle, PdsConnector.class);
        }
        String idXml = this.concatFullPdsUrl("get-attribute", false, "BOR_ID", handle, null);
        try {
            return this.parseId(this.getUrlContents(idXml));
        }
        catch (Exception e) {
            throw new InfraException(DescriptorConstants.LY_CantGetIDFromPds, (Object)idXml, e, PdsConnector.class);
        }
    }

    public String getUserInfoByUserId(String id) throws InfraException {
        if (id != null && id.startsWith("GUEST")) {
            return "Error User does not exist";
        }
        String userInfoUrl = this.concatFullPdsUrl("get-attribute-1", true, "BOR_INFO", null, null, null, "DIGITOOL", id);
        try {
            return this.getUrlContents(userInfoUrl);
        }
        catch (Exception e) {
            throw new InfraException(DescriptorConstants.LY_CantGetUserInfoFromPds, (Object)userInfoUrl, e, PdsConnector.class);
        }
    }

    private String getUserInfoByPdsHandle(String handle) throws InfraException {
        String userInfoUrl = this.concatFullPdsUrl("get-attribute", true, "BOR_INFO", handle, null);
        try {
            return this.getUrlContents(userInfoUrl);
        }
        catch (Exception e) {
            throw new InfraException(DescriptorConstants.LY_CantGetUserInfoFromPds, (Object)userInfoUrl, e, PdsConnector.class);
        }
    }

    private PdsUserInfo getPdsUserInfoInternal(String attribute, boolean byHandle) {
        String xml;
        this.cleanPdsInfoCache();
        String hashId = byHandle ? "pds_handle:" + attribute : "pds_user_id:" + attribute;
        log.debug((Object)("getPdsUserInfoInternal=" + hashId), new String[0]);
        PdsUserInfo info = null;
        info = (PdsUserInfo)this.m_pdsInfoCache.get(hashId);
        if (info != null) {
            log.debug((Object)("getPdsUserInfoInternal cache=" + info.getUserId()), new String[0]);
            return info;
        }
        try {
            xml = byHandle ? this.getUserInfoByPdsHandle(attribute) : this.getUserInfoByUserId(attribute);
        }
        catch (Exception e) {
            log.debug((Object)"getPdsUserInfoInternal error getting xml", new String[0]);
            return this.createGuestInfo(hashId);
        }
        if (xml == null || xml.indexOf("Error User does not exist") > 0) {
            log.debug((Object)"getPdsUserInfoInternal error in xml", new String[0]);
            return this.createGuestInfo(hashId);
        }
        try {
            log.debug((Object)"getPdsUserInfoInternal parsing xml", new String[0]);
            info = this.parseUserInfo(xml);
            this.m_pdsInfoCache.put(hashId, info);
            return info;
        }
        catch (DocumentException e) {
            log.error(DescriptorConstants.GN_ExceptionWithMsg, (Object)"Error parsing user details, using GUEST account", (Object)e.getMessage(), e.getCause());
            return this.createGuestInfo(hashId);
        }
    }

    public PdsUserInfo getPdsUserInfoByUserId(String userId) {
        return this.getPdsUserInfoInternal(userId, false);
    }

    public PdsUserInfo getPdsUserInfoByPdsHandle(String pdsHandle) {
        return this.getPdsUserInfoInternal(pdsHandle, true);
    }

    public String concatFullPdsUrl(String func, boolean retUrlFlag, String attr, String handle, String id, String password, String institute, String authId) throws InfraException {
        String basePdsUrl = this.getGeneralParmameterManger().getParameter("pds", "pds_url");
        StringBuffer fullPdsUrl = new StringBuffer(basePdsUrl);
        fullPdsUrl.append("func").append("=").append(func);
        if (authId != null && authId != "") {
            fullPdsUrl.append("&").append("bor_id").append("=").append(authId);
        }
        if (institute != null && institute != "") {
            fullPdsUrl.append("&").append("institute").append("=").append(institute);
        }
        if (password != null && password != "") {
            fullPdsUrl.append("&").append("bor_verification").append("=").append(password);
        }
        if (handle != null && handle != "") {
            fullPdsUrl.append("&").append("pds_handle").append("=").append(handle);
        }
        if (attr != null && attr != "") {
            fullPdsUrl.append("&").append("attribute").append("=").append(attr);
        }
        if (id != null && id != "") {
            fullPdsUrl.append("&").append("pds_exl_id").append("=").append(id);
        }
        if (authId == null) {
            fullPdsUrl.append("&").append("calling_system").append("=").append(this.getGeneralParmameterManger().getParameter("pds", "calling_system"));
        }
        if (retUrlFlag) {
            fullPdsUrl.append("&").append("url").append("=").append(this.getGeneralParmameterManger().getParameter("pds", "return_url")).toString();
        }
        log.debug((Object)("concatFullPdsUrl url=" + fullPdsUrl.toString()), new String[0]);
        return fullPdsUrl.toString();
    }

    public String concatFullPdsUrl(String func, boolean retUrlFlag, String attr, String handle, String id) throws InfraException {
        return this.concatFullPdsUrl(func, retUrlFlag, attr, handle, id, null, null, null);
    }

    public String getUrlContents(String pdsHandle) throws MalformedURLException, IOException {
        String line;
        StringBuffer fullPdsUrl = null;
        String basePdsUrl = null;
        String returnUrl = null;
        try {
            basePdsUrl = this.getBasePdsUrl();
            returnUrl = this.getGeneralParmameterManger().getParameter("pds", "return_url");
            fullPdsUrl = new StringBuffer(basePdsUrl);
        }
        catch (Exception e) {
            log.error(e);
        }
        fullPdsUrl.append("func").append("=").append("bor-info").append("&").append("calling_system").append("=").append("dps").append("&").append("pds_handle").append("=").append(pdsHandle).append("&").append("url").append("=").append(returnUrl);
        String urlInput = new String(fullPdsUrl.toString());
        URL theUrl = new URL(urlInput);
        URLConnection conn = theUrl.openConnection();
        BufferedReader bufferedReader = null;
        try {
            conn.connect();
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            bufferedReader = httpConn.getResponseCode() < 400 ? new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(httpConn.getErrorStream(), "UTF-8"));
        }
        catch (IOException e) {
            log.error("could not get InputStream from connection " + fullPdsUrl, new String[0]);
            e.printStackTrace();
            throw e;
        }
        StringBuffer content = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            content.append(line);
        }
        bufferedReader.close();
        log.debug((Object)("getUrlContents content=" + content.toString()), new String[0]);
        return content.toString();
    }

    private String getBasePdsUrl() throws InfraException {
        String basePdsUrl = this.getGeneralParmameterManger().getParameter("pds", "pds_internal_url");
        if (StringUtils.isEmptyString(basePdsUrl)) {
            basePdsUrl = this.getGeneralParmameterManger().getParameter("pds", "pds_url");
        }
        return basePdsUrl;
    }

    public PdsUserInfo getUserInfo(String pdsHandle) {
        try {
            String content = this.getUrlContents(pdsHandle);
            PdsUserInfo userInfo = new PdsUserInfo();
            userInfo.setUserName(this.parseTag(content, "id"));
            userInfo.setBorDeptM(this.parseTag(content, "institute"));
            userInfo.setBorGroup(this.parseTag(content, "group"));
            return userInfo;
        }
        catch (Exception e) {
            log.error("Failed getting URL content for pds handle: " + pdsHandle, e, new String[0]);
            return null;
        }
    }

    public String parseTag(String xml, String tag) {
        StringBuffer str = new StringBuffer(xml);
        int sessIdnex = str.indexOf("<" + tag + ">");
        int sessEndIdnex = str.indexOf("</" + tag + ">");
        if (sessIdnex != -1) {
            String ret = str.substring(sessIdnex += ("<" + tag + ">").length(), sessEndIdnex);
            return ret;
        }
        return null;
    }

    public String parseId(String xml) {
        return this.parseTag(xml, "<id>");
    }

    private PdsUserInfo createGuestInfo(String id) {
        PdsUserInfo info = new PdsUserInfo();
        info.setUserId("GUEST");
        info.setUserName("GUEST");
        this.m_pdsInfoCache.put(id, info);
        return info;
    }

    private PdsUserInfo parseUserInfo(String xml) throws DocumentException {
        PdsUserInfo info = new PdsUserInfo();
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(xml));
        log.debug((Object)("User Info=" + xml), new String[0]);
        Node node = document.selectSingleNode("//bor-info/id");
        if (node != null) {
            info.setUserId(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/id")) != null) {
            info.setUserName(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/group")) != null) {
            info.setBorGroup(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/expiry_date")) != null) {
            info.setExpiryDate(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/bor_dept_m")) != null) {
            log.debug((Object)("User Info:bor_dept_m=" + node.getText()), new String[0]);
            info.setBorDeptM(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/bor_group_m")) != null) {
            log.debug((Object)("User Info:bor_group_m=" + node.getText()), new String[0]);
            info.setBorGroup(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/course_enrollment_m")) != null) {
            log.debug((Object)("User Info:bor_course_m=" + node.getText()), new String[0]);
            info.setBorGroupM(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/bor_tuples_m")) != null) {
            log.debug((Object)("User Info:bor_tuples_m=" + node.getText()), new String[0]);
            info.setBorTuplesM(node.getText());
        }
        return info;
    }

    private GeneralParameterManager getGeneralParmameterManger() {
        if (this.gpm == null) {
            this.gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        }
        return this.gpm;
    }
}

