/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.svc;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.storage.Storage;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.services.storage.StorageService;
import com.exlibris.core.sdk.storage.handler.StorageHandler;
import java.util.HashMap;
import java.util.Map;

public class StorageCacheManager {
    private static StorageCacheManager storageCacheManager;
    private Map<Long, StorageHandler> storageById = new HashMap<Long, StorageHandler>();
    private Map<Long, Integer> storageVersionByStorageId = new HashMap<Long, Integer>();
    private static ExLogger logger;

    public static StorageCacheManager getInstance() {
        if (storageCacheManager == null) {
            storageCacheManager = new StorageCacheManager();
        }
        return storageCacheManager;
    }

    public void addStorageHandler(Storage storage, StorageHandler storageHandler) {
        this.storageById.put(storage.getId(), storageHandler);
        this.storageVersionByStorageId.put(storage.getId(), storage.getVersion());
    }

    public StorageHandler getStorageHandler(Long storageId) {
        this.refreshStorageCache(storageId);
        return this.storageById.get(storageId);
    }

    private StorageCacheManager() {
    }

    private void refreshStorageCache(Long storageId) {
        Integer version;
        if (this.storageById.get(storageId) == null) {
            return;
        }
        StorageService storageService = (StorageService)ServiceLocator.getInstance().lookUp(StorageService.class);
        if (storageService.isStorageObsolete(storageId, version = this.storageVersionByStorageId.get(storageId)).booleanValue()) {
            this.storageVersionByStorageId.put(storageId, null);
            this.storageById.put(storageId, null);
        }
    }

    static {
        logger = ExLogger.getExLogger(StorageCacheManager.class);
    }
}

