/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.email;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.infrastructure.email.DigitoolMailMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;

public class MailHandler {
    private String protocol;
    private Store store = null;
    private Folder folder = null;
    private Message[] msgs;
    private int currentMessage;
    private int totalMessages;
    private String tempStreamsFolder;
    private static final String IMAP = "imap";

    public MailHandler(String protocol, String tempStreamsFolder) {
        this.protocol = protocol;
        this.tempStreamsFolder = tempStreamsFolder;
    }

    public void connect(String hostname, int port, String username, String password) throws MessagingException {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        this.store = this.protocol != null ? session.getStore(this.protocol) : session.getStore();
        this.store.connect(hostname, port, username, password);
    }

    public void fetchFolder(String folderName, String failedFolder, String SuccessFolder) throws MessagingException, DigitoolException {
        if (folderName == null) {
            folderName = "DTL_INBOX";
        }
        this.folder = this.store.getDefaultFolder();
        if (this.folder == null) {
            throw new DigitoolException(DescriptorConstants.IG_FailedToConnectMailServer, " getDefaultFolder");
        }
        this.folder = this.folder.getFolder(folderName);
        if (this.folder == null) {
            throw new DigitoolException(DescriptorConstants.IG_FailedToConnectMailServer, " getFoler " + folderName);
        }
        this.folder.open(2);
        this.setMailFolder(this.folder);
        this.setTotalMessages(this.folder.getMessageCount());
        if (this.totalMessages == 0) {
            this.closeConnection(false);
            return;
        }
        this.setMsgs(this.folder.getMessages());
        this.setCurrentMessage(0);
        if (this.protocol == IMAP) {
            this.createFolder(failedFolder);
            this.createFolder(SuccessFolder);
        }
    }

    public void closeConnection(boolean delete) throws MessagingException {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(delete);
        }
        if (this.store != null) {
            this.store.close();
        }
    }

    public DigitoolMailMessage processNext() throws MessagingException, IOException {
        return this.process(this.currentMessage++);
    }

    public DigitoolMailMessage process(int msgNum) throws MessagingException, IOException {
        Message message = this.getMessage(msgNum);
        DigitoolMailMessage digitoolMessage = new DigitoolMailMessage();
        this.handleGeneralMailFields(message, digitoolMessage, msgNum);
        Object content = message.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                this.handlePart((Part)multipart.getBodyPart(i), digitoolMessage, msgNum, i);
            }
        } else {
            this.handlePart((Part)message, digitoolMessage, msgNum, 0);
        }
        return digitoolMessage;
    }

    public void handlePart(Part part, DigitoolMailMessage digitoolMessage, int msgNum, int subMsgNum) throws MessagingException, IOException {
        String disposition = part.getDisposition();
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.handlePart((Part)mp.getBodyPart(i), digitoolMessage, msgNum, i);
            }
        }
        if (disposition == null) {
            this.handleBody(part, digitoolMessage, msgNum);
        }
        if (disposition != null && (disposition.toLowerCase().equals("attachment") || disposition.toLowerCase().equals("inline"))) {
            this.handleAttachment(part, digitoolMessage, msgNum, subMsgNum);
        }
    }

    private void handleBody(Part part, DigitoolMailMessage digitoolMessage, int msgNum) throws IOException, MessagingException {
        String contentType = part.getContentType();
        String ext = "";
        if (contentType.toLowerCase().startsWith("text/plain") || contentType.toLowerCase().startsWith("text/html") || contentType.toLowerCase().startsWith("text/rtf")) {
            if (contentType.toLowerCase().startsWith("text/plain")) {
                ext = ".txt";
            }
            if (contentType.toLowerCase().startsWith("text/html")) {
                ext = ".htm";
            }
            if (contentType.toLowerCase().startsWith("text/rtf")) {
                ext = ".rtf";
            }
            String filename = msgNum + "_mail_body" + ext;
            this.saveFile(filename, part.getInputStream());
            this.addBody(digitoolMessage, filename);
        }
    }

    private void handleAttachment(Part part, DigitoolMailMessage digitoolMessage, int msgNum, int subMsgNum) throws MessagingException, IOException {
        String filename = part.getFileName();
        if (filename == null) {
            filename = "att";
        }
        filename = msgNum + "_" + subMsgNum + "_" + filename;
        this.saveFile(filename, part.getInputStream());
        this.addAttachment(digitoolMessage, filename);
    }

    public void copyMessage(int msgNum, String folderName) throws MessagingException {
        this.copyMessage(this.getMessage(msgNum), folderName);
    }

    private void copyMessage(Message message, String folderName) throws MessagingException {
        if (this.protocol != IMAP) {
            return;
        }
        Folder newFolder = this.folder.getFolder(folderName);
        if (newFolder == null) {
            throw new MessagingException("No " + folderName + " folder exists under " + this.folder.getName());
        }
        Message[] copyMsgs = new Message[]{message};
        this.folder.copyMessages(copyMsgs, newFolder);
        message.setFlag(Flags.Flag.DELETED, true);
    }

    private void createFolder(String folderName) throws MessagingException {
        Folder newFolder = this.folder.getFolder(folderName);
        if (newFolder == null || !newFolder.exists()) {
            newFolder.create(1);
        }
    }

    private void saveFile(String filename, InputStream in) throws IOException {
        File file = new File(this.tempStreamsFolder, filename);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            if (in != null) {
                IOUtil.copy(in, (OutputStream)bos);
            }
        }
    }

    private void handleGeneralMailFields(Message message, DigitoolMailMessage digitoolMessage, int msgNum) throws MessagingException {
        this.addMailFields(digitoolMessage, "messageId", Integer.toString(msgNum + 1));
        String from = null;
        Address[] fromArray = message.getFrom();
        if (fromArray != null) {
            from = ((InternetAddress)fromArray[0]).getPersonal();
            if (from == null || from.length() == 0) {
                from = ((InternetAddress)fromArray[0]).getAddress();
            }
            this.addMailFields(digitoolMessage, "from", from);
        }
        String to = null;
        Address[] a = message.getRecipients(Message.RecipientType.TO);
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                to = a[i].toString();
                this.addMailFields(digitoolMessage, "to", to);
            }
        }
        String cc = "";
        a = message.getRecipients(Message.RecipientType.CC);
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                cc = a[i].toString();
                this.addMailFields(digitoolMessage, "cc", cc);
            }
        }
        String subject = message.getSubject();
        this.addMailFields(digitoolMessage, "subject", subject);
        Date d = message.getSentDate();
        this.addMailFields(digitoolMessage, "sentDate", DateHandler.formatDateAndTime(d));
        this.addMailFields(digitoolMessage, "folder", this.folder.getFullName());
    }

    private void addMailFields(DigitoolMailMessage digitoolMessage, String fieldName, String value) {
        digitoolMessage.addMailField(fieldName, value);
    }

    private void addBody(DigitoolMailMessage digitoolMessage, String fileName) throws IOException {
        if (digitoolMessage.getBodyFile() != null && digitoolMessage.getBodyFile().endsWith("htm")) {
            return;
        }
        if (digitoolMessage.getBodyFile() != null) {
            FileUtil.forceDelete(new File(this.tempStreamsFolder, digitoolMessage.getBodyFile()));
        }
        digitoolMessage.addBodyFile(fileName);
    }

    private void addAttachment(DigitoolMailMessage digitoolMessage, String path) {
        digitoolMessage.addAttachment(path);
    }

    public Folder getMailFolder() {
        return this.folder;
    }

    public void setMailFolder(Folder folder) {
        this.folder = folder;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Message[] getMsgs() {
        return this.msgs;
    }

    public Message getMessage(int num) {
        return this.msgs[num];
    }

    private void setMsgs(Message[] msgs) {
        this.msgs = msgs;
    }

    public int getTotalMessages() {
        return this.totalMessages;
    }

    private void setTotalMessages(int totalMessages) {
        this.totalMessages = totalMessages;
    }

    public int getCurrentMessage() {
        return this.currentMessage;
    }

    private void setCurrentMessage(int currentMessage) {
        this.currentMessage = currentMessage;
    }
}

