/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.oai;

import com.exlibris.digitool.infrastructure.oai.OAIDCSaxParser;
import com.exlibris.digitool.infrastructure.xml.XMLNormalizer;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class OAISaxParser
extends DefaultHandler
implements LexicalHandler {
    protected StringBuffer textBuffer = new StringBuffer();
    protected StringBuffer contentBuffer = new StringBuffer();
    protected int indentLevel = 0;
    protected int elementLevel = 0;
    protected String errorCode = null;
    protected String errorText = null;
    protected String resumptionToken = null;
    protected String responseDate = null;
    protected String elementName = "record";
    protected boolean inElement = false;
    protected Vector elementVector = new Vector();

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() {
        this.elementVector = new Vector();
        this.textBuffer = new StringBuffer();
        this.contentBuffer = new StringBuffer();
        this.indentLevel = 0;
        this.elementLevel = 0;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        ++this.indentLevel;
        if (eName.equalsIgnoreCase("error")) {
            this.errorCode = attrs.getValue("code");
            this.errorText = "";
            return;
        }
        if (eName.equalsIgnoreCase("resumptionToken")) {
            this.resumptionToken = this.textBuffer.toString().trim();
            this.textBuffer = new StringBuffer();
            return;
        }
        if (eName.equalsIgnoreCase("responseDate")) {
            this.responseDate = this.textBuffer.toString().trim();
            this.textBuffer = new StringBuffer();
            return;
        }
        if (eName.equalsIgnoreCase("ListRecords")) {
            this.resumptionToken = "";
        }
        if (eName.equalsIgnoreCase(this.elementName)) {
            if (this.elementLevel == 0) {
                this.elementLevel = this.indentLevel;
            }
            if (this.elementLevel == this.indentLevel) {
                this.contentBuffer = new StringBuffer();
                this.inElement = true;
            }
        }
        this.contentBuffer.append("<" + eName + this.attributesToString(attrs) + ">");
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equalsIgnoreCase("error")) {
            this.errorText = this.textBuffer.toString().trim();
            this.textBuffer = new StringBuffer();
        }
        if (eName.equalsIgnoreCase("resumptionToken")) {
            this.resumptionToken = this.textBuffer.toString().trim();
            this.textBuffer = new StringBuffer();
        }
        if (eName.equalsIgnoreCase("responseDate")) {
            this.responseDate = this.textBuffer.toString().trim();
            this.textBuffer = new StringBuffer();
        }
        this.contentBuffer.append("</" + eName + ">");
        if (eName.equalsIgnoreCase(this.elementName) && this.indentLevel == this.elementLevel) {
            this.inElement = false;
            String str = this.contentBuffer.toString();
            this.addElementToList(str);
            this.contentBuffer = new StringBuffer();
        }
        --this.indentLevel;
    }

    protected void addElementToList(String str) {
        this.elementVector.add(str);
    }

    protected String attributesToString(Attributes attrs) {
        StringBuffer attString = new StringBuffer();
        if (attrs != null && attrs.getLength() > 0) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                attString.append(" " + aName + "=\"" + attrs.getValue(i) + "\"");
            }
        }
        return attString.toString();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = XMLNormalizer.normalize(new String(buf, offset, len));
        if (this.inElement) {
            this.contentBuffer.append(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public String getResonseDate() {
        return this.responseDate;
    }

    public List getElementList() {
        return this.elementVector;
    }

    public static String getUrlContent(String url) {
        return "";
    }

    public static void main(String[] args) {
        try {
            OAIDCSaxParser handler = new OAIDCSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(args[0], (DefaultHandler)handler);
            String str = handler.getErrorCode();
            str = handler.getErrorText();
            str = handler.getResumptionToken();
            List v = handler.getElementList();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                str = (String)v.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

