/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.delivery;

import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import com.exlibris.dps.sdk.access.Access;
import com.exlibris.dps.sdk.access.AccessException;
import com.exlibris.dps.sdk.access.AccessFactory;
import com.exlibris.dps.sdk.delivery.ViewerPreProcessor;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractViewerPreProcessor
implements ViewerPreProcessor {
    protected DnxDocument dnx;
    protected Map<String, String> viewContext;
    protected HttpServletRequest request;
    protected String dvs;
    protected String owner;
    protected String ieParentId;
    protected String repDirName;
    Access access;

    @Override
    public void init(DnxDocument dnx, Map<String, String> viewContext, HttpServletRequest request, String dvs, String ieParentId, String repDirName) throws AccessException {
        this.dnx = dnx;
        this.viewContext = viewContext;
        this.request = request;
        this.dvs = dvs;
        this.ieParentId = ieParentId;
        this.repDirName = repDirName;
    }

    protected String getRequestParameter(String paramName) {
        String paramVal = "";
        if (this.request != null && (paramVal = this.request.getParameter(paramName)) == null) {
            paramVal = "";
        }
        return paramVal;
    }

    protected DnxDocument getDnx() {
        return this.dnx;
    }

    protected Map<String, String> getViewContext() {
        return this.viewContext;
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public String getDvs() {
        return this.dvs;
    }

    @Override
    public String getPid() {
        return AbstractViewerPreProcessor.getIID(this.getDnx(), "PID");
    }

    @Override
    public boolean runASync() {
        return false;
    }

    @Override
    public String getAdditionalParameters() {
        return null;
    }

    private static String getIID(DnxDocument dnxDoc, String iidType) {
        List<DnxSectionRecord> recordList;
        DnxSection internalId = dnxDoc.getSectionById("internalIdentifier");
        if (internalId != null && (recordList = internalId.getRecordList()) != null) {
            for (DnxSectionRecord record : recordList) {
                String currType = record.getSectionKeyValue(DNXConstants.INTERNALIDENTIFIER.INTERNALIDENTIFIERTYPE.sectionKeyId);
                if (!currType.equals(iidType)) continue;
                String value = record.getSectionKeyValue(DNXConstants.INTERNALIDENTIFIER.INTERNALIDENTIFIERVALUE.sectionKeyId);
                return value;
            }
        }
        return null;
    }

    protected Access getAccess() throws Exception {
        if (this.access == null) {
            return AccessFactory.create();
        }
        return this.access;
    }
}

