/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.tools;

import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.dps.tools.UiFilenameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Set;

public class UICustomizationTool {
    private static Properties uiCustomizationSettings = null;
    private static String otbDirPath = null;
    private static String customizeDirPath = null;
    private static final String UI_CUSTOMIZATION_FILE_NAME = "ui_customization_files.properties";
    private static final String UI_CUSTOMIZATION_DIR_NAME = "ui";
    private static final String OTB_DIR_NAME = "otb";
    private static final String CUSTOMIZE_DIR_NAME = "customize";
    public static final String ARG_INIT = "-init";
    public static final String ARG_DEPLOY = "-deploy";
    public static final String ARG_UNDEPLOY = "-undeploy";

    public static void main(String[] args) {
        block9: {
            if (args == null || args.length < 1 || args.length > 2 || args[0] == null) {
                UICustomizationTool.usage();
                return;
            }
            String homeDir = System.getProperty("digitool.home");
            if ((homeDir == null || homeDir.trim().length() == 0) && args.length == 2 && (homeDir = args[1]) != null && homeDir.trim().length() > 0) {
                System.setProperty("digitool.home", homeDir);
            }
            otbDirPath = FSUtil.getProfileDir() + UI_CUSTOMIZATION_DIR_NAME + File.separator + OTB_DIR_NAME;
            customizeDirPath = FSUtil.getProfileDir() + UI_CUSTOMIZATION_DIR_NAME + File.separator + CUSTOMIZE_DIR_NAME;
            try {
                uiCustomizationSettings = new Properties();
                String uiCustomizationFilePath = FSUtil.getSystemConfDir() + UI_CUSTOMIZATION_FILE_NAME;
                uiCustomizationSettings.load(new FileInputStream(uiCustomizationFilePath));
            }
            catch (Exception e) {
                UICustomizationTool.reportException(e);
                return;
            }
            try {
                String arg = args[0].trim();
                if (arg.equalsIgnoreCase(ARG_INIT)) {
                    System.out.println("Initializing all customization files...");
                    UICustomizationTool.init();
                    System.out.println("Done.");
                    break block9;
                }
                if (arg.equalsIgnoreCase(ARG_DEPLOY)) {
                    System.out.println("Copying files from the customization directory to the deploy directory...");
                    UICustomizationTool.copy2DeployDir(customizeDirPath);
                    System.out.println("Done.");
                    break block9;
                }
                if (arg.equalsIgnoreCase(ARG_UNDEPLOY)) {
                    System.out.println("Copying files from the out-of-the-box directory to the deploy directory...");
                    UICustomizationTool.copy2DeployDir(otbDirPath);
                    System.out.println("Done.");
                    break block9;
                }
                UICustomizationTool.usage();
                return;
            }
            catch (Exception e) {
                UICustomizationTool.reportException(e);
                return;
            }
        }
    }

    private static void init() throws Exception {
        String deployDir = FSUtil.getDpsDeployDir();
        Set<Object> fileNames = uiCustomizationSettings.keySet();
        for (String string : fileNames) {
            String filePath = uiCustomizationSettings.getProperty(string);
            File sourceFile = new File(deployDir + filePath);
            String targetInOtbDirStr = otbDirPath + File.separator + string;
            try {
                File targetInOtbDir = new File(targetInOtbDirStr);
                if (!targetInOtbDir.exists()) {
                    UICustomizationTool.copyFile(sourceFile, targetInOtbDir);
                }
            }
            catch (Throwable t) {
                System.out.println("Problem copying " + sourceFile.getAbsolutePath() + " to " + targetInOtbDirStr);
            }
            String targetInCustomizeDirStr = customizeDirPath + File.separator + string;
            try {
                File targetInCustomizeDir = new File(targetInCustomizeDirStr);
                if (targetInCustomizeDir.exists()) continue;
                UICustomizationTool.copyFile(sourceFile, targetInCustomizeDir);
            }
            catch (Throwable t) {
                System.out.println("Problem copying " + sourceFile.getAbsolutePath() + " to " + targetInCustomizeDirStr);
            }
        }
    }

    private static void copy2DeployDir(String sourceDir) throws Exception {
        String deployDir = FSUtil.getDpsDeployDir();
        File[] uiFiles = new File(sourceDir).listFiles(new UiFilenameFilter());
        if (uiFiles != null) {
            for (int i = 0; i < uiFiles.length; ++i) {
                File uiFile = uiFiles[i];
                String originalFilePath = uiCustomizationSettings.getProperty(uiFile.getName());
                try {
                    UICustomizationTool.copyFile(uiFile, new File(deployDir + originalFilePath));
                    continue;
                }
                catch (Throwable t) {
                    System.out.println("Problem copying " + uiFile.getAbsolutePath() + " to " + deployDir + originalFilePath);
                }
            }
        }
    }

    private static void reportException(Exception exception) {
        System.err.println("ERROR! " + exception.getClass().getName() + " :: " + exception.getMessage());
        exception.printStackTrace();
    }

    private static void usage() {
        System.out.println("USAGE");
        System.out.println("\tUICustomizationTool [-init | -deploy | -undeploy]");
        System.out.println("OPTIONS");
        System.out.println("\tThe following options are supporrted:");
        System.out.println("\t-init\t\t\tInitializes all customization files.");
        System.out.println("\t-deploy\t\t\tCopies files from the customization directory to the deploy directory.");
        System.out.println("\t-undeploy\t\tCopies files from the out-of-the-box directory to the deploy directory.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(in);
            fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }
}

