/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ShadingMeshPattern;
import org.icepdf.core.util.Library;

public class ShadingType6Pattern
extends ShadingMeshPattern {
    private static final Logger logger = Logger.getLogger(ShadingType6Pattern.class.toString());
    private ArrayList<Point2D.Float> coordinates = new ArrayList();
    private ArrayList<Color> colorComponents = new ArrayList();

    public ShadingType6Pattern(Library l, HashMap h, Stream meshDataStream) {
        super(l, h, meshDataStream);
    }

    public void init(GraphicsState graphicsState) {
        this.coordinates = new ArrayList();
        this.colorComponents = new ArrayList();
        try {
            while (this.vertexBitStream.available() > 0) {
                int i;
                int ii;
                int flag = this.readFlag();
                int n = ii = flag != 0 ? 8 : 12;
                for (i = 0; i < ii; ++i) {
                    this.coordinates.add(this.readCoord());
                }
                int n2 = ii = flag != 0 ? 2 : 4;
                for (i = 0; i < ii; ++i) {
                    this.colorComponents.add(this.readColor());
                }
            }
        }
        catch (IOException e) {
            logger.warning("Error parsing Shading type 6 pattern vertices.");
        }
    }

    public Paint getPaint() throws InterruptedException {
        return this.colorComponents.get(0);
    }
}

